/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.persistence.jta;

import javax.naming.InitialContext;
import javax.transaction.SystemException;
import javax.transaction.UserTransaction;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.util.JTAHelper;
import org.jbpm.JbpmException;
import org.jbpm.persistence.db.DbPersistenceService;
import org.jbpm.persistence.db.DbPersistenceServiceFactory;

public class JtaDbPersistenceService
extends DbPersistenceService {
    private static final long serialVersionUID = 1L;
    boolean isJtaTxCreated = false;

    public JtaDbPersistenceService(DbPersistenceServiceFactory persistenceServiceFactory) {
        super(persistenceServiceFactory);
        if (!this.isCurrentJtaTransactionAvailable()) {
            this.beginJtaTransaction();
            this.isJtaTxCreated = true;
        }
    }

    public void close() {
        super.close();
        if (this.isJtaTxCreated) {
            this.endJtaTransaction();
        }
    }

    boolean isCurrentJtaTransactionAvailable() {
        SessionFactoryImplementor sessionFactoryImplementor = (SessionFactoryImplementor)this.persistenceServiceFactory.getSessionFactory();
        return JTAHelper.isTransactionInProgress((SessionFactoryImplementor)sessionFactoryImplementor);
    }

    void beginJtaTransaction() {
        try {
            this.getUserTransaction().begin();
        }
        catch (Exception e) {
            throw new JbpmException("couldn't start JTA transaction", e);
        }
    }

    void endJtaTransaction() {
        int status = -1;
        UserTransaction userTransaction = this.getUserTransaction();
        try {
            status = userTransaction.getStatus();
        }
        catch (SystemException e) {
            throw new JbpmException("couldn't get status for user transaction", e);
        }
        boolean isRollback = JTAHelper.isRollback((int)status);
        if (isRollback) {
            try {
                userTransaction.rollback();
            }
            catch (Exception e) {
                throw new JbpmException("couldn't rollback JTA transaction", e);
            }
        }
        try {
            userTransaction.commit();
        }
        catch (Exception e) {
            throw new JbpmException("couldn't commit JTA transaction", e);
        }
    }

    UserTransaction getUserTransaction() {
        UserTransaction userTransaction = null;
        if (userTransaction == null) {
            String jndiName = "UserTransaction";
            try {
                userTransaction = (UserTransaction)new InitialContext().lookup(jndiName);
            }
            catch (Exception e) {
                throw new JbpmException("couldn't lookup UserTransaction in JNDI with name " + jndiName, e);
            }
        }
        return userTransaction;
    }

    public boolean isJtaTxCreated() {
        return this.isJtaTxCreated;
    }

    public void setJtaTxCreated(boolean isJtaTxCreated) {
        this.isJtaTxCreated = isJtaTxCreated;
    }
}

