/*
 * Decompiled with CFR 0.152.
 */
package com.icesoft.faces.context;

import com.icesoft.faces.application.ViewHandlerProxy;
import com.icesoft.faces.context.BridgeExternalContext;
import com.icesoft.faces.context.DOMResponseWriter;
import com.icesoft.faces.context.DOMSerializer;
import com.icesoft.faces.context.NormalModeSerializer;
import com.icesoft.faces.context.PushModeSerializer;
import com.icesoft.faces.context.Resource;
import com.icesoft.faces.context.ResourceLinker;
import com.icesoft.faces.context.ResourceRegistry;
import com.icesoft.faces.el.ELContextImpl;
import com.icesoft.faces.webapp.command.CommandQueue;
import com.icesoft.faces.webapp.command.Reload;
import com.icesoft.faces.webapp.http.common.Configuration;
import com.icesoft.faces.webapp.http.core.ResourceDispatcher;
import com.icesoft.util.SeamUtilities;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.regex.Pattern;
import javax.el.ELContext;
import javax.faces.FacesException;
import javax.faces.FactoryFinder;
import javax.faces.application.Application;
import javax.faces.application.ApplicationFactory;
import javax.faces.application.FacesMessage;
import javax.faces.application.ViewHandler;
import javax.faces.component.UIViewRoot;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseStream;
import javax.faces.context.ResponseWriter;
import javax.faces.render.RenderKit;
import javax.faces.render.RenderKitFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class BridgeFacesContext
extends FacesContext
implements ResourceRegistry {
    private static final Log log = LogFactory.getLog((Class)BridgeFacesContext.class);
    private static final Pattern PageTemplatePattern = Pattern.compile(".*(\\.iface$|\\.jsf$|\\.faces$|\\.jsp$|\\.jspx$|\\.xhtml$|\\.seam$)");
    private Application application;
    private BridgeExternalContext externalContext;
    private HashMap faceMessages = new HashMap();
    private FacesMessage.Severity maxSeverity;
    private boolean renderResponse;
    private boolean responseComplete;
    private ResponseStream responseStream;
    private ResponseWriter responseWriter;
    private DOMSerializer domSerializer;
    private UIViewRoot viewRoot;
    private String iceFacesId;
    private String viewNumber;
    private CommandQueue commandQueue;
    private Configuration configuration;
    private Collection jsCodeURIs = new ArrayList();
    private Collection cssRuleURIs = new ArrayList();
    private ResourceDispatcher resourceDispatcher;
    private ELContext elContext;

    public BridgeFacesContext(BridgeExternalContext externalContext, String view, String icefacesID, CommandQueue commandQueue, Configuration configuration, ResourceDispatcher resourceDispatcher) {
        BridgeFacesContext.setCurrentInstance((FacesContext)this);
        this.externalContext = externalContext;
        this.viewNumber = view;
        this.iceFacesId = icefacesID;
        this.commandQueue = commandQueue;
        this.configuration = configuration;
        this.application = ((ApplicationFactory)FactoryFinder.getFactory((String)"javax.faces.application.ApplicationFactory")).getApplication();
        this.externalContext = externalContext;
        this.resourceDispatcher = resourceDispatcher;
        this.switchToNormalMode();
    }

    public void setCurrentInstance() {
        BridgeFacesContext.setCurrentInstance((FacesContext)this);
    }

    public void resetCurrentInstance() {
        FacesContext.setCurrentInstance(null);
    }

    public Application getApplication() {
        return this.application;
    }

    public void setApplication(Application application) {
        this.application = application;
    }

    public Iterator getClientIdsWithMessages() {
        return this.faceMessages.keySet().iterator();
    }

    public ExternalContext getExternalContext() {
        return this.externalContext;
    }

    public void setExternalContext(ExternalContext externalContext) {
    }

    public ELContext getELContext() {
        if (null != this.elContext) {
            return this.elContext;
        }
        this.elContext = new ELContextImpl(this.application);
        this.elContext.putContext(FacesContext.class, (Object)this);
        UIViewRoot root = this.getViewRoot();
        if (null != root) {
            this.elContext.setLocale(root.getLocale());
        }
        return this.elContext;
    }

    public FacesMessage.Severity getMaximumSeverity() {
        return this.maxSeverity;
    }

    public Iterator getMessages() {
        ArrayList buffer = new ArrayList();
        Iterator i = this.faceMessages.values().iterator();
        while (i.hasNext()) {
            buffer.addAll((Vector)i.next());
        }
        return buffer.iterator();
    }

    public Iterator getMessages(String clientId) {
        Object obj = this.faceMessages.get(clientId);
        if (obj == null) {
            if (log.isTraceEnabled()) {
                log.trace((Object)(clientId + " has no FacesMessages"));
            }
            return Collections.EMPTY_LIST.iterator();
        }
        return ((Vector)obj).iterator();
    }

    public RenderKit getRenderKit() {
        UIViewRoot viewRoot = this.getViewRoot();
        if (null == viewRoot) {
            return null;
        }
        String renderKitId = viewRoot.getRenderKitId();
        if (null == renderKitId) {
            return null;
        }
        RenderKitFactory renderKitFactory = (RenderKitFactory)FactoryFinder.getFactory((String)"javax.faces.render.RenderKitFactory");
        RenderKit renderKit = renderKitFactory.getRenderKit((FacesContext)this, renderKitId);
        return renderKit;
    }

    public boolean getRenderResponse() {
        return this.renderResponse;
    }

    public boolean getResponseComplete() {
        return this.responseComplete;
    }

    public ResponseStream getResponseStream() {
        return this.responseStream;
    }

    public void setResponseStream(ResponseStream responseStream) {
        this.responseStream = responseStream;
    }

    public ResponseWriter getResponseWriter() {
        return this.responseWriter;
    }

    public void setResponseWriter(ResponseWriter responseWriter) {
        this.responseWriter = responseWriter;
    }

    public ResponseWriter createAndSetResponseWriter() throws IOException {
        this.responseWriter = new DOMResponseWriter(this, this.domSerializer, this.configuration, this.jsCodeURIs, this.cssRuleURIs);
        return this.responseWriter;
    }

    public void switchToNormalMode() {
        try {
            this.domSerializer = new NormalModeSerializer(this, this.externalContext.getWriter("UTF-8"));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void switchToPushMode() {
        if (this.responseWriter != null) {
            Document document = ((DOMResponseWriter)this.responseWriter).getDocument();
            this.domSerializer = new PushModeSerializer(document, this.commandQueue, this.viewNumber);
        }
    }

    public UIViewRoot getViewRoot() {
        if (this.externalContext.isSeamLifecycleShortcut()) {
            return null;
        }
        return this.viewRoot;
    }

    public void setViewRoot(UIViewRoot viewRoot) {
        String path = viewRoot.getViewId();
        if (PageTemplatePattern.matcher(path).matches()) {
            this.responseWriter = null;
            this.viewRoot = viewRoot;
        } else {
            this.commandQueue.put(new Reload(this.viewNumber));
            this.application.setViewHandler((ViewHandler)new SwitchViewHandler(this.application.getViewHandler(), path));
        }
    }

    public String getIceFacesId() {
        return this.iceFacesId;
    }

    public String getViewNumber() {
        return this.viewNumber;
    }

    public String getFocusId() {
        Map map = this.externalContext.getRequestParameterMap();
        return map.containsKey("ice.focus") ? map.get("ice.focus") : "";
    }

    public void setFocusId(String focusId) {
        this.externalContext.getRequestParameterMap().put("ice.focus", focusId);
    }

    public void addMessage(String clientId, FacesMessage message) {
        if (message == null) {
            throw new IllegalArgumentException("Message is null");
        }
        if (this.faceMessages.containsKey(clientId)) {
            ((Vector)this.faceMessages.get(clientId)).addElement(message);
        } else {
            Vector<FacesMessage> vector = new Vector<FacesMessage>();
            vector.add(message);
            this.faceMessages.put(clientId, vector);
        }
        if (this.maxSeverity == null || message.getSeverity().getOrdinal() > this.maxSeverity.getOrdinal()) {
            this.maxSeverity = message.getSeverity();
        }
    }

    public void renderResponse() {
        this.renderResponse = true;
    }

    public void responseComplete() {
        this.responseComplete = true;
    }

    public void resetRenderResponse() {
        this.renderResponse = false;
    }

    public void resetResponseComplete() {
        this.responseComplete = false;
    }

    public static boolean isThreadLocalNull() {
        return BridgeFacesContext.getCurrentInstance() == null;
    }

    public void release() {
        this.faceMessages.clear();
        this.renderResponse = false;
        this.responseComplete = false;
        if (SeamUtilities.isSpring2Environment()) {
            this.viewRoot = null;
        }
        BridgeFacesContext.setCurrentInstance(null);
    }

    public void dispose() {
    }

    public void applyBrowserDOMChanges() {
        if (this.responseWriter == null) {
            return;
        }
        Document document = ((DOMResponseWriter)this.responseWriter).getDocument();
        if (document == null) {
            return;
        }
        Map parameters = this.externalContext.getRequestParameterValuesMap();
        NodeList inputElements = document.getElementsByTagName("input");
        int inputElementsLength = inputElements.getLength();
        for (int i = 0; i < inputElementsLength; ++i) {
            String value;
            Element inputElement = (Element)inputElements.item(i);
            String id = inputElement.getAttribute("id");
            if ("".equals(id) || !parameters.containsKey(id) || "".equals(value = ((String[])parameters.get(id))[0]) || !inputElement.hasAttribute("value")) continue;
            inputElement.setAttribute("value", value);
        }
        NodeList textareaElements = document.getElementsByTagName("textarea");
        int textareaElementsLength = textareaElements.getLength();
        for (int i = 0; i < textareaElementsLength; ++i) {
            Element textareaElement = (Element)textareaElements.item(i);
            String id = textareaElement.getAttribute("id");
            if ("".equals(id) || !parameters.containsKey(id)) continue;
            String value = ((String[])parameters.get(id))[0];
            textareaElement.getFirstChild().setNodeValue(value);
        }
        NodeList selectElements = document.getElementsByTagName("select");
        int selectElementsLength = selectElements.getLength();
        for (int i = 0; i < selectElementsLength; ++i) {
            Element selectElement = (Element)selectElements.item(i);
            String id = selectElement.getAttribute("id");
            if ("".equals(id) || !parameters.containsKey(id)) continue;
            List<String> values = Arrays.asList((String[])parameters.get(id));
            NodeList optionElements = selectElement.getElementsByTagName("option");
            int optionElementsLength = optionElements.getLength();
            for (int j = 0; j < optionElementsLength; ++j) {
                Element optionElement = (Element)optionElements.item(j);
                if (values.contains(optionElement.getAttribute("value"))) {
                    optionElement.setAttribute("selected", "selected");
                    continue;
                }
                optionElement.removeAttribute("selected");
            }
        }
    }

    public URI loadJavascriptCode(Resource resource) {
        String uri = this.resourceDispatcher.registerResource("text/javascript", resource).toString();
        if (!this.jsCodeURIs.contains(uri)) {
            this.jsCodeURIs.add(uri);
        }
        return this.resolve(uri);
    }

    public URI loadJavascriptCode(Resource resource, ResourceLinker.Handler linkerHandler) {
        String uri = this.resourceDispatcher.registerResource("text/javascript", resource, linkerHandler).toString();
        if (!this.jsCodeURIs.contains(uri)) {
            this.jsCodeURIs.add(uri);
        }
        return this.resolve(uri);
    }

    public URI loadCSSRules(Resource resource) {
        String uri = this.resourceDispatcher.registerResource("text/css", resource).toString();
        if (!this.cssRuleURIs.contains(uri)) {
            this.cssRuleURIs.add(uri);
        }
        return this.resolve(uri);
    }

    public URI loadCSSRules(Resource resource, ResourceLinker.Handler linkerHandler) {
        String uri = this.resourceDispatcher.registerResource("text/css", resource, linkerHandler).toString();
        if (!this.cssRuleURIs.contains(uri)) {
            this.cssRuleURIs.add(uri);
        }
        return this.resolve(uri);
    }

    public URI registerResource(String mimeType, Resource resource) {
        return this.resolve(this.resourceDispatcher.registerResource(mimeType, resource).toString());
    }

    public URI registerResource(String mimeType, Resource resource, ResourceLinker.Handler linkerHandler) {
        return this.resolve(this.resourceDispatcher.registerResource(mimeType, resource, linkerHandler).toString());
    }

    public URI registerNamedResource(String name, Resource resource) {
        return this.resolve(this.resourceDispatcher.registerNamedResource(name, resource).toString());
    }

    public URI registerNamedResource(String name, Resource resource, ResourceLinker.Handler linkerHandler) {
        return this.resolve(this.resourceDispatcher.registerNamedResource(name, resource, linkerHandler).toString());
    }

    private URI resolve(String uri) {
        return URI.create(this.application.getViewHandler().getResourceURL((FacesContext)this, uri));
    }

    public static FacesContext unwrap(FacesContext facesContext) {
        if (facesContext instanceof BridgeFacesContext) {
            return facesContext;
        }
        FacesContext result = facesContext;
        try {
            Method delegateMethod = facesContext.getClass().getDeclaredMethod("getDelegate", new Class[0]);
            delegateMethod.setAccessible(true);
            Object delegate = delegateMethod.invoke((Object)facesContext, (Object[])null);
            if (delegate instanceof BridgeFacesContext) {
                result = (FacesContext)delegate;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("BridgeFacesContext delegate of " + facesContext));
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public boolean isContentIncluded() {
        Map requestMap = this.externalContext.getRequestMap();
        String frag = (String)requestMap.get("javax.servlet.include.request_uri");
        if (log.isDebugEnabled()) {
            log.debug((Object)("javax.servlet.include.request_uri = " + frag));
        }
        if (frag != null) {
            return true;
        }
        frag = (String)requestMap.get("javax.servlet.include.servlet_path");
        if (log.isDebugEnabled()) {
            log.debug((Object)("javax.servlet.include.servlet_path = " + frag));
        }
        if (frag != null) {
            return true;
        }
        frag = (String)requestMap.get("com.sun.faces.portlet.INIT");
        return frag != null;
    }

    private class SwitchViewHandler
    extends ViewHandlerProxy {
        private final String path;

        public SwitchViewHandler(ViewHandler originalHandler, String path) {
            super(originalHandler);
            this.path = path;
        }

        public void renderView(FacesContext context, UIViewRoot viewToRender) throws IOException, FacesException {
            BridgeFacesContext.this.application.setViewHandler((ViewHandler)new DispatchingViewHandler(this.handler, this.path));
            this.handler.renderView(context, viewToRender);
        }
    }

    private class DispatchingViewHandler
    extends ViewHandlerProxy {
        private final String path;

        public DispatchingViewHandler(ViewHandler originalHandler, String path) {
            super(originalHandler);
            this.path = path;
        }

        public void renderView(FacesContext context, UIViewRoot viewToRender) throws IOException, FacesException {
            BridgeFacesContext.this.application.setViewHandler(this.handler);
            BridgeFacesContext.this.externalContext.dispatch(this.path);
        }
    }
}

