/*
 * Decompiled with CFR 0.152.
 */
package com.icesoft.faces.renderkit.dom_html_basic;

import com.icesoft.faces.context.DOMContext;
import com.icesoft.faces.context.effects.CurrentStyle;
import com.icesoft.faces.context.effects.LocalEffectEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.w3c.dom.Element;

public class PassThruAttributeRenderer {
    private static List passThruAttributeNames = new ArrayList();
    private static List booleanPassThruAttributeNames = new ArrayList();

    public static void renderAttributes(FacesContext facesContext, UIComponent uiComponent, String[] excludedAttributes) {
        PassThruAttributeRenderer.renderAttributes(facesContext, uiComponent, null, null, excludedAttributes);
    }

    public static void renderAttributes(FacesContext facesContext, UIComponent uiComponent, Element attributeElement, Element styleElement, String[] excludedAttributes) {
        PassThruAttributeRenderer.renderNonBooleanAttributes(facesContext, uiComponent, attributeElement, excludedAttributes);
        PassThruAttributeRenderer.renderBooleanAttributes(facesContext, uiComponent, attributeElement, excludedAttributes);
        CurrentStyle.apply(facesContext, uiComponent, styleElement, null);
        if (attributeElement == null) {
            Element rootElement;
            DOMContext domContext = DOMContext.getDOMContext(facesContext, uiComponent);
            attributeElement = rootElement = (Element)domContext.getRootNode();
        }
        LocalEffectEncoder.encodeLocalEffects(uiComponent, attributeElement, facesContext);
        PassThruAttributeRenderer.renderOnFocus(uiComponent, attributeElement);
        PassThruAttributeRenderer.renderOnBlur(attributeElement);
    }

    public static void renderOnFocus(UIComponent uiComponent, Element root) {
        String nodeName = root.getNodeName();
        if (nodeName.equalsIgnoreCase("a") || nodeName.equalsIgnoreCase("input") || nodeName.equalsIgnoreCase("select")) {
            String original = (String)uiComponent.getAttributes().get("onfocus");
            String onfocus = "setFocus(this.id);";
            if (original == null) {
                original = "";
            }
            root.setAttribute("onfocus", onfocus + original);
        }
    }

    public static void renderOnBlur(Element root) {
        String nodeName = root.getNodeName();
        if (nodeName.equalsIgnoreCase("a") || nodeName.equalsIgnoreCase("input") || nodeName.equalsIgnoreCase("select")) {
            String original = root.getAttribute("onblur");
            String onblur = "setFocus('');";
            if (original == null) {
                original = "";
            }
            root.setAttribute("onblur", onblur + original);
        }
    }

    private static void renderBooleanAttributes(FacesContext facesContext, UIComponent uiComponent, Element targetElement, String[] excludedAttributes) {
        if (facesContext == null) {
            throw new FacesException("Null pointer exception");
        }
        if (uiComponent == null) {
            throw new FacesException("Null pointer exception");
        }
        if (targetElement == null) {
            DOMContext domContext = DOMContext.getDOMContext(facesContext, uiComponent);
            Element rootElement = (Element)domContext.getRootNode();
            if (rootElement == null) {
                throw new FacesException("DOMContext is null");
            }
            targetElement = rootElement;
        }
        List<String> excludedAttributesList = null;
        if (excludedAttributes != null && excludedAttributes.length > 0) {
            excludedAttributesList = Arrays.asList(excludedAttributes);
        }
        Object nextPassThruAttributeValue = null;
        Iterator passThruNameIterator = booleanPassThruAttributeNames.iterator();
        while (passThruNameIterator.hasNext()) {
            Object nextPassThruAttributeName = passThruNameIterator.next();
            if (excludedAttributesList != null && excludedAttributesList.contains(nextPassThruAttributeName)) continue;
            nextPassThruAttributeValue = uiComponent.getAttributes().get(nextPassThruAttributeName);
            if (nextPassThruAttributeValue != null) {
                boolean primitiveAttributeValue;
                if (nextPassThruAttributeValue instanceof Boolean) {
                    primitiveAttributeValue = (Boolean)nextPassThruAttributeValue;
                } else {
                    if (!(nextPassThruAttributeValue instanceof String)) {
                        nextPassThruAttributeValue = nextPassThruAttributeValue.toString();
                    }
                    primitiveAttributeValue = new Boolean((String)nextPassThruAttributeValue);
                }
                if (primitiveAttributeValue) {
                    targetElement.setAttribute(nextPassThruAttributeName.toString(), nextPassThruAttributeName.toString());
                    continue;
                }
                targetElement.removeAttribute(nextPassThruAttributeName.toString());
                continue;
            }
            targetElement.removeAttribute(nextPassThruAttributeName.toString());
        }
    }

    private static void renderNonBooleanAttributes(FacesContext facesContext, UIComponent uiComponent, Element targetElement, String[] excludedAttributes) {
        if (uiComponent == null) {
            throw new FacesException("Component instance is null");
        }
        if (targetElement == null) {
            DOMContext domContext = DOMContext.getDOMContext(facesContext, uiComponent);
            Element rootElement = (Element)domContext.getRootNode();
            if (rootElement == null) {
                throw new FacesException("DOMContext is not initialized");
            }
            targetElement = rootElement;
        }
        List<String> excludedAttributesList = null;
        if (excludedAttributes != null && excludedAttributes.length > 0) {
            excludedAttributesList = Arrays.asList(excludedAttributes);
        }
        Object nextPassThruAttributeName = null;
        Object nextPassThruAttributeValue = null;
        Iterator passThruNameIterator = passThruAttributeNames.iterator();
        while (passThruNameIterator.hasNext()) {
            nextPassThruAttributeName = passThruNameIterator.next();
            if (excludedAttributesList != null && excludedAttributesList.contains(nextPassThruAttributeName)) continue;
            nextPassThruAttributeValue = uiComponent.getAttributes().get(nextPassThruAttributeName);
            if (nextPassThruAttributeValue != null && !PassThruAttributeRenderer.attributeValueIsSentinel(nextPassThruAttributeValue)) {
                targetElement.setAttribute(nextPassThruAttributeName.toString(), nextPassThruAttributeValue.toString());
                continue;
            }
            targetElement.removeAttribute(nextPassThruAttributeName.toString());
        }
    }

    public static boolean passThruAttributeExists(UIComponent uiComponent) {
        if (uiComponent == null) {
            return false;
        }
        Map componentAttributes = uiComponent.getAttributes();
        if (componentAttributes.size() <= 0) {
            return false;
        }
        if (PassThruAttributeRenderer.componentAttributesIncludePassThruAttribute(componentAttributes, passThruAttributeNames)) {
            return true;
        }
        return PassThruAttributeRenderer.componentAttributesIncludePassThruAttribute(componentAttributes, booleanPassThruAttributeNames);
    }

    private static boolean attributeValueIsSentinel(Object value) {
        if (value == null) {
            return false;
        }
        if (value instanceof Boolean) {
            return (Boolean)value == false;
        }
        if (value instanceof Number) {
            if (value instanceof Integer) {
                return (Integer)value == Integer.MIN_VALUE;
            }
            if (value instanceof Long) {
                return (Long)value == Long.MIN_VALUE;
            }
            if (value instanceof Short) {
                return (Short)value == Short.MIN_VALUE;
            }
            if (value instanceof Float) {
                return ((Float)value).floatValue() == Float.MIN_VALUE;
            }
            if (value instanceof Double) {
                return (Double)value == Double.MIN_VALUE;
            }
            if (value instanceof Byte) {
                return (Byte)value == -128;
            }
        }
        if (value instanceof Character) {
            return ((Character)value).charValue() == '\u0000';
        }
        return false;
    }

    private static boolean componentAttributesIncludePassThruAttribute(Map componentAttributes, List passThru) {
        Iterator attributeKeys = componentAttributes.keySet().iterator();
        while (attributeKeys.hasNext()) {
            Object componentAttributeValue;
            Object componentAttributeKey = attributeKeys.next();
            if (!passThru.contains(componentAttributeKey) || (componentAttributeValue = componentAttributes.get(componentAttributeKey)) == null || componentAttributeValue == "") continue;
            return true;
        }
        return false;
    }

    static final List getpassThruAttributeNames() {
        return passThruAttributeNames;
    }

    static {
        passThruAttributeNames.add("accept");
        passThruAttributeNames.add("accesskey");
        passThruAttributeNames.add("alt");
        passThruAttributeNames.add("bgcolor");
        passThruAttributeNames.add("border");
        passThruAttributeNames.add("cellpadding");
        passThruAttributeNames.add("cellspacing");
        passThruAttributeNames.add("charset");
        passThruAttributeNames.add("cols");
        passThruAttributeNames.add("coords");
        passThruAttributeNames.add("dir");
        passThruAttributeNames.add("enctype");
        passThruAttributeNames.add("frame");
        passThruAttributeNames.add("height");
        passThruAttributeNames.add("hreflang");
        passThruAttributeNames.add("lang");
        passThruAttributeNames.add("longdesc");
        passThruAttributeNames.add("maxlength");
        passThruAttributeNames.add("onblur");
        passThruAttributeNames.add("onchange");
        passThruAttributeNames.add("onclick");
        passThruAttributeNames.add("ondblclick");
        passThruAttributeNames.add("onfocus");
        passThruAttributeNames.add("onkeydown");
        passThruAttributeNames.add("onkeypress");
        passThruAttributeNames.add("onkeyup");
        passThruAttributeNames.add("onload");
        passThruAttributeNames.add("onmousedown");
        passThruAttributeNames.add("onmousemove");
        passThruAttributeNames.add("onmouseout");
        passThruAttributeNames.add("onmouseover");
        passThruAttributeNames.add("onmouseup");
        passThruAttributeNames.add("onreset");
        passThruAttributeNames.add("onselect");
        passThruAttributeNames.add("onsubmit");
        passThruAttributeNames.add("onunload");
        passThruAttributeNames.add("rel");
        passThruAttributeNames.add("rev");
        passThruAttributeNames.add("rows");
        passThruAttributeNames.add("rules");
        passThruAttributeNames.add("shape");
        passThruAttributeNames.add("size");
        passThruAttributeNames.add("style");
        passThruAttributeNames.add("summary");
        passThruAttributeNames.add("tabindex");
        passThruAttributeNames.add("target");
        passThruAttributeNames.add("title");
        passThruAttributeNames.add("usemap");
        passThruAttributeNames.add("width");
        passThruAttributeNames.add("width");
        passThruAttributeNames.add("onclickeffect");
        passThruAttributeNames.add("ondblclickeffect");
        passThruAttributeNames.add("onmousedowneffect");
        passThruAttributeNames.add("onmouseupeffect");
        passThruAttributeNames.add("onmousemoveeffect");
        passThruAttributeNames.add("onmouseovereffect");
        passThruAttributeNames.add("onmouseouteffect");
        passThruAttributeNames.add("onchangeeffect");
        passThruAttributeNames.add("onreseteffect");
        passThruAttributeNames.add("onsubmiteffect");
        passThruAttributeNames.add("onkeypresseffect");
        passThruAttributeNames.add("onkeydowneffect");
        passThruAttributeNames.add("onkeyupeffect");
        passThruAttributeNames.add("autocomplete");
        booleanPassThruAttributeNames.add("disabled");
        booleanPassThruAttributeNames.add("readonly");
        booleanPassThruAttributeNames.add("ismap");
    }
}

