/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.jpdl.el.impl;

import java.math.BigDecimal;
import org.jbpm.jpdl.el.ELException;
import org.jbpm.jpdl.el.impl.BinaryOperator;
import org.jbpm.jpdl.el.impl.Coercions;
import org.jbpm.jpdl.el.impl.Constants;
import org.jbpm.jpdl.el.impl.Logger;
import org.jbpm.jpdl.el.impl.PrimitiveObjects;

public class DivideOperator
extends BinaryOperator {
    public static final DivideOperator SINGLETON = new DivideOperator();

    public String getOperatorSymbol() {
        return "/";
    }

    public Object apply(Object pLeft, Object pRight, Logger pLogger) throws ELException {
        if (pLeft == null && pRight == null) {
            if (pLogger.isLoggingWarning()) {
                pLogger.logWarning(Constants.ARITH_OP_NULL, this.getOperatorSymbol());
            }
            return PrimitiveObjects.getInteger(0);
        }
        if (Coercions.isBigDecimal(pLeft) || Coercions.isBigInteger(pLeft) || Coercions.isBigDecimal(pRight) || Coercions.isBigInteger(pRight)) {
            BigDecimal left = (BigDecimal)Coercions.coerceToPrimitiveNumber(pLeft, BigDecimal.class, pLogger);
            BigDecimal right = (BigDecimal)Coercions.coerceToPrimitiveNumber(pRight, BigDecimal.class, pLogger);
            try {
                return left.divide(right, 4);
            }
            catch (Exception exc) {
                if (pLogger.isLoggingError()) {
                    pLogger.logError(Constants.ARITH_ERROR, this.getOperatorSymbol(), (Object)("" + left), (Object)("" + right));
                }
                return PrimitiveObjects.getInteger(0);
            }
        }
        double left = Coercions.coerceToPrimitiveNumber(pLeft, Double.class, pLogger).doubleValue();
        double right = Coercions.coerceToPrimitiveNumber(pRight, Double.class, pLogger).doubleValue();
        try {
            return PrimitiveObjects.getDouble(left / right);
        }
        catch (Exception exc) {
            if (pLogger.isLoggingError()) {
                pLogger.logError(Constants.ARITH_ERROR, this.getOperatorSymbol(), (Object)("" + left), (Object)("" + right));
            }
            return PrimitiveObjects.getInteger(0);
        }
    }
}

