/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test;

import java.net.URL;
import java.util.ArrayList;
import java.util.Hashtable;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.naming.InitialContext;
import org.jboss.test.JBossTestServices;

public class JBossTestClusteredServices
extends JBossTestServices {
    protected ArrayList adaptors = null;
    protected ArrayList servers = null;
    protected ArrayList namingURLs = null;
    protected ArrayList namingURLsHA = null;
    protected ArrayList httpURLs = null;

    public JBossTestClusteredServices(Class clazz) {
        super(clazz);
    }

    public void setUp() throws Exception {
        super.setUp();
    }

    public void tearDown() throws Exception {
        super.tearDown();
    }

    int getServerCount() {
        return this.servers.size();
    }

    MBeanServerConnection[] getAdaptors() throws Exception {
        MBeanServerConnection[] tmp = new MBeanServerConnection[this.adaptors.size()];
        this.adaptors.toArray(tmp);
        return tmp;
    }

    MBeanServerConnection getAdaptor(int index) throws Exception {
        MBeanServerConnection adaptor = (MBeanServerConnection)this.adaptors.get(index);
        return adaptor;
    }

    String[] getServers() throws Exception {
        String[] tmp = new String[this.servers.size()];
        this.servers.toArray(tmp);
        return tmp;
    }

    String getServer(int index) throws Exception {
        String server = (String)this.servers.get(index);
        return server;
    }

    String[] getNamingURLs() throws Exception {
        String[] tmp = new String[this.namingURLs.size()];
        this.namingURLs.toArray(tmp);
        return tmp;
    }

    String getNamingURL(int index) throws Exception {
        String server = (String)this.namingURLs.get(index);
        return server;
    }

    String[] getHANamingURLs() throws Exception {
        String[] tmp = new String[this.namingURLsHA.size()];
        this.namingURLsHA.toArray(tmp);
        return tmp;
    }

    String getHANamingURL(int index) throws Exception {
        String server = (String)this.namingURLsHA.get(index);
        return server;
    }

    String[] getHttpURLs() throws Exception {
        String[] tmp = new String[this.httpURLs.size()];
        this.httpURLs.toArray(tmp);
        return tmp;
    }

    String getHttpURL(int index) throws Exception {
        String server = (String)this.httpURLs.get(index);
        return server;
    }

    public void deploy(MBeanServerConnection server, String name) throws Exception {
        if (Boolean.getBoolean("jbosstest.nodeploy")) {
            this.log.debug((Object)("Skipping deployment of: " + name));
            return;
        }
        URL deployURL = this.getDeployURL(name);
        this.log.debug((Object)("Deploying " + name + ", url=" + deployURL + " to " + server));
        this.invoke(server, this.getDeployerName(), "deploy", new Object[]{deployURL}, new String[]{"java.net.URL"});
    }

    public void redeploy(MBeanServerConnection server, String name) throws Exception {
        if (Boolean.getBoolean("jbosstest.nodeploy")) {
            this.log.debug((Object)("Skipping redeployment of: " + name));
            return;
        }
        URL deployURL = this.getDeployURL(name);
        this.log.debug((Object)("Deploying " + name + ", url=" + deployURL));
        this.invoke(server, this.getDeployerName(), "redeploy", new Object[]{deployURL}, new String[]{"java.net.URL"});
    }

    public void undeploy(MBeanServerConnection server, String name) throws Exception {
        if (Boolean.getBoolean("jbosstest.nodeploy")) {
            return;
        }
        URL deployURL = this.getDeployURL(name);
        this.log.debug((Object)("Undeploying " + name + ", url=" + deployURL));
        Object[] args = new Object[]{deployURL};
        String[] sig = new String[]{"java.net.URL"};
        this.invoke(server, this.getDeployerName(), "undeploy", args, sig);
    }

    protected Object invoke(ObjectName name, String method, Object[] args, String[] sig) throws Exception {
        MBeanServerConnection[] adaptors = this.getAdaptors();
        Object result = null;
        for (int i = 0; i < adaptors.length; ++i) {
            MBeanServerConnection adaptor = adaptors[i];
            this.log.debug((Object)("Using MBeanServerConnection: " + adaptor));
            result = this.invoke(adaptor, name, method, args, sig);
        }
        return result;
    }

    public void init() throws Exception {
        super.init();
        if (this.initialContext == null) {
            this.initialContext = new InitialContext();
        }
        if (this.adaptors == null) {
            this.adaptors = new ArrayList();
            this.servers = new ArrayList();
            this.namingURLs = new ArrayList();
            this.namingURLsHA = new ArrayList();
            this.httpURLs = new ArrayList();
            String adaptorName = System.getProperty("jbosstest.server.name");
            if (adaptorName == null) {
                adaptorName = "jmx/invoker/RMIAdaptor";
            }
            Hashtable<String, String> env = new Hashtable<String, String>();
            env.put("java.naming.factory.initial", "org.jnp.interfaces.NamingContextFactory");
            env.put("java.naming.factory.url.pkgs", "org.jnp.interfaces");
            String node = "jbosstest.cluster.node";
            for (int count = 0; count < 10; ++count) {
                String prop = node + count;
                String host = System.getProperty(prop);
                if (host == null) break;
                this.log.info((Object)(prop + " = " + host));
                this.servers.add(host);
                String urlProp = prop + ".jndi.url";
                String urlDefault = "jnp://" + host + ":1099";
                String urlValue = System.getProperty(urlProp, urlDefault);
                this.log.debug((Object)("JNDI Url for node=" + count + " is:" + urlValue));
                this.namingURLs.add(urlValue);
                env.put("java.naming.provider.url", urlValue);
                InitialContext tmpCtx = new InitialContext(env);
                MBeanServerConnection adaptor = (MBeanServerConnection)tmpCtx.lookup(adaptorName);
                this.adaptors.add(adaptor);
                urlProp = prop + ".hajndi.url";
                urlDefault = "jnp://" + host + ":1100";
                urlValue = System.getProperty(urlProp, urlDefault);
                this.log.debug((Object)("HA-JNDI Url for node=" + count + " is:" + urlValue));
                this.namingURLsHA.add(urlValue);
                urlProp = prop + ".http.url";
                urlDefault = "http://" + host + ":8080";
                urlValue = System.getProperty(urlProp, urlDefault);
                this.log.debug((Object)("Http Url for node=" + count + " is:" + urlValue));
                this.httpURLs.add(urlValue);
            }
            if (this.adaptors.size() == 0) {
                throw new IllegalStateException("No jbosstest.cluster.node values found");
            }
        }
    }

    public void setServerNames(String[] snames) {
        if (snames == null) {
            return;
        }
        for (int i = 0; i < snames.length; ++i) {
            this.servers.add(snames[i]);
        }
    }
}

