/*
 * Decompiled with CFR 0.152.
 */
package org.drools.util;

import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public final class ClassUtils {
    private static Map classes = Collections.synchronizedMap(new HashMap());

    public static String convertResourceToClassName(String pResourceName) {
        return ClassUtils.stripExtension(pResourceName).replace('/', '.');
    }

    public static String convertClassToResourcePath(String pName) {
        return pName.replace('.', '/') + ".class";
    }

    public static String stripExtension(String pResourceName) {
        int i = pResourceName.lastIndexOf(46);
        String withoutExtension = pResourceName.substring(0, i);
        return withoutExtension;
    }

    public static String toJavaCasing(String pName) {
        char[] name = pName.toLowerCase().toCharArray();
        name[0] = Character.toUpperCase(name[0]);
        return new String(name);
    }

    public static String clazzName(File base, File file) {
        int rootLength = base.getAbsolutePath().length();
        String absFileName = file.getAbsolutePath();
        int p = absFileName.lastIndexOf(46);
        String relFileName = absFileName.substring(rootLength + 1, p);
        String clazzName = relFileName.replace(File.separatorChar, '.');
        return clazzName;
    }

    public static String relative(File base, File file) {
        int rootLength = base.getAbsolutePath().length();
        String absFileName = file.getAbsolutePath();
        String relFileName = absFileName.substring(rootLength + 1);
        return relFileName;
    }

    public static String canonicalName(Class clazz) {
        StringBuffer name = new StringBuffer();
        if (clazz.isArray()) {
            name.append(ClassUtils.canonicalName(clazz.getComponentType()));
            name.append("[]");
        } else if (clazz.getDeclaringClass() == null) {
            name.append(clazz.getName());
        } else {
            name.append(ClassUtils.canonicalName(clazz.getDeclaringClass()));
            name.append(".");
            name.append(clazz.getName().substring(clazz.getDeclaringClass().getName().length() + 1));
        }
        return name.toString();
    }

    public static Object instantiateObject(String className) {
        Class<?> cls = (Class<?>)classes.get(className);
        if (cls == null) {
            try {
                cls = Class.forName(className);
                classes.put(className, cls);
            }
            catch (Throwable e) {
                throw new RuntimeException("Unable to load class '" + className + "'", e);
            }
        }
        Object object = null;
        try {
            object = cls.newInstance();
        }
        catch (Throwable e) {
            throw new RuntimeException("Unable to instantiate object for class '" + className + "'", e);
        }
        return object;
    }
}

