/*
 * Decompiled with CFR 0.152.
 */
package org.drools.lang.descr;

import java.text.DecimalFormat;
import java.text.ParseException;
import org.drools.lang.descr.RestrictionDescr;

public class LiteralRestrictionDescr
extends RestrictionDescr {
    public static final int TYPE_NULL = 1;
    public static final int TYPE_NUMBER = 2;
    public static final int TYPE_STRING = 3;
    public static final int TYPE_BOOLEAN = 4;
    private static final long serialVersionUID = 400L;
    private String evaluator;
    private int type;

    public LiteralRestrictionDescr(String evaluator, String text) {
        this(evaluator, text, 3);
    }

    public LiteralRestrictionDescr(String evaluator, String text, int type) {
        this.setText(text);
        this.evaluator = evaluator;
        this.type = type;
    }

    public String getEvaluator() {
        return this.evaluator;
    }

    public Object getValue() {
        switch (this.type) {
            case 2: {
                try {
                    return DecimalFormat.getInstance().parse(this.getText());
                }
                catch (ParseException e) {
                    return this.getText();
                }
            }
            case 4: {
                return Boolean.valueOf(this.getText());
            }
        }
        return this.getText();
    }

    public String toString() {
        return "[LiteralRestriction: " + this.evaluator + " " + this.getText() + "]";
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }
}

