/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.kernel.plugins.metadata.basic;

import org.jboss.kernel.plugins.metadata.basic.PolicyCachingBasicKernelMetaDataRepository;
import org.jboss.metadata.plugins.cache.CachePolicyFactory;
import org.jboss.metadata.plugins.cache.TimedCachePolicyFactory;

public class TimedPolicyCachingBasicKernelMetaDataRepository
extends PolicyCachingBasicKernelMetaDataRepository {
    private Integer defaultLifetime;
    private Boolean threadSafe;
    private Integer resolution;

    public TimedPolicyCachingBasicKernelMetaDataRepository() {
    }

    public TimedPolicyCachingBasicKernelMetaDataRepository(Integer defaultLifetime) {
        this(defaultLifetime, null, null);
    }

    public TimedPolicyCachingBasicKernelMetaDataRepository(Integer defaultLifetime, Boolean threadSafe, Integer resolution) {
        this.defaultLifetime = defaultLifetime;
        this.threadSafe = threadSafe;
        this.resolution = resolution;
    }

    protected CachePolicyFactory createCachePolicyFactory() {
        if (this.defaultLifetime == null) {
            this.defaultLifetime = TimedPolicyCachingBasicKernelMetaDataRepository.parseInteger(TimedPolicyCachingBasicKernelMetaDataRepository.readSystemProperty("TimedPolicyCaching.lifetime", null));
        }
        if (this.threadSafe == null) {
            this.threadSafe = Boolean.valueOf(TimedPolicyCachingBasicKernelMetaDataRepository.readSystemProperty("TimedPolicyCaching.threadSafe", Boolean.TRUE.toString()));
        }
        if (this.resolution == null) {
            this.resolution = TimedPolicyCachingBasicKernelMetaDataRepository.parseInteger(TimedPolicyCachingBasicKernelMetaDataRepository.readSystemProperty("TimedPolicyCaching.resolution", null));
        }
        this.log.debug((Object)("Creating timed cache policy, lifetime: " + this.defaultLifetime + ", threadSafe: " + this.threadSafe + ", resolution: " + this.resolution));
        if (this.defaultLifetime == null) {
            return new TimedCachePolicyFactory();
        }
        if (this.resolution != null) {
            return new TimedCachePolicyFactory(this.defaultLifetime.intValue(), this.threadSafe.booleanValue(), this.resolution.intValue());
        }
        return new TimedCachePolicyFactory(this.defaultLifetime.intValue());
    }

    public void setDefaultLifetime(Integer defaultLifetime) {
        this.defaultLifetime = defaultLifetime;
    }

    public void setThreadSafe(Boolean threadSafe) {
        this.threadSafe = threadSafe;
    }

    public void setResolution(Integer resolution) {
        this.resolution = resolution;
    }
}

