/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ha.framework.server;

import java.io.Serializable;
import java.util.EventObject;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.jboss.ha.framework.interfaces.DistributedReplicantManager;
import org.jboss.ha.framework.interfaces.EventListener;
import org.jboss.ha.framework.interfaces.HAPartition;
import org.jboss.ha.framework.interfaces.HAService;
import org.jboss.ha.framework.server.EventFacility;
import org.jboss.ha.framework.server.EventFactory;
import org.jboss.ha.framework.server.HAServiceRpcHandler;
import org.jboss.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HAServiceImpl<E extends EventObject>
implements HAService<E>,
EventFacility<E>,
DistributedReplicantManager.ReplicantListener {
    private static final Class<?>[] HANDLE_EVENT_TYPES = new Class[]{EventObject.class};
    private static final String REPLICANT_TOKEN = "";
    protected final Logger log = Logger.getLogger(this.getClass());
    private final HAServiceRpcHandler<E> rpcHandler = new RpcHandler();
    private final EventFacility<E> eventFacility;
    private final EventFactory<E> eventFactory;
    private final List<EventListener<E>> eventListeners = new CopyOnWriteArrayList<EventListener<E>>();
    private volatile HAPartition partition;
    private volatile String name;
    private volatile boolean registerClassLoader = false;

    public HAServiceImpl(EventFactory<E> eventFactory, EventFacility<E> eventFacility) {
        this.eventFactory = eventFactory;
        this.eventFacility = eventFacility;
    }

    public HAServiceImpl(EventFactory<E> eventFactory) {
        this.eventFactory = eventFactory;
        this.eventFacility = this;
    }

    public void addEventListener(EventListener<E> listener) {
        this.eventListeners.add(listener);
    }

    public void removeEventListener(EventListener<E> listener) {
        this.eventListeners.remove(listener);
    }

    @Override
    public void notifyListeners(E event) {
        for (EventListener<E> listener : this.eventListeners) {
            try {
                listener.handleEvent(event);
            }
            catch (Exception e) {
                this.log.warn((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    @Override
    public HAPartition getHAPartition() {
        return this.partition;
    }

    @Override
    public void setHAPartition(HAPartition partition) {
        this.partition = partition;
    }

    @Override
    public boolean isRegisterThreadContextClassLoader() {
        return this.registerClassLoader;
    }

    @Override
    public void setRegisterThreadContextClassLoader(boolean registerClassLoader) {
        this.registerClassLoader = registerClassLoader;
    }

    @Override
    public String getServiceHAName() {
        return this.name;
    }

    @Override
    public void setServiceHAName(String name) {
        this.name = name;
    }

    @Override
    public void handleEvent(E event) throws Exception {
        this.callAsyncMethodOnPartition("handleEvent", new Object[]{event}, HANDLE_EVENT_TYPES);
    }

    protected HAServiceRpcHandler<E> getRpcHandler() {
        return this.rpcHandler;
    }

    protected EventFactory<E> getEventFactory() {
        return this.eventFactory;
    }

    protected EventFacility<E> getEventFacility() {
        return this.eventFacility;
    }

    @Override
    public void create() throws Exception {
    }

    @Override
    public void start() throws Exception {
        this.registerRPCHandler();
        this.registerDRMListener();
    }

    @Override
    public void stop() {
        try {
            this.unregisterDRMListener();
            this.unregisterRPCHandler();
        }
        catch (Exception e) {
            this.log.error((Object)"Failed to stop service.", (Throwable)e);
        }
    }

    @Override
    public void destroy() {
    }

    protected <T> List<T> callMethodOnPartition(String methodName, Object[] args, Class<?>[] types) throws Exception {
        return this.partition.callMethodOnCluster(this.name, methodName, args, types, true);
    }

    protected void callAsyncMethodOnPartition(String methodName, Object[] args, Class<?>[] types) throws Exception {
        this.partition.callAsynchMethodOnCluster(this.name, methodName, args, types, true);
    }

    protected void registerRPCHandler() {
        String key = this.getHAServiceKey();
        if (this.isRegisterThreadContextClassLoader()) {
            this.partition.registerRPCHandler(key, this.getRpcHandler(), Thread.currentThread().getContextClassLoader());
        } else {
            this.partition.registerRPCHandler(key, this.getRpcHandler());
        }
    }

    protected void unregisterRPCHandler() {
        this.partition.unregisterRPCHandler(this.getHAServiceKey(), this.getRpcHandler());
    }

    protected void registerDRMListener() throws Exception {
        DistributedReplicantManager drm = this.partition.getDistributedReplicantManager();
        String key = this.getHAServiceKey();
        drm.registerListener(key, this);
        drm.add(key, this.getReplicant());
    }

    protected void unregisterDRMListener() throws Exception {
        DistributedReplicantManager drm = this.partition.getDistributedReplicantManager();
        String key = this.getHAServiceKey();
        drm.remove(key);
        drm.unregisterListener(key, this);
    }

    @Override
    public String getHAServiceKey() {
        return this.name;
    }

    protected Serializable getReplicant() {
        return REPLICANT_TOKEN;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void replicantsChanged(String key, List newReplicants, int newReplicantsViewId, boolean merge) {
        if (key.equals(this.getHAServiceKey())) {
            HAServiceImpl hAServiceImpl = this;
            synchronized (hAServiceImpl) {
                this.partitionTopologyChanged(newReplicants, newReplicantsViewId, merge);
            }
        }
    }

    protected void partitionTopologyChanged(List<?> newReplicants, int newReplicantsViewId, boolean merge) {
        this.log.debug((Object)("partitionTopologyChanged(). cluster view id: " + newReplicantsViewId));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class RpcHandler
    implements HAServiceRpcHandler<E> {
        protected RpcHandler() {
        }

        @Override
        public void handleEvent(E event) throws Exception {
            HAServiceImpl.this.getEventFacility().notifyListeners(event);
        }
    }
}

