/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aspects.asynchronous.concurrent;

import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.jboss.aspects.asynchronous.AsynchronousConstants;
import org.jboss.aspects.asynchronous.AsynchronousParameters;
import org.jboss.aspects.asynchronous.AsynchronousTask;
import org.jboss.aspects.asynchronous.AsynchronousUserTask;
import org.jboss.aspects.asynchronous.ThreadManager;
import org.jboss.aspects.asynchronous.ThreadManagerRequest;
import org.jboss.aspects.asynchronous.ThreadManagerResponse;
import org.jboss.aspects.asynchronous.common.AsynchronousEmptyTask;
import org.jboss.aspects.asynchronous.common.ThreadManagerResponseImpl;
import org.jboss.aspects.asynchronous.concurrent.AsynchronousTaskImpl;

public class ThreadManagerImpl
implements AsynchronousConstants,
ThreadManager {
    ThreadPoolExecutor _pooledExecutor;
    protected boolean waitWhenPoolSizeIsFull = true;
    protected boolean isPooling = true;

    public ThreadManagerImpl() {
        this._pooledExecutor = (ThreadPoolExecutor)Executors.newCachedThreadPool();
        this.setWaitWhenPoolSizeIsFull(false);
    }

    public ThreadManagerImpl(int maximumPoolSize) {
        this._pooledExecutor = (ThreadPoolExecutor)Executors.newFixedThreadPool(maximumPoolSize);
        this.setWaitWhenPoolSizeIsFull(false);
    }

    public void setMaximumPoolSize(int maximumPoolSize) {
        this._pooledExecutor.setMaximumPoolSize(maximumPoolSize);
    }

    public void setWaitWhenPoolSizeIsFull(boolean value) {
        if (value) {
            this._pooledExecutor.setRejectedExecutionHandler(new WaitWhenBlockedPolicy());
        } else {
            this._pooledExecutor.setRejectedExecutionHandler(new ThreadPoolExecutor.AbortPolicy());
        }
        this.waitWhenPoolSizeIsFull = value;
    }

    public boolean getWaitWhenPoolSizeIsFull() {
        return this.waitWhenPoolSizeIsFull;
    }

    public int getMaximumPoolSize() {
        return this._pooledExecutor.getMaximumPoolSize();
    }

    public void setMinimumPoolSize(int minimumPoolSize) {
        this._pooledExecutor.setCorePoolSize(minimumPoolSize);
    }

    public int getMinimumPoolSize() {
        return this._pooledExecutor.getCorePoolSize();
    }

    public void setKeepAliveTime(long time) {
        this._pooledExecutor.setKeepAliveTime(time, TimeUnit.MILLISECONDS);
    }

    public long getKeepAliveTime() {
        return this._pooledExecutor.getKeepAliveTime(TimeUnit.MILLISECONDS);
    }

    public long getPoolSize() {
        return this._pooledExecutor.getPoolSize();
    }

    public ThreadManagerResponse waitForResponse(AsynchronousTask input) {
        AsynchronousTask[] tTask = new AsynchronousTask[]{input};
        return this.waitForResponses(tTask)[0];
    }

    public ThreadManagerResponse[] waitForResponses(AsynchronousTask[] inputImpl) {
        if (inputImpl == null) {
            System.err.println("PPMImpl:waitForResponses NULL PARAMETER");
            return null;
        }
        ThreadManagerResponse[] response = new ThreadManagerResponseImpl[inputImpl.length];
        for (int i = 0; i < inputImpl.length; ++i) {
            AsynchronousTask fr = inputImpl[i];
            response[i] = fr.getResponse();
        }
        return response;
    }

    public AsynchronousTask process(ThreadManagerRequest ppmRequest) {
        return this.process(ppmRequest.getId(), ppmRequest.getTaskClassImpl(), ppmRequest.getInputParameters(), ppmRequest.getTimeout());
    }

    private AsynchronousTask process(String id, AsynchronousUserTask taskImpl, AsynchronousParameters inputParametersImpl, long timeout) {
        try {
            if (this.getPoolSize() + 1L > (long)this.getMaximumPoolSize()) {
                System.err.println("process: The maximum pool size defined at " + this.getMaximumPoolSize() + " is reached before processing task[" + id + "] !");
            }
            AsynchronousTaskImpl ft = new AsynchronousTaskImpl(id, taskImpl, inputParametersImpl, timeout);
            Runnable cmd = ft.add();
            if (this.isPooling()) {
                this._pooledExecutor.execute(cmd);
            } else {
                Thread thread = Executors.defaultThreadFactory().newThread(cmd);
                thread.start();
            }
            Thread.yield();
            Thread.sleep(0L);
            Thread.yield();
            return ft;
        }
        catch (Exception e) {
            return new AsynchronousEmptyTask(id, 70, e, e.getMessage(), System.currentTimeMillis());
        }
    }

    public boolean isPooling() {
        return this.isPooling;
    }

    public void setPooling(boolean isPooling) {
        this.isPooling = isPooling;
    }

    private static class WaitWhenBlockedPolicy
    implements RejectedExecutionHandler {
        private WaitWhenBlockedPolicy() {
        }

        public void rejectedExecution(Runnable r, ThreadPoolExecutor executor) throws RejectedExecutionException {
            try {
                executor.getQueue().put(r);
            }
            catch (InterruptedException e) {
                throw new RejectedExecutionException(e);
            }
        }
    }
}

