/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.xnio.nio;

import java.io.Closeable;
import java.io.IOException;
import java.nio.channels.Pipe;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicLong;
import javax.management.NotCompliantMBeanException;
import javax.management.StandardMBean;
import org.jboss.xnio.IoHandler;
import org.jboss.xnio.IoUtils;
import org.jboss.xnio.channels.StreamChannel;
import org.jboss.xnio.management.PipeConnectionMBean;
import org.jboss.xnio.nio.HandlerUtils;
import org.jboss.xnio.nio.NioPipeChannelImpl;
import org.jboss.xnio.nio.NioXnio;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class NioPipeConnection
implements Closeable {
    private final NioPipeChannelImpl leftSide;
    private final NioPipeChannelImpl rightSide;

    NioPipeConnection(NioXnio nioXnio, final IoHandler<? super StreamChannel> leftHandler, final IoHandler<? super StreamChannel> rightHandler, Executor executor) throws IOException {
        MBean mbean;
        Pipe leftToRight = Pipe.open();
        Pipe rightToLeft = Pipe.open();
        final Pipe.SourceChannel leftToRightSource = leftToRight.source();
        final Pipe.SinkChannel leftToRightSink = rightToLeft.sink();
        final Pipe.SourceChannel rightToLeftSource = rightToLeft.source();
        final Pipe.SinkChannel rightToLeftSink = leftToRight.sink();
        leftToRightSource.configureBlocking(false);
        leftToRightSink.configureBlocking(false);
        rightToLeftSource.configureBlocking(false);
        rightToLeftSink.configureBlocking(false);
        try {
            mbean = new MBean();
        }
        catch (NotCompliantMBeanException e) {
            throw new IOException("Failed to register channel mbean: " + e);
        }
        Closeable mbeanHandle = nioXnio.registerMBean(mbean);
        final NioPipeChannelImpl leftSide = NioPipeChannelImpl.create(leftToRightSource, leftToRightSink, leftHandler, nioXnio, mbean.bytesRead, mbean.messagesRead, mbeanHandle);
        final NioPipeChannelImpl rightSide = NioPipeChannelImpl.create(rightToLeftSource, rightToLeftSink, rightHandler, nioXnio, mbean.bytesWritten, mbean.messagesWritten, mbeanHandle);
        this.leftSide = leftSide;
        this.rightSide = rightSide;
        nioXnio.addManaged((Closeable)((Object)leftSide));
        nioXnio.addManaged((Closeable)((Object)rightSide));
        executor.execute(new Runnable(){

            public void run() {
                if (!HandlerUtils.handleOpened(leftHandler, leftSide)) {
                    IoUtils.safeClose((Closeable)leftToRightSource);
                    IoUtils.safeClose((Closeable)leftToRightSink);
                    IoUtils.safeClose((Closeable)rightToLeftSource);
                    IoUtils.safeClose((Closeable)rightToLeftSink);
                }
            }
        });
        executor.execute(new Runnable(){

            public void run() {
                if (!HandlerUtils.handleOpened(rightHandler, rightSide)) {
                    IoUtils.safeClose((Closeable)leftToRightSource);
                    IoUtils.safeClose((Closeable)leftToRightSink);
                    IoUtils.safeClose((Closeable)rightToLeftSource);
                    IoUtils.safeClose((Closeable)rightToLeftSink);
                }
            }
        });
    }

    public NioPipeChannelImpl getLeftSide() {
        return this.leftSide;
    }

    public NioPipeChannelImpl getRightSide() {
        return this.rightSide;
    }

    @Override
    public void close() throws IOException {
        IoUtils.safeClose((Closeable)((Object)this.leftSide));
        IoUtils.safeClose((Closeable)((Object)this.rightSide));
    }

    private final class MBean
    extends StandardMBean
    implements PipeConnectionMBean {
        private final AtomicLong bytesRead;
        private final AtomicLong bytesWritten;
        private final AtomicLong messagesRead;
        private final AtomicLong messagesWritten;

        private MBean() throws NotCompliantMBeanException {
            super(PipeConnectionMBean.class);
            this.bytesRead = new AtomicLong();
            this.bytesWritten = new AtomicLong();
            this.messagesRead = new AtomicLong();
            this.messagesWritten = new AtomicLong();
        }

        public long getBytesRead() {
            return this.bytesRead.get();
        }

        public long getMessagesRead() {
            return this.messagesRead.get();
        }

        public long getBytesWritten() {
            return this.bytesWritten.get();
        }

        public long getMessagesWritten() {
            return this.messagesWritten.get();
        }

        public void close() {
            IoUtils.safeClose((Closeable)NioPipeConnection.this);
        }
    }
}

