/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.classloading.spi.metadata.helpers;

import javax.xml.bind.annotation.XmlAttribute;
import org.jboss.classloading.spi.helpers.NameAndVersionRangeSupport;
import org.jboss.classloading.spi.metadata.Requirement;
import org.jboss.classloading.spi.version.VersionRange;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbstractRequirement
extends NameAndVersionRangeSupport
implements Requirement {
    private static final long serialVersionUID = -7898148730704557596L;
    private boolean optional = false;
    private boolean dynamic = false;
    private boolean reExport = false;

    public AbstractRequirement() {
    }

    public AbstractRequirement(String name) {
        super(name);
    }

    public AbstractRequirement(String name, VersionRange versionRange) {
        super(name, versionRange);
    }

    @Override
    public boolean isOptional() {
        return this.optional;
    }

    @XmlAttribute(name="optional")
    public void setOptional(boolean optional) {
        this.optional = optional;
    }

    @Override
    public boolean isDynamic() {
        return this.dynamic;
    }

    @XmlAttribute(name="dynamic")
    public void setDynamic(boolean dynamic) {
        this.dynamic = dynamic;
    }

    @Override
    public boolean wantReExports() {
        return false;
    }

    @Override
    public boolean isReExport() {
        return this.reExport;
    }

    @XmlAttribute(name="reExport")
    public void setReExport(boolean reExport) {
        this.reExport = reExport;
    }

    @Override
    public boolean isConsistent(Requirement other) {
        return this.isConsistent(other, null);
    }

    protected boolean isConsistent(Requirement other, Class<? extends AbstractRequirement> requirementType) {
        String otherName;
        if (other == null) {
            throw new IllegalArgumentException("Null requirement");
        }
        if (requirementType == null) {
            requirementType = this.getClass();
        }
        if (!requirementType.isInstance(other)) {
            return true;
        }
        AbstractRequirement otherRequirement = (AbstractRequirement)other;
        String name = this.getName();
        if (!name.equals(otherName = otherRequirement.getName())) {
            return true;
        }
        VersionRange range = this.getVersionRange();
        VersionRange otherRange = otherRequirement.getVersionRange();
        return range.isConsistent(otherRange);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof AbstractRequirement)) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        AbstractRequirement other = (AbstractRequirement)obj;
        if (this.isOptional() != other.isOptional()) {
            return false;
        }
        return this.isReExport() == other.isReExport();
    }

    @Override
    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.getClass().getSimpleName());
        buffer.append("{");
        this.toString(buffer);
        buffer.append("}");
        return buffer.toString();
    }

    protected void toString(StringBuffer buffer) {
        buffer.append(this.getName());
        buffer.append(" ").append(this.getVersionRange());
        if (this.isOptional()) {
            buffer.append(" OPTIONAL");
        }
        if (this.isReExport()) {
            buffer.append(" RE-EXPORT");
        }
    }
}

