/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import java.io.Serializable;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.jgroups.Channel;
import org.jgroups.ChannelException;
import org.jgroups.Event;
import org.jgroups.JChannel;
import org.jgroups.Message;
import org.jgroups.ReceiverAdapter;
import org.jgroups.View;
import org.jgroups.conf.ConfiguratorFactory;
import org.jgroups.conf.ProtocolData;
import org.jgroups.conf.ProtocolParameter;
import org.jgroups.conf.ProtocolStackConfigurator;
import org.jgroups.tests.ChannelTestBase;
import org.jgroups.util.Util;

public class SharedTransportTest
extends ChannelTestBase {
    private JChannel a;
    private JChannel b;
    private JChannel c;
    private MyReceiver r1;
    private MyReceiver r2;
    private MyReceiver r3;
    static final String SINGLETON_1 = "singleton-1";
    static final String SINGLETON_2 = "singleton-2";

    protected void tearDown() throws Exception {
        if (this.c != null) {
            this.c.close();
        }
        if (this.b != null) {
            this.b.close();
        }
        if (this.a != null) {
            this.a.close();
        }
        this.r3 = null;
        this.r2 = null;
        this.r1 = null;
        super.tearDown();
    }

    public void testCreationNonSharedTransport() throws Exception {
        this.a = this.createChannel();
        this.a.connect("x");
        View view = this.a.getView();
        System.out.println("view = " + view);
        SharedTransportTest.assertEquals((int)1, (int)view.size());
    }

    public void testCreationOfDuplicateCluster() throws Exception {
        this.a = SharedTransportTest.createSharedChannel(SINGLETON_1);
        this.b = SharedTransportTest.createSharedChannel(SINGLETON_1);
        this.a.connect("x");
        try {
            this.b.connect("x");
            SharedTransportTest.fail((String)"b should not be able to join cluster 'x' as a has already joined it");
        }
        catch (Exception ex) {
            System.out.println("b was not able to join the same cluster (\"x\") as expected");
        }
    }

    public void testShunReconnect() throws Exception {
        int size = 10;
        JChannel[] chs = new JChannel[size];
        for (int i = 0; i < size; ++i) {
            chs[i] = SharedTransportTest.createSharedChannel(SINGLETON_1);
            chs[i].connect("" + i);
        }
        for (JChannel c : chs) {
            c.up(new Event(46));
        }
        Util.sleep(5000L);
        for (JChannel c : chs) {
            SharedTransportTest.assertEquals((int)1, (int)c.getView().size());
        }
    }

    public void testView() throws Exception {
        this.a = SharedTransportTest.createSharedChannel(SINGLETON_1);
        this.b = SharedTransportTest.createSharedChannel(SINGLETON_2);
        this.a.setReceiver(new MyReceiver(SINGLETON_1));
        this.b.setReceiver(new MyReceiver(SINGLETON_2));
        this.a.connect("x");
        this.b.connect("x");
        View view = this.a.getView();
        SharedTransportTest.assertEquals((int)2, (int)view.size());
        view = this.b.getView();
        SharedTransportTest.assertEquals((int)2, (int)view.size());
    }

    public void testView2() throws Exception {
        this.a = SharedTransportTest.createSharedChannel(SINGLETON_1);
        this.b = SharedTransportTest.createSharedChannel(SINGLETON_1);
        this.a.setReceiver(new MyReceiver("first-channel"));
        this.b.setReceiver(new MyReceiver("second-channel"));
        this.a.connect("x");
        this.b.connect("y");
        View view = this.a.getView();
        SharedTransportTest.assertEquals((int)1, (int)view.size());
        view = this.b.getView();
        SharedTransportTest.assertEquals((int)1, (int)view.size());
    }

    public void testView3() throws Exception {
        this.a = SharedTransportTest.createSharedChannel(SINGLETON_1);
        this.b = SharedTransportTest.createSharedChannel(SINGLETON_1);
        this.c = SharedTransportTest.createSharedChannel(SINGLETON_2);
        this.r1 = new MyReceiver("A::singleton-1");
        this.r2 = new MyReceiver("B::singleton-1");
        this.r3 = new MyReceiver("C::singleton-2");
        this.a.setReceiver(this.r1);
        this.b.setReceiver(this.r2);
        this.c.setReceiver(this.r3);
        this.a.connect("a");
        this.c.connect("a");
        View view = this.a.getView();
        SharedTransportTest.assertEquals((int)2, (int)view.size());
        view = this.c.getView();
        SharedTransportTest.assertEquals((int)2, (int)view.size());
        this.a.send(new Message(null, null, (Serializable)((Object)"msg-1")));
        this.c.send(new Message(null, null, (Serializable)((Object)"msg-2")));
        Util.sleep(1000L);
        List<Message> list = this.r1.getList();
        SharedTransportTest.assertEquals((int)2, (int)list.size());
        list = this.r3.getList();
        SharedTransportTest.assertEquals((int)2, (int)list.size());
        this.r1.clear();
        this.r2.clear();
        this.r3.clear();
        this.b.connect("b");
        this.a.send(new Message(null, null, (Serializable)((Object)"msg-3")));
        this.b.send(new Message(null, null, (Serializable)((Object)"msg-4")));
        this.c.send(new Message(null, null, (Serializable)((Object)"msg-5")));
        Util.sleep(1000L);
        list = this.r1.getList();
        SharedTransportTest.assertEquals((int)2, (int)list.size());
        list = this.r2.getList();
        SharedTransportTest.assertEquals((int)1, (int)list.size());
        list = this.r3.getList();
        SharedTransportTest.assertEquals((int)2, (int)list.size());
    }

    private static void printLists(MyReceiver ... receivers) {
        StringBuilder sb = new StringBuilder();
        int cnt = 1;
        for (MyReceiver rec : receivers) {
            List<Message> list = rec.getList();
            sb.append("receiver #" + cnt++).append(":\n");
            for (Message msg : list) {
                sb.append(msg.getObject()).append("\n");
            }
        }
        System.out.println(sb);
    }

    public void testSharedTransportAndNonsharedTransport() throws Exception {
        this.a = SharedTransportTest.createSharedChannel(SINGLETON_1);
        this.b = this.createChannel();
        this.a.setReceiver(new MyReceiver("first-channel"));
        this.b.setReceiver(new MyReceiver("second-channel"));
        this.a.connect("x");
        this.b.connect("x");
        View view = this.a.getView();
        SharedTransportTest.assertEquals((int)2, (int)view.size());
        view = this.b.getView();
        SharedTransportTest.assertEquals((int)2, (int)view.size());
    }

    public void testCreationOfDifferentCluster() throws Exception {
        this.a = SharedTransportTest.createSharedChannel(SINGLETON_1);
        this.b = SharedTransportTest.createSharedChannel(SINGLETON_2);
        this.a.connect("x");
        this.b.connect("x");
        View view = this.b.getView();
        System.out.println("b's view is " + view);
        SharedTransportTest.assertEquals((int)2, (int)view.size());
    }

    public void testReferenceCounting() throws ChannelException {
        this.a = SharedTransportTest.createSharedChannel(SINGLETON_1);
        this.r1 = new MyReceiver("a");
        this.a.setReceiver(this.r1);
        this.b = SharedTransportTest.createSharedChannel(SINGLETON_1);
        this.r2 = new MyReceiver("b");
        this.b.setReceiver(this.r2);
        this.c = SharedTransportTest.createSharedChannel(SINGLETON_1);
        this.r3 = new MyReceiver("c");
        this.c.setReceiver(this.r3);
        this.a.connect("A");
        this.b.connect("B");
        this.c.connect("C");
        this.a.send(null, null, (Serializable)((Object)"message from a"));
        this.b.send(null, null, (Serializable)((Object)"message from b"));
        this.c.send(null, null, (Serializable)((Object)"message from c"));
        Util.sleep(500L);
        SharedTransportTest.assertEquals((int)1, (int)this.r1.size());
        SharedTransportTest.assertEquals((int)1, (int)this.r2.size());
        SharedTransportTest.assertEquals((int)1, (int)this.r3.size());
        this.r1.clear();
        this.r2.clear();
        this.r3.clear();
        this.b.disconnect();
        System.out.println("\n");
        this.a.send(null, null, (Serializable)((Object)"message from a"));
        this.c.send(null, null, (Serializable)((Object)"message from c"));
        Util.sleep(500L);
        SharedTransportTest.assertEquals((int)1, (int)this.r1.size());
        SharedTransportTest.assertEquals((int)1, (int)this.r3.size());
        this.r1.clear();
        this.r3.clear();
        this.c.disconnect();
        System.out.println("\n");
        this.a.send(null, null, (Serializable)((Object)"message from a"));
        Util.sleep(500L);
        SharedTransportTest.assertEquals((int)1, (int)this.r1.size());
    }

    public void testSimpleReCreation() throws Exception {
        this.a = SharedTransportTest.createSharedChannel(SINGLETON_1);
        this.a.setReceiver(new MyReceiver("A"));
        this.a.connect("A");
        this.a.disconnect();
        this.b = SharedTransportTest.createSharedChannel(SINGLETON_1);
        this.b.setReceiver(new MyReceiver("A'"));
        this.b.connect("A");
    }

    public void testCreationFollowedByDeletion() throws Exception {
        this.a = SharedTransportTest.createSharedChannel(SINGLETON_1);
        this.a.setReceiver(new MyReceiver("A"));
        this.a.connect("A");
        this.b = SharedTransportTest.createSharedChannel(SINGLETON_1);
        this.b.setReceiver(new MyReceiver("B"));
        this.b.connect("B");
        this.b.close();
        this.a.close();
    }

    public void test2ChannelsCreationFollowedByDeletion() throws Exception {
        this.a = SharedTransportTest.createSharedChannel(SINGLETON_1);
        this.a.setReceiver(new MyReceiver("A"));
        this.a.connect("A");
        this.b = SharedTransportTest.createSharedChannel(SINGLETON_2);
        this.b.setReceiver(new MyReceiver("B"));
        this.b.connect("A");
        this.c = SharedTransportTest.createSharedChannel(SINGLETON_2);
        this.c.setReceiver(new MyReceiver("C"));
        this.c.connect("B");
        this.c.send(null, null, (Serializable)((Object)"hello world from C"));
    }

    public void testReCreationWithSurvivingChannel() throws Exception {
        System.out.println("-- creating A");
        this.a = SharedTransportTest.createSharedChannel(SINGLETON_1);
        this.a.setReceiver(new MyReceiver("A"));
        this.a.connect("A");
        System.out.println("-- creating B");
        this.b = SharedTransportTest.createSharedChannel(SINGLETON_1);
        this.b.setReceiver(new MyReceiver("B"));
        this.b.connect("B");
        System.out.println("-- disconnecting A");
        this.a.disconnect();
        System.out.println("-- creating A'");
        this.c = SharedTransportTest.createSharedChannel(SINGLETON_1);
        this.c.setReceiver(new MyReceiver("A'"));
        this.c.connect("A");
    }

    public void testSendingOfMessagesAfterChannelClose() throws ChannelException {
        MyReceiver rec_a = new MyReceiver("A");
        MyReceiver rec_b = new MyReceiver("B");
        MyReceiver rec_c = new MyReceiver("C");
        System.out.println("-- creating A");
        this.a = SharedTransportTest.createSharedChannel(SINGLETON_1);
        this.a.setReceiver(rec_a);
        this.a.connect("A");
        System.out.println("-- creating B");
        this.b = SharedTransportTest.createSharedChannel(SINGLETON_1);
        this.b.setReceiver(rec_b);
        this.b.connect("B");
        System.out.println("-- creating C");
        this.c = SharedTransportTest.createSharedChannel(SINGLETON_2);
        this.c.setReceiver(rec_c);
        this.c.connect("B");
        this.b.send(null, null, (Serializable)((Object)"first"));
        Util.sleep(500L);
        SharedTransportTest.assertSize(1, rec_b, rec_c);
        SharedTransportTest.assertSize(0, rec_a);
        this.a.close();
        this.b.send(null, null, (Serializable)((Object)"second"));
        Util.sleep(500L);
        SharedTransportTest.assertSize(0, rec_a);
        SharedTransportTest.assertSize(2, rec_b, rec_c);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testConcurrentCreation() throws ChannelException, InterruptedException {
        this.a = SharedTransportTest.createSharedChannel(SINGLETON_1);
        this.r1 = new MyReceiver("a");
        this.a.setReceiver(this.r1);
        this.b = SharedTransportTest.createSharedChannel(SINGLETON_1);
        this.r2 = new MyReceiver("b");
        this.b.setReceiver(this.r2);
        this.c = SharedTransportTest.createSharedChannel(SINGLETON_1);
        this.r3 = new MyReceiver("c");
        this.c.setReceiver(this.r3);
        CountDownLatch startLatch = new CountDownLatch(1);
        CountDownLatch finishLatch = new CountDownLatch(3);
        ConnectTask connectA = new ConnectTask(this.a, "a", startLatch, finishLatch);
        Thread threadA = new Thread(connectA);
        threadA.setDaemon(true);
        threadA.start();
        ConnectTask connectB = new ConnectTask(this.b, "b", startLatch, finishLatch);
        Thread threadB = new Thread(connectB);
        threadB.setDaemon(true);
        threadB.start();
        ConnectTask connectC = new ConnectTask(this.c, "c", startLatch, finishLatch);
        Thread threadC = new Thread(connectC);
        threadC.setDaemon(true);
        threadC.start();
        startLatch.countDown();
        try {
            boolean finished = finishLatch.await(20L, TimeUnit.SECONDS);
            if (connectA.exception != null) {
                SharedTransportTest.fail((String)("connectA threw exception " + connectA.exception));
            }
            if (connectB.exception != null) {
                SharedTransportTest.fail((String)("connectB threw exception " + connectB.exception));
            }
            if (connectC.exception != null) {
                SharedTransportTest.fail((String)("connectC threw exception " + connectC.exception));
            }
            if (!finished) {
                if (threadA.isAlive()) {
                    SharedTransportTest.fail((String)"threadA did not finish");
                }
                if (threadB.isAlive()) {
                    SharedTransportTest.fail((String)"threadB did not finish");
                }
                if (threadC.isAlive()) {
                    SharedTransportTest.fail((String)"threadC did not finish");
                }
            }
            Object var11_10 = null;
            if (threadA.isAlive()) {
                threadA.interrupt();
            }
            if (threadB.isAlive()) {
                threadB.interrupt();
            }
            if (threadC.isAlive()) {
                threadC.interrupt();
            }
        }
        catch (Throwable throwable) {
            Object var11_11 = null;
            if (threadA.isAlive()) {
                threadA.interrupt();
            }
            if (threadB.isAlive()) {
                threadB.interrupt();
            }
            if (threadC.isAlive()) {
                threadC.interrupt();
            }
            throw throwable;
        }
    }

    private static void assertSize(int expected, MyReceiver ... receivers) {
        for (MyReceiver recv : receivers) {
            SharedTransportTest.assertEquals((int)expected, (int)recv.size());
        }
    }

    private static JChannel createSharedChannel(String singleton_name) throws ChannelException {
        ProtocolStackConfigurator config = ConfiguratorFactory.getStackConfigurator(CHANNEL_CONFIG);
        ProtocolData[] protocols = config.getProtocolStack();
        ProtocolData transport = protocols[0];
        transport.getParameters().put("singleton_name", new ProtocolParameter("singleton_name", singleton_name));
        return new JChannel(config);
    }

    private static class ConnectTask
    implements Runnable {
        private final Channel channel;
        private final String clusterName;
        private final CountDownLatch startLatch;
        private final CountDownLatch finishLatch;
        private Exception exception;

        ConnectTask(Channel channel, String clusterName, CountDownLatch startLatch, CountDownLatch finishLatch) {
            this.channel = channel;
            this.clusterName = clusterName;
            this.startLatch = startLatch;
            this.finishLatch = finishLatch;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                try {
                    this.startLatch.await();
                    this.channel.connect(this.clusterName);
                }
                catch (Exception e) {
                    e.printStackTrace(System.out);
                    this.exception = e;
                    Object var3_2 = null;
                    this.finishLatch.countDown();
                }
                Object var3_1 = null;
                this.finishLatch.countDown();
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                this.finishLatch.countDown();
                throw throwable;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MyReceiver
    extends ReceiverAdapter {
        final List<Message> list = new LinkedList<Message>();
        final String name;

        private MyReceiver(String name) {
            this.name = name;
        }

        public List<Message> getList() {
            return this.list;
        }

        public int size() {
            return this.list.size();
        }

        public void clear() {
            this.list.clear();
        }

        @Override
        public void receive(Message msg) {
            System.out.println("[" + this.name + "]: received message from " + msg.getSrc() + ": " + msg.getObject());
            this.list.add(msg);
        }

        @Override
        public void viewAccepted(View new_view) {
            StringBuilder sb = new StringBuilder();
            sb.append("[" + this.name + "]: view = " + new_view);
            System.out.println(sb);
        }

        public String toString() {
            return this.size() + " message(s)";
        }
    }
}

