/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting.transport.servlet;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jboss.logging.Logger;
import org.jboss.remoting.InvocationRequest;
import org.jboss.remoting.InvocationResponse;
import org.jboss.remoting.InvokerLocator;
import org.jboss.remoting.marshal.MarshalFactory;
import org.jboss.remoting.marshal.Marshaller;
import org.jboss.remoting.marshal.UnMarshaller;
import org.jboss.remoting.marshal.VersionedMarshaller;
import org.jboss.remoting.marshal.VersionedUnMarshaller;
import org.jboss.remoting.transport.servlet.ServletServerInvokerMBean;
import org.jboss.remoting.transport.web.WebServerInvoker;
import org.jboss.remoting.transport.web.WebUtil;
import org.jboss.remoting.util.SecurityUtility;

public class ServletServerInvoker
extends WebServerInvoker
implements ServletServerInvokerMBean {
    public static final String UNWRAP_SINGLETON_ARRAYS = "unwrapSingletonArrays";
    private static final Logger log = Logger.getLogger(ServletServerInvoker.class);
    private boolean unwrapSingletonArrays;
    private boolean useRemotingContentType;

    public ServletServerInvoker(InvokerLocator locator) {
        super(locator);
        this.init();
    }

    public ServletServerInvoker(InvokerLocator locator, Map configuration) {
        super(locator, configuration);
        this.init();
    }

    protected String getDefaultDataType() {
        return "http";
    }

    protected void init() {
        Object val = this.configuration.get(UNWRAP_SINGLETON_ARRAYS);
        if (val != null) {
            try {
                this.unwrapSingletonArrays = Boolean.valueOf((String)val);
                log.debug((Object)(this + " setting unwrapSingletonArrays to " + this.unwrapSingletonArrays));
            }
            catch (Exception e) {
                log.warn((Object)(this + " could not convert " + UNWRAP_SINGLETON_ARRAYS + " value of " + val + " to a boolean value."));
            }
        }
        if ((val = this.configuration.get("useRemotingContentType")) instanceof String) {
            this.useRemotingContentType = Boolean.valueOf((String)val);
        } else if (val != null) {
            log.warn((Object)("useRemotingContentType value should be a String: " + val));
        }
        log.debug((Object)(this + " useRemotingContentType: " + this.useRemotingContentType));
    }

    public void processRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        Object o;
        HashMap<String, String> metadata = new HashMap<String, String>();
        Enumeration enumer = request.getHeaderNames();
        while (enumer.hasMoreElements()) {
            Object obj = enumer.nextElement();
            String headerKey = (String)obj;
            String headerValue = request.getHeader(headerKey);
            metadata.put(headerKey, headerValue);
        }
        Map urlParams = request.getParameterMap();
        if (this.unwrapSingletonArrays) {
            for (Object key : urlParams.keySet()) {
                Object value = urlParams.get(key);
                String[] valueArray = (String[])value;
                if (valueArray.length == 1) {
                    value = valueArray[0];
                }
                metadata.put((String)key, (String)value);
            }
        } else {
            metadata.putAll(urlParams);
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)"metadata:");
            for (Object key : metadata.keySet()) {
                log.trace((Object)("  " + key + ": " + metadata.get(key)));
            }
        }
        if ((o = this.configuration.get("preserveLines")) != null) {
            if (o instanceof String[]) {
                metadata.put("preserveLines", ((String[])o)[0]);
            } else {
                metadata.put("preserveLines", (String)o);
            }
        }
        String requestContentType = request.getContentType();
        try {
            Object invocationResponse = null;
            ServletInputStream inputStream = request.getInputStream();
            UnMarshaller unmarshaller = MarshalFactory.getUnMarshaller("http", this.getSerializationType());
            Object obj = null;
            obj = unmarshaller instanceof VersionedUnMarshaller ? ((VersionedUnMarshaller)unmarshaller).read((InputStream)inputStream, metadata, this.getVersion()) : unmarshaller.read((InputStream)inputStream, metadata);
            inputStream.close();
            InvocationRequest invocationRequest = null;
            invocationRequest = obj instanceof InvocationRequest ? (InvocationRequest)obj : (WebUtil.isBinary(requestContentType) ? this.getInvocationRequest(metadata, obj) : this.createNewInvocationRequest(metadata, obj));
            String remoteAddressString = request.getRemoteAddr();
            InetAddress remoteAddress = ServletServerInvoker.getAddressByName(remoteAddressString);
            HashMap<String, InetAddress> requestPayload = invocationRequest.getRequestPayload();
            if (requestPayload == null) {
                requestPayload = new HashMap<String, InetAddress>();
                invocationRequest.setRequestPayload(requestPayload);
            }
            requestPayload.put("clientAddress", remoteAddress);
            try {
                invocationResponse = this.invoke(invocationRequest);
            }
            catch (Throwable ex) {
                log.debug((Object)"Error thrown calling invoke on server invoker.", ex);
                invocationResponse = null;
                response.sendError(500, "Error processing invocation request.  " + ex.getMessage());
            }
            if (invocationResponse != null) {
                if (ServletServerInvoker.isInvalidContentType(requestContentType)) {
                    log.warn((Object)("Ignoring invalid content-type from client: " + requestContentType));
                } else {
                    response.setContentType(requestContentType);
                }
                int iContentLength = this.getContentLength(invocationResponse);
                response.setContentLength(iContentLength);
                ServletOutputStream outputStream = response.getOutputStream();
                Marshaller marshaller = MarshalFactory.getMarshaller("http", this.getSerializationType());
                if (marshaller instanceof VersionedMarshaller) {
                    ((VersionedMarshaller)marshaller).write(invocationResponse, (OutputStream)outputStream, this.getVersion());
                } else {
                    marshaller.write(invocationResponse, (OutputStream)outputStream);
                }
                outputStream.close();
            }
        }
        catch (ClassNotFoundException e) {
            log.error((Object)"Error processing invocation request due to class not being found.", (Throwable)e);
            response.sendError(500, "Error processing invocation request due to class not being found.  " + e.getMessage());
        }
    }

    public byte[] processRequest(HttpServletRequest request, byte[] requestByte, HttpServletResponse response) throws ServletException, IOException {
        String path;
        byte[] retval = new byte[]{};
        boolean isRemotingUserAgent = false;
        String userAgent = request.getHeader("User-Agent");
        if (userAgent != null) {
            isRemotingUserAgent = userAgent.startsWith("JBossRemoting");
        }
        HashMap<String, String> metadata = new HashMap<String, String>();
        Enumeration enumer = request.getHeaderNames();
        while (enumer.hasMoreElements()) {
            Object obj = enumer.nextElement();
            String headerKey = (String)obj;
            String headerValue = request.getHeader(headerKey);
            metadata.put(headerKey, headerValue);
        }
        Map urlParams = request.getParameterMap();
        if (this.unwrapSingletonArrays) {
            for (Object key : urlParams.keySet()) {
                Object value = urlParams.get(key);
                String[] valueArray = (String[])value;
                if (valueArray.length == 1) {
                    value = valueArray[0];
                }
                metadata.put((String)key, (String)value);
            }
        } else {
            metadata.putAll(urlParams);
        }
        metadata.put("MethodType", request.getMethod());
        Object o = this.configuration.get("preserveLines");
        if (o != null) {
            if (o instanceof String[]) {
                metadata.put("preserveLines", ((String[])o)[0]);
            } else {
                metadata.put("preserveLines", (String)o);
            }
        }
        if ((path = request.getPathTranslated()) != null) {
            metadata.put("Path", path);
        }
        metadata.put("useRemotingContentType", Boolean.toString(this.useRemotingContentType));
        String remotingContentType = (String)metadata.get("remotingContentType");
        if (remotingContentType == null) {
            remotingContentType = (String)metadata.get("remotingcontenttype");
        }
        String requestContentType = request.getContentType();
        try {
            Map responseMap;
            InvocationRequest invocationRequest = null;
            Object responseObject = null;
            boolean isError = false;
            String method = request.getMethod();
            if (method.equals("GET") || method.equals("HEAD") || method.equals("OPTIONS") && request.getContentLength() <= 0) {
                invocationRequest = this.createNewInvocationRequest(metadata, null);
            } else {
                ServletInputStream inputStream = request.getInputStream();
                UnMarshaller unmarshaller = this.getUnMarshaller();
                Object obj = null;
                obj = unmarshaller instanceof VersionedUnMarshaller ? ((VersionedUnMarshaller)unmarshaller).read(new ByteArrayInputStream(requestByte), metadata, this.getVersion()) : unmarshaller.read(new ByteArrayInputStream(requestByte), metadata);
                inputStream.close();
                if (obj instanceof InvocationRequest) {
                    invocationRequest = (InvocationRequest)obj;
                    Map requestMap = invocationRequest.getRequestPayload();
                    if (requestMap == null) {
                        invocationRequest.setRequestPayload(metadata);
                    } else {
                        requestMap.putAll(metadata);
                    }
                } else {
                    invocationRequest = this.useRemotingContentType && "remotingContentTypeNonString".equalsIgnoreCase(remotingContentType) || !this.useRemotingContentType && WebUtil.isBinary(requestContentType) ? this.getInvocationRequest(metadata, obj) : this.createNewInvocationRequest(metadata, obj);
                }
            }
            String remoteAddressString = request.getRemoteAddr();
            InetAddress remoteAddress = ServletServerInvoker.getAddressByName(remoteAddressString);
            HashMap<String, InetAddress> requestPayload = invocationRequest.getRequestPayload();
            if (requestPayload == null) {
                requestPayload = new HashMap<String, InetAddress>();
                invocationRequest.setRequestPayload(requestPayload);
            }
            requestPayload.put("clientAddress", remoteAddress);
            try {
                responseObject = this.invoke(invocationRequest);
            }
            catch (Throwable ex) {
                log.debug((Object)"Error thrown calling invoke on server invoker.", ex);
                if (this.checkForNoExceptionReturn(metadata)) {
                    log.trace((Object)"Returning error message instead of Exception");
                    response.addHeader("remotingContentType", "remotingContentTypeString");
                    response.sendError(500, "Error occurred processing invocation request. ");
                    return retval;
                }
                responseObject = ex;
                isError = true;
            }
            int status = 200;
            if (responseObject != null) {
                if (isError) {
                    status = 500;
                }
            } else if (!isRemotingUserAgent || "HEAD".equals(request.getMethod())) {
                status = 204;
            }
            if ((responseMap = invocationRequest.getReturnPayload()) != null) {
                Integer handlerStatus = (Integer)responseMap.remove("ResponseCode");
                if (handlerStatus != null) {
                    status = handlerStatus;
                }
                Set entries = responseMap.entrySet();
                for (Map.Entry entry : entries) {
                    response.addHeader(entry.getKey().toString(), entry.getValue().toString());
                }
            }
            response.setStatus(status);
            if (isRemotingUserAgent && !(invocationRequest instanceof WebServerInvoker.CreatedInvocationRequest)) {
                responseObject = new InvocationResponse(invocationRequest.getSessionId(), responseObject, isError, responseMap);
            }
            if (responseObject != null) {
                String responseContentType = null;
                if (responseMap != null) {
                    responseContentType = (String)responseMap.get("Content-Type");
                }
                if (responseContentType != null) {
                    if (ServletServerInvoker.isInvalidContentType(responseContentType)) {
                        log.warn((Object)("Ignoring invalid content-type from ServerInvocationHandler: " + responseContentType));
                        responseContentType = WebUtil.getContentType(responseObject);
                    }
                } else {
                    responseContentType = WebUtil.getContentType(responseObject);
                }
                response.setContentType(responseContentType);
                ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                Marshaller marshaller = this.getMarshaller();
                if (marshaller instanceof VersionedMarshaller) {
                    ((VersionedMarshaller)marshaller).write(responseObject, outputStream, this.getVersion());
                } else {
                    marshaller.write(responseObject, outputStream);
                }
                retval = outputStream.toByteArray();
                response.setContentLength(retval.length);
            }
            if (responseObject instanceof String) {
                response.addHeader("remotingContentType", "remotingContentTypeString");
            } else {
                response.addHeader("remotingContentType", "remotingContentTypeNonString");
            }
        }
        catch (ClassNotFoundException e) {
            log.error((Object)"Error processing invocation request due to class not being found.", (Throwable)e);
            response.sendError(500, "Error processing invocation request due to class not being found.  " + e.getMessage());
        }
        return retval;
    }

    private static boolean isInvalidContentType(String contentType) {
        return contentType.indexOf(10) + contentType.indexOf(13) > -2;
    }

    private boolean checkForNoExceptionReturn(Map headers) {
        Object val;
        boolean flag = false;
        if (headers != null && (val = headers.get("dont-return-exception")) != null) {
            if (val instanceof String) {
                flag = Boolean.valueOf((String)val);
            } else if (val instanceof String[]) {
                String param = ((String[])val)[0];
                flag = Boolean.valueOf(param);
            }
        }
        return flag;
    }

    private static InetAddress getAddressByName(final String host) throws UnknownHostException {
        if (SecurityUtility.skipAccessControl()) {
            return InetAddress.getByName(host);
        }
        try {
            return (InetAddress)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException {
                    return InetAddress.getByName(host);
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (UnknownHostException)e.getCause();
        }
    }
}

