/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.proxy.container;

import java.io.Externalizable;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import javassist.CannotCompileException;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtConstructor;
import javassist.CtField;
import javassist.CtMethod;
import javassist.CtNewConstructor;
import javassist.CtNewMethod;
import javassist.Modifier;
import javassist.NotFoundException;
import javassist.SerialVersionUID;
import javassist.bytecode.AnnotationsAttribute;
import javassist.bytecode.AttributeInfo;
import javassist.bytecode.ClassFile;
import javassist.bytecode.ParameterAnnotationsAttribute;
import javassist.bytecode.SignatureAttribute;
import javassist.bytecode.annotation.Annotation;
import org.jboss.aop.Advised;
import org.jboss.aop.Advisor;
import org.jboss.aop.AspectManager;
import org.jboss.aop.InstanceAdvised;
import org.jboss.aop.MethodInfo;
import org.jboss.aop.instrument.Instrumentor;
import org.jboss.aop.instrument.TransformerCommon;
import org.jboss.aop.introduction.InterfaceIntroduction;
import org.jboss.aop.proxy.container.AspectManaged;
import org.jboss.aop.proxy.container.ClassProxyContainer;
import org.jboss.aop.proxy.container.ContainerProxyCacheKey;
import org.jboss.aop.proxy.container.Delegate;
import org.jboss.aop.proxy.container.MarshalledContainerProxy;
import org.jboss.aop.proxy.container.SecurityActions;
import org.jboss.aop.util.JavassistMethodHashing;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContainerProxyFactory {
    static final String DELEGATE = Delegate.class.getName();
    static final String ASPECT_MANAGED = AspectManaged.class.getName();
    private static final HashMap EMPTY_HASHMAP = new HashMap();
    private static final String ADVISED = Advised.class.getName();
    private static final String INSTANCE_ADVISED = InstanceAdvised.class.getName();
    private static final CtClass[] EMPTY_CTCLASS_ARRAY = new CtClass[0];
    public static final String PROXY_NAME_PREFIX = "AOPContainerProxy$";
    public static final String PROXY_CLASSES_DEFAULT_PACKAGE = "org.jboss.aop.generatedproxies";
    private static Object maplock = new Object();
    private static WeakHashMap<ClassLoader, WeakHashMap<Class<?>, Map<ContainerProxyCacheKey, WeakReference<Class<?>>>>> proxyCache = new WeakHashMap();
    private static volatile int counter = 0;
    private static CtMethod setDelegateMethod;
    private boolean objectAsSuper;
    private Advisor advisor;
    private Class<?> clazz;
    private CtClass proxy;
    private ClassPool pool;
    private boolean isAdvised;
    ProxyStrategy proxyStrategy;
    private CtConstructor defaultCtor;
    private HashSet<Long> hardcodedMethods = new HashSet();
    private ClassLoader loader;

    public static Class<?> getProxyClass(Class<?> clazz, AspectManager manager) throws Exception {
        ContainerProxyCacheKey key = new ContainerProxyCacheKey(clazz);
        ClassProxyContainer container = ContainerProxyFactory.getTempClassContainer(clazz, manager);
        return ContainerProxyFactory.getProxyClass(false, key, container);
    }

    public static Class<?> getProxyClass(boolean objectAsSuper, ContainerProxyCacheKey key, Advisor advisor) throws Exception {
        return ContainerProxyFactory.getProxyClass(objectAsSuper, key, advisor, null);
    }

    public static Class<?> getProxyClass(boolean objectAsSuper, ClassLoader loader, ContainerProxyCacheKey key, Advisor advisor) throws Exception {
        return ContainerProxyFactory.getProxyClass(objectAsSuper, loader, key, advisor, null);
    }

    public static Class<?> getProxyClass(boolean objectAsSuper, ContainerProxyCacheKey key, Advisor advisor, MarshalledContainerProxy outOfVmProxy) throws Exception {
        return ContainerProxyFactory.getProxyClass(objectAsSuper, null, key, advisor, outOfVmProxy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Class<?> getProxyClass(boolean objectAsSuper, ClassLoader loader, ContainerProxyCacheKey key, Advisor advisor, MarshalledContainerProxy outOfVmProxy) throws Exception {
        ClassPool pool;
        ClassLoader cl;
        Class<?> clazz = key.getClazz();
        if (Delegate.class.isAssignableFrom(clazz)) {
            clazz = clazz.getSuperclass();
        }
        if ((cl = loader) == null) {
            cl = SecurityActions.getClassLoader(clazz);
        }
        if ((pool = AspectManager.instance().findClassPool(cl)) == null) {
            throw new NullPointerException("Could not find ClassPool");
        }
        Class<?> proxyClass = null;
        Object object = maplock;
        synchronized (object) {
            Map<ContainerProxyCacheKey, WeakReference<Class<?>>> map;
            WeakHashMap<Class<Object>, Map<ContainerProxyCacheKey, WeakReference<Class<Object>>>> proxiesForLoader = proxyCache.get(pool.getClassLoader());
            if (proxiesForLoader == null) {
                proxiesForLoader = new WeakHashMap();
                proxyCache.put(pool.getClassLoader(), proxiesForLoader);
            }
            if ((map = proxiesForLoader.get(clazz)) == null) {
                map = new HashMap();
                proxiesForLoader.put(clazz, map);
            } else {
                WeakReference<Class<?>> proxyClassRef = map.get(key);
                if (proxyClassRef != null) {
                    proxyClass = (Class<?>)proxyClassRef.get();
                }
            }
            if (proxyClass == null) {
                proxyClass = ContainerProxyFactory.generateProxy(objectAsSuper, cl, clazz, advisor, outOfVmProxy);
                map.put(key, new WeakReference(proxyClass));
            }
        }
        return proxyClass;
    }

    private static Class<?> generateProxy(boolean objectAsSuper, ClassLoader loader, Class<?> clazz, Advisor advisor, MarshalledContainerProxy outOfVmProxy) throws Exception {
        ArrayList<InterfaceIntroduction> introductions = advisor.getInterfaceIntroductions();
        CtClass proxy = ContainerProxyFactory.createProxyCtClass(objectAsSuper, loader, introductions, clazz, advisor, outOfVmProxy);
        ProtectionDomain pd = clazz.getProtectionDomain();
        Class<?> proxyClass = TransformerCommon.toClass(proxy, pd);
        return proxyClass;
    }

    private static ClassProxyContainer getTempClassContainer(Class<?> clazz, AspectManager manager) {
        ClassProxyContainer container = new ClassProxyContainer("temp", manager);
        container.setClass(clazz);
        for (InterfaceIntroduction intro : container.getManager().getInterfaceIntroductions().values()) {
            if (!intro.matches((Advisor)container, container.getClazz())) continue;
            container.addInterfaceIntroduction(intro);
        }
        return container;
    }

    private static CtClass createProxyCtClass(boolean objectAsSuper, ArrayList<InterfaceIntroduction> mixins, Class<?> clazz, Advisor advisor) throws Exception {
        return ContainerProxyFactory.createProxyCtClass(objectAsSuper, null, mixins, clazz, advisor, null);
    }

    private static CtClass createProxyCtClass(boolean objectAsSuper, ClassLoader loader, ArrayList<InterfaceIntroduction> mixins, Class<?> clazz, Advisor advisor, MarshalledContainerProxy outOfVmProxy) throws Exception {
        ContainerProxyFactory factory = new ContainerProxyFactory(objectAsSuper, loader, mixins, clazz, advisor, outOfVmProxy);
        return factory.createProxyCtClass();
    }

    private ContainerProxyFactory(boolean objectAsSuper, ClassLoader loader, ArrayList<InterfaceIntroduction> mixins, Class<?> clazz, Advisor advisor, MarshalledContainerProxy outOfVmProxy) {
        this.objectAsSuper = objectAsSuper;
        this.clazz = clazz;
        this.advisor = advisor;
        this.isAdvised = Advised.class.isAssignableFrom(clazz);
        this.loader = loader;
        this.proxyStrategy = outOfVmProxy == null ? new OriginalProxyStrategy(mixins) : new UnmarshalledInRemoteJVMProxyStrategy(outOfVmProxy);
    }

    private CtClass createProxyCtClass() throws Exception {
        if (this.loader != null) {
            this.validateLoader();
            this.pool = AspectManager.instance().findClassPool(this.loader);
        }
        if (this.pool == null) {
            this.pool = AspectManager.instance().findClassPool(this.clazz);
        }
        if (this.pool == null) {
            throw new NullPointerException("Could not find ClassPool");
        }
        this.createBasics();
        this.addMethodsAndMixins();
        this.overrideSpecialMethods(this.clazz, this.proxy);
        SerialVersionUID.setSerialVersionUID((CtClass)this.proxy);
        return this.proxy;
    }

    private void validateLoader() throws Exception {
        if (this.loader != null && this.clazz != null) {
            try {
                this.loader.loadClass(this.clazz.getName());
            }
            catch (ClassNotFoundException e) {
                throw new Exception("Could not load " + this.clazz.getName() + " from " + this.loader);
            }
        }
    }

    private CtClass createBasics() throws Exception {
        Class proxySuper = this.objectAsSuper ? Object.class : this.clazz;
        String classname = this.getClassName();
        CtClass template = this.pool.get("org.jboss.aop.proxy.container.ProxyTemplate");
        CtClass superclass = this.pool.get(proxySuper.getName());
        this.proxy = TransformerCommon.makeClass(this.pool, classname, superclass);
        this.proxy.addInterface(this.pool.get("org.jboss.aop.instrument.Untransformable"));
        Class<?>[] interfaces = proxySuper.getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            CtClass interfaze = this.pool.get(interfaces[i].getName());
            this.proxy.addInterface(interfaze);
        }
        this.copyConstructors(superclass, this.proxy);
        this.addFieldFromTemplate(template, "mixins");
        this.proxy.addInterface(this.pool.get("org.jboss.aop.proxy.container.Delegate"));
        this.addFieldFromTemplate(template, "delegate", superclass);
        this.addMethodFromTemplate(template, "getDelegate", "{ return delegate; }");
        setDelegateMethod = this.addMethodFromTemplate(template, "setDelegate", "{ this.delegate = (" + proxySuper.getName() + ")$1; }");
        this.addFieldFromTemplate(template, "key");
        this.addMethodFromTemplate(template, "setContainerProxyCacheKey", "{this.key=$1;}");
        this.proxy.addInterface(this.pool.get("org.jboss.aop.proxy.container.AspectManaged"));
        this.addFieldFromTemplate(template, "currentAdvisor");
        this.addFieldFromTemplate(template, "classAdvisor");
        this.addMethodFromTemplate(template, "getAdvisor", "{return classAdvisor;}");
        this.addMethodFromTemplate(template, "setAdvisor", "{this.classAdvisor = $1;currentAdvisor = classAdvisor;}");
        this.addFieldFromTemplate(template, "metadata");
        this.addMethodFromTemplate(template, "setMetadata", "{this.metadata = $1;}");
        this.addFieldFromTemplate(template, "instanceAdvisor");
        this.addMethodFromTemplate(template, "setInstanceAdvisor", this.instanceAdvisorSetterBody());
        this.addMethodFromTemplate(template, "getInstanceAdvisor", this.instanceAdvisorGetterBody());
        this.addMethodFromTemplate(template, "writeReplace", this.writeReplaceObjectBody());
        this.addMethodFromTemplate(template, "localUnmarshal", this.localUnmarshalObjectBody(superclass));
        this.addMethodFromTemplate(template, "remoteUnmarshal", this.remoteUnmarshalObjectBody(superclass));
        if (this.objectAsSuper) {
            this.addMethodFromTemplate(template, "equals", this.equalsBody());
            this.addMethodFromTemplate(template, "hashCode", this.hashCodeBody());
        }
        this.addMethodFromTemplate(template, "toString", this.toStringBody());
        this.copyAnnotations(superclass, this.proxy);
        this.copySignature(superclass, this.proxy);
        return this.proxy;
    }

    private String instanceAdvisorSetterBody() {
        return "{   synchronized (this)   {   if (this.instanceAdvisor != null)   {      throw new RuntimeException(\"InstanceAdvisor already set\");   }   if (!($1 instanceof org.jboss.aop.proxy.container.InstanceProxyContainer))   {      throw new RuntimeException(\"Wrong type for instance advisor: \" + $1);   }   this.instanceAdvisor = $1;   currentAdvisor = (org.jboss.aop.proxy.container.InstanceProxyContainer)$1;   }}";
    }

    private String instanceAdvisorGetterBody() {
        return "{   synchronized(this)   {      if (instanceAdvisor == null)      {         org.jboss.aop.proxy.container.InstanceProxyContainer ipc = ((org.jboss.aop.proxy.container.ClassProxyContainer)currentAdvisor).createInstanceProxyContainer();         setInstanceAdvisor(ipc);      }   }   return instanceAdvisor;}";
    }

    private String writeReplaceObjectBody() {
        return "{   return new " + MarshalledContainerProxy.class.getName() + "(" + "      this," + "      this.key," + "      this.mixins," + "      this.delegate," + "      this.currentAdvisor," + "      this.metadata);" + "}";
    }

    private String localUnmarshalObjectBody(CtClass superclass) {
        return "{      this.delegate = (" + superclass.getName() + ")$1.getDelegate();" + "      this.mixins = $1.getMixins();" + "      this.metadata = $1.getMetadata();" + "      this.key = $1.getKey();" + "      java.lang.Class clazz = $1.getClazz();" + "      this.classAdvisor = org.jboss.aop.proxy.container.ContainerCache.getCachedContainer(this.key);" + "      this.currentAdvisor = classAdvisor;" + "      if ($1.getInstanceAdvisorDomainName() != null)" + "      {" + "         org.jboss.aop.proxy.container.ProxyAdvisorDomain domain = (org.jboss.aop.proxy.container.ProxyAdvisorDomain)org.jboss.aop.AspectManager.getTopLevelAspectManager().findManagerByName($1.getInstanceAdvisorDomainName());" + "         this.currentAdvisor = domain.getAdvisor();" + "         this.instanceAdvisor = this.currentAdvisor;" + "      }" + "}";
    }

    private String remoteUnmarshalObjectBody(CtClass superclass) {
        return "{   this.delegate = (" + superclass.getName() + ")$1.getDelegate();" + "   this.mixins = $1.getMixins();" + "   this.metadata = $1.getMetadata();" + "   this.key = $1.getKey();" + "   java.lang.Class clazz = $1.getClazz();" + "   this.classAdvisor = $2;" + "   this.currentAdvisor = $2;" + "   this.instanceAdvisor = $2;" + "}";
    }

    private String equalsBody() {
        return "{   if (delegate != null)   {      if ($1 != null && $1 instanceof org.jboss.aop.proxy.container.Delegate)         $1 = ((org.jboss.aop.proxy.container.Delegate) $1).getDelegate();      return delegate.equals($1);   }   else      return super.equals($1);}";
    }

    private String hashCodeBody() {
        return "{   if (delegate != null)      return delegate.hashCode();   else      return super.hashCode();}";
    }

    private String toStringBody() {
        return "{   if (delegate != null)      return delegate.toString() + \" (proxied by \" + this.getClass().getName() + \"@\" + java.lang.Integer.toHexString(java.lang.System.identityHashCode(this)) + \")\";   else      return super.toString() + \" (empty proxy of \" + this.getClass().getSuperclass().getName() + \")\";}";
    }

    private CtField addFieldFromTemplate(CtClass template, String name) throws Exception {
        return this.addFieldFromTemplate(template, name, null);
    }

    private CtField addFieldFromTemplate(CtClass template, String name, CtClass type) throws Exception {
        CtField templateField = template.getField(name);
        CtClass fieldType = type == null ? templateField.getType() : type;
        CtField field = new CtField(fieldType, name, this.proxy);
        field.setModifiers(templateField.getModifiers());
        Instrumentor.addSyntheticAttribute(field);
        this.proxy.addField(field);
        return field;
    }

    private CtMethod addMethodFromTemplate(CtClass template, String name, String body) throws Exception {
        CtMethod templateMethod = template.getDeclaredMethod(name);
        CtMethod method = CtNewMethod.make((CtClass)templateMethod.getReturnType(), (String)name, (CtClass[])templateMethod.getParameterTypes(), (CtClass[])templateMethod.getExceptionTypes(), (String)body, (CtClass)this.proxy);
        method.setModifiers(templateMethod.getModifiers());
        Instrumentor.addSyntheticAttribute(method);
        this.proxy.addMethod(method);
        this.hardcodedMethods.add(JavassistMethodHashing.methodHash(method));
        return method;
    }

    private void copyConstructors(CtClass superclass, CtClass proxy) throws Exception {
        CtConstructor[] ctors = superclass.getConstructors();
        int minParameters = Integer.MAX_VALUE;
        CtConstructor bestCtor = null;
        for (int i = 0; i < ctors.length; ++i) {
            CtClass[] params = ctors[i].getParameterTypes();
            CtConstructor ctor = CtNewConstructor.make((CtClass[])ctors[i].getParameterTypes(), (CtClass[])ctors[i].getExceptionTypes(), (int)2, null, null, (CtClass)proxy);
            ctor.setModifiers(ctors[i].getModifiers());
            proxy.addConstructor(ctor);
            if (params.length < minParameters) {
                bestCtor = ctor;
                minParameters = params.length;
            }
            if (params.length != 0) continue;
            this.defaultCtor = ctor;
        }
        if (minParameters > 0) {
            this.createDefaultConstructor(bestCtor);
        }
    }

    private void createDefaultConstructor(CtConstructor bestCtor) throws NotFoundException, CannotCompileException {
        CtClass[] params = bestCtor.getParameterTypes();
        StringBuffer superCall = new StringBuffer("super(");
        for (int i = 0; i < params.length; ++i) {
            if (i > 0) {
                superCall.append(", ");
            }
            superCall.append(this.getNullType(params[i]));
        }
        superCall.append(");");
        this.defaultCtor = CtNewConstructor.make((CtClass[])EMPTY_CTCLASS_ARRAY, (CtClass[])EMPTY_CTCLASS_ARRAY, (String)("{" + superCall.toString() + "}"), (CtClass)this.proxy);
        Instrumentor.addSyntheticAttribute(this.defaultCtor);
        this.proxy.addConstructor(this.defaultCtor);
    }

    private String getNullType(CtClass clazz) {
        if (!clazz.isPrimitive()) {
            return "null";
        }
        if (clazz.equals(CtClass.booleanType)) {
            return "false";
        }
        if (clazz.equals(CtClass.charType)) {
            return "'0'";
        }
        if (clazz.equals(CtClass.byteType)) {
            return "0";
        }
        if (clazz.equals(CtClass.shortType)) {
            return "0";
        }
        if (clazz.equals(CtClass.intType)) {
            return "0";
        }
        if (clazz.equals(CtClass.longType)) {
            return "0L";
        }
        if (clazz.equals(CtClass.floatType)) {
            return "0f";
        }
        if (clazz.equals(CtClass.doubleType)) {
            return "0d";
        }
        return "";
    }

    private void addMethodsAndMixins() throws Exception {
        HashSet<Long> addedMethods = new HashSet<Long>();
        this.createMixinsAndIntroductions(addedMethods);
        this.createProxyMethods(addedMethods);
    }

    private void createMixinsAndIntroductions(HashSet<Long> addedMethods) throws Exception {
        HashSet<String> addedInterfaces = new HashSet<String>();
        Set<String> implementedInterfaces = this.interfacesAsSet();
        if (this.proxyStrategy.hasIntroductions()) {
            HashMap<String, Integer> intfs = new HashMap<String, Integer>();
            HashMap<String, Integer> mixinIntfs = new HashMap<String, Integer>();
            ArrayList<MixinInfo> mixes = new ArrayList<MixinInfo>();
            this.proxyStrategy.getMixins(intfs, mixinIntfs, mixes);
            HashMap<Long, CtMethod> allMethods = JavassistMethodHashing.getDeclaredMethodMap(this.proxy);
            addedMethods.addAll(allMethods.keySet());
            this.createMixins(addedMethods, mixes, addedInterfaces, implementedInterfaces);
            this.createIntroductions(addedMethods, intfs, addedInterfaces, implementedInterfaces);
        }
    }

    private void createMixins(HashSet<Long> addedMethods, ArrayList<MixinInfo> mixes, HashSet<String> addedInterfaces, Set<String> implementedInterfaces) throws Exception {
        for (int mixinId = 0; mixinId < mixes.size(); ++mixinId) {
            MixinInfo mixin = mixes.get(mixinId);
            String[] intfs = mixin.getInterfaces();
            for (int ifId = 0; ifId < intfs.length; ++ifId) {
                String intf = intfs[ifId];
                if (addedInterfaces.contains(intf)) {
                    throw new Exception("2 mixins are implementing the same interfaces " + intf);
                }
                if (implementedInterfaces.contains(intf)) {
                    throw new Exception("Attempting to mixin interface already used by class " + intf);
                }
                CtClass intfClass = this.pool.get(intf);
                CtMethod[] methods = intfClass.getMethods();
                HashSet<Long> mixinMethods = new HashSet<Long>();
                for (int m = 0; m < methods.length; ++m) {
                    Long hash;
                    if (methods[m].getDeclaringClass().getName().equals("java.lang.Object") || mixinMethods.contains(hash = new Long(JavassistMethodHashing.methodHash(methods[m])))) continue;
                    if (addedMethods.contains(hash)) {
                        throw new Exception("More than one mixin has same method");
                    }
                    mixinMethods.add(hash);
                    addedMethods.add(hash);
                    String aopReturnStr = methods[m].getReturnType().equals(CtClass.voidType) ? "" : "return ($r)";
                    String returnStr = methods[m].getReturnType().equals(CtClass.voidType) ? "" : "return ";
                    String args = "null";
                    if (methods[m].getParameterTypes().length > 0) {
                        args = "$args";
                    }
                    String code = "{      try{      " + intf + " mixin = (" + intf + ")mixins[" + mixinId + "];" + "       org.jboss.aop.MethodInfo mi = currentAdvisor.getMethodInfo(" + hash + "L); " + "       org.jboss.aop.advice.Interceptor[] interceptors = mi.getInterceptors();" + "       if (mi != null && interceptors != (Object[])null && interceptors.length > 0) { " + "          org.jboss.aop.proxy.container.ContainerProxyMethodInvocation invocation = new org.jboss.aop.proxy.container.ContainerProxyMethodInvocation(mi, interceptors, this); " + "          invocation.setArguments(" + args + "); " + "          invocation.setTargetObject(mixin); " + "          invocation.setMetaData(metadata);" + "          " + aopReturnStr + " invocation.invokeNext(); " + "       } else { " + "       " + returnStr + " mixin." + methods[m].getName() + "($$);" + "       } " + "    }finally{" + "    }" + "}";
                    CtMethod newMethod = CtNewMethod.make((CtClass)methods[m].getReturnType(), (String)methods[m].getName(), (CtClass[])methods[m].getParameterTypes(), (CtClass[])methods[m].getExceptionTypes(), (String)code, (CtClass)this.proxy);
                    newMethod.setModifiers(1);
                    this.proxy.addMethod(newMethod);
                    this.copySignature(methods[m], newMethod);
                }
                this.proxy.addInterface(intfClass);
                addedInterfaces.add(intfClass.getName());
            }
        }
    }

    private void createProxyMethods(HashSet<Long> addedMethods) throws Exception {
        HashMap<Long, CtMethod> allMethods = JavassistMethodHashing.getMethodMap(this.proxy.getSuperclass());
        for (Map.Entry<Long, CtMethod> entry : allMethods.entrySet()) {
            Long hash;
            CtMethod m = entry.getValue();
            if (!Modifier.isPublic((int)m.getModifiers()) || Modifier.isStatic((int)m.getModifiers()) || Modifier.isFinal((int)m.getModifiers()) || addedMethods.contains(hash = entry.getKey()) || this.hardcodedMethods.contains(hash)) continue;
            addedMethods.add(hash);
            String aopReturnStr = m.getReturnType().equals(CtClass.voidType) ? "" : "return ($r)";
            String returnStr = m.getReturnType().equals(CtClass.voidType) ? "" : "return ";
            String args = "null";
            String name = null;
            if (this.isAdvised) {
                MethodInfo info = this.advisor.getMethodInfo(hash);
                Method originalMethod = info.getUnadvisedMethod();
                name = originalMethod.getName();
            } else {
                name = m.getName();
            }
            if (m.getParameterTypes().length > 0) {
                args = "$args";
            }
            String code = "{       boolean handled = false;    try{       if (currentAdvisor != null) {          org.jboss.aop.MethodInfo mi = currentAdvisor.getMethodInfo(" + hash + "L); " + "          if (mi == null) " + "             throw new java.lang.NoSuchMethodError(\"" + m.getName() + m.getSignature() + "\");" + "          org.jboss.aop.advice.Interceptor[] interceptors = mi.getInterceptors(); " + "          if (interceptors != (Object[])null && interceptors.length > 0) { " + "             handled = true;" + "             org.jboss.aop.proxy.container.ContainerProxyMethodInvocation invocation = new org.jboss.aop.proxy.container.ContainerProxyMethodInvocation(mi, interceptors, this); " + "             invocation.setArguments(" + args + "); " + "             invocation.setTargetObject(delegate); " + "             invocation.setMetaData(metadata);" + "             " + aopReturnStr + " invocation.invokeNext(); " + "          }" + "       }" + "       if (!handled && delegate != null){ " + "          " + returnStr + " delegate." + name + "($$); " + "       }" + "       return " + this.getNullType(m.getReturnType()) + ";" + "    }finally{" + "    }" + "}";
            CtMethod newMethod = CtNewMethod.make((CtClass)m.getReturnType(), (String)m.getName(), (CtClass[])m.getParameterTypes(), (CtClass[])m.getExceptionTypes(), (String)code, (CtClass)this.proxy);
            newMethod.setModifiers(1);
            this.proxy.addMethod(newMethod);
            this.copyAnnotations(m, newMethod);
            this.copySignature(m, newMethod);
        }
    }

    private void createIntroductions(HashSet<Long> addedMethods, HashMap<String, Integer> intfs, HashSet<String> addedInterfaces, Set<String> implementedInterfaces) throws Exception {
        for (String intf : intfs.keySet()) {
            if (addedInterfaces.contains(intf)) {
                throw new Exception("2 mixins are implementing the same interfaces");
            }
            if (implementedInterfaces.contains(intf)) continue;
            CtClass intfClass = this.pool.get(intf);
            CtMethod[] methods = intfClass.getMethods();
            HashSet<Long> mixinMethods = new HashSet<Long>();
            for (int m = 0; m < methods.length; ++m) {
                Long hash;
                if (methods[m].getDeclaringClass().getName().equals("java.lang.Object") || mixinMethods.contains(hash = new Long(JavassistMethodHashing.methodHash(methods[m]))) || addedMethods.contains(hash)) continue;
                mixinMethods.add(hash);
                addedMethods.add(hash);
                String aopReturnStr = methods[m].getReturnType().equals(CtClass.voidType) ? "" : "return ($r)";
                String args = "null";
                if (methods[m].getParameterTypes().length > 0) {
                    args = "$args";
                }
                String code = "{       try{       org.jboss.aop.MethodInfo mi = currentAdvisor.getMethodInfo(" + hash + "L); " + "       if (mi == null) " + "          throw new java.lang.NoSuchMethodError(\"" + methods[m].getName() + methods[m].getSignature() + "\");" + "       org.jboss.aop.advice.Interceptor[] interceptors = mi.getInterceptors();" + "       org.jboss.aop.proxy.container.ContainerProxyMethodInvocation invocation = new org.jboss.aop.proxy.container.ContainerProxyMethodInvocation(mi, interceptors, this); " + "       invocation.setArguments(" + args + "); " + "       invocation.setTargetObject(delegate); " + "       invocation.setMetaData(metadata);" + "       " + aopReturnStr + " invocation.invokeNext(); " + "    }finally{" + "    }" + "}";
                CtMethod newMethod = CtNewMethod.make((CtClass)methods[m].getReturnType(), (String)methods[m].getName(), (CtClass[])methods[m].getParameterTypes(), (CtClass[])methods[m].getExceptionTypes(), (String)code, (CtClass)this.proxy);
                newMethod.setModifiers(1);
                this.proxy.addMethod(newMethod);
                this.copySignature(methods[m], newMethod);
            }
            this.proxy.addInterface(intfClass);
            addedInterfaces.add(intfClass.getName());
        }
    }

    private Set<String> interfacesAsSet() throws NotFoundException {
        HashSet<String> set = new HashSet<String>();
        CtClass[] interfaces = this.proxy.getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            set.add(interfaces[i].getName());
        }
        return set;
    }

    private synchronized String getClassName() {
        String packageName = this.clazz.getPackage().getName();
        packageName = !packageName.startsWith("java.") && !packageName.startsWith("sun.") ? packageName + "." : "org.jboss.aop.generatedproxies.";
        return packageName + PROXY_NAME_PREFIX + counter++;
    }

    private void overrideSpecialMethods(Class<?> clazz, CtClass proxy) throws Exception {
        this.addInstanceAdvisedMethods(clazz, proxy);
    }

    private void addInstanceAdvisedMethods(Class<?> clazz, CtClass proxy) throws Exception {
        CtClass advisedInterface = null;
        CtClass[] interfaces = proxy.getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            if (!interfaces[i].getName().equals(ADVISED)) continue;
            advisedInterface = interfaces[i];
            break;
        }
        if (advisedInterface != null) {
            CtMethod[] methods = advisedInterface.getMethods();
            for (int i = 0; i < methods.length; ++i) {
                if (!methods[i].getDeclaringClass().getName().equals(INSTANCE_ADVISED)) continue;
                String name = methods[i].getName();
                String body = null;
                if (name.equals("_getInstanceAdvisor")) {
                    body = "{ return getInstanceAdvisor(); }";
                } else if (name.equals("_setInstanceAdvisor")) {
                    body = "{ setInstanceAdvisor($1); }";
                }
                if (body == null) continue;
                CtMethod m = CtNewMethod.make((CtClass)methods[i].getReturnType(), (String)methods[i].getName(), (CtClass[])methods[i].getParameterTypes(), (CtClass[])methods[i].getExceptionTypes(), (String)body, (CtClass)proxy);
                m.setModifiers(1);
                Instrumentor.addSyntheticAttribute(m);
                proxy.addMethod(m);
            }
        }
    }

    private void copyAnnotations(CtMethod src, CtMethod dest) throws NotFoundException {
        javassist.bytecode.MethodInfo srcInfo = src.getMethodInfo2();
        javassist.bytecode.MethodInfo destInfo = dest.getMethodInfo2();
        this.copyAnnotations(srcInfo, destInfo, "RuntimeInvisibleAnnotations");
        this.copyAnnotations(srcInfo, destInfo, "RuntimeVisibleAnnotations");
        int numParams = src.getParameterTypes().length;
        this.copyParameterAnnotations(numParams, srcInfo, destInfo, "RuntimeVisibleParameterAnnotations");
        this.copyParameterAnnotations(numParams, srcInfo, destInfo, "RuntimeInvisibleParameterAnnotations");
    }

    private void copyAnnotations(javassist.bytecode.MethodInfo src, javassist.bytecode.MethodInfo dest, String annotationTag) {
        AnnotationsAttribute attribute = (AnnotationsAttribute)src.getAttribute(annotationTag);
        if (attribute != null) {
            dest.addAttribute(attribute.copy(dest.getConstPool(), (Map)EMPTY_HASHMAP));
        }
    }

    private void copyParameterAnnotations(int numParams, javassist.bytecode.MethodInfo src, javassist.bytecode.MethodInfo dest, String paramsTag) {
        ParameterAnnotationsAttribute params = (ParameterAnnotationsAttribute)src.getAttribute(paramsTag);
        if (params != null) {
            dest.addAttribute(params.copy(dest.getConstPool(), (Map)EMPTY_HASHMAP));
            ParameterAnnotationsAttribute srcParams = new ParameterAnnotationsAttribute(src.getConstPool(), paramsTag);
            Annotation[][] emptyParamAnnotations = new Annotation[numParams][];
            for (int i = 0; i < numParams; ++i) {
                emptyParamAnnotations[i] = new Annotation[0];
            }
            srcParams.setAnnotations((Annotation[][])emptyParamAnnotations);
            src.addAttribute((AttributeInfo)srcParams);
        }
    }

    private void copyAnnotations(CtClass src, CtClass dest) throws NotFoundException {
        ClassFile srcFile = src.getClassFile2();
        ClassFile destFile = dest.getClassFile2();
        this.copyAnnotations(srcFile, destFile, "RuntimeInvisibleAnnotations");
        this.copyAnnotations(srcFile, destFile, "RuntimeVisibleAnnotations");
    }

    private void copyAnnotations(ClassFile src, ClassFile dest, String annotationTag) {
        AnnotationsAttribute attribute = (AnnotationsAttribute)src.getAttribute(annotationTag);
        if (attribute != null) {
            dest.addAttribute(attribute.copy(dest.getConstPool(), (Map)EMPTY_HASHMAP));
        }
    }

    private void copySignature(CtMethod src, CtMethod dest) {
        javassist.bytecode.MethodInfo srcInfo = src.getMethodInfo2();
        javassist.bytecode.MethodInfo destInfo = dest.getMethodInfo2();
        SignatureAttribute sig = (SignatureAttribute)srcInfo.getAttribute("Signature");
        if (sig != null) {
            destInfo.addAttribute(sig.copy(destInfo.getConstPool(), (Map)EMPTY_HASHMAP));
        }
    }

    private void copySignature(CtClass src, CtClass dest) {
        ClassFile srcFile = src.getClassFile2();
        ClassFile destFile = dest.getClassFile2();
        SignatureAttribute sig = (SignatureAttribute)srcFile.getAttribute("Signature");
        if (sig != null) {
            destFile.addAttribute(sig.copy(destFile.getConstPool(), (Map)EMPTY_HASHMAP));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MixinInfo {
        String[] interfaces;
        String className;
        String construction;

        MixinInfo(InterfaceIntroduction.Mixin mixin) {
            this.interfaces = mixin.getInterfaces();
            this.className = mixin.getClassName();
            this.construction = mixin.getConstruction();
        }

        MixinInfo(String className, ArrayList<String> interfaces) {
            this.className = className;
            this.interfaces = interfaces.toArray(new String[interfaces.size()]);
        }

        protected String[] getInterfaces() {
            return this.interfaces;
        }

        protected String getClassName() {
            return this.className;
        }

        protected String getConstruction() {
            return this.construction;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class UnmarshalledInRemoteJVMProxyStrategy
    implements ProxyStrategy {
        MarshalledContainerProxy outOfVmProxy;

        UnmarshalledInRemoteJVMProxyStrategy(MarshalledContainerProxy outOfVmProxy) {
            this.outOfVmProxy = outOfVmProxy;
        }

        @Override
        public boolean hasIntroductions() {
            if (this.outOfVmProxy == null) {
                return false;
            }
            return this.outOfVmProxy.getIntroducedInterfaces().length > 0;
        }

        @Override
        public void getMixins(HashMap<String, Integer> intfs, HashMap<String, Integer> mixinInterfaces, ArrayList<MixinInfo> mixes) throws Exception {
            int i;
            HashSet<String> allInterfaces = new HashSet<String>();
            String[] introducedInterfaces = this.outOfVmProxy.getIntroducedInterfaces();
            allInterfaces.addAll(Arrays.asList(introducedInterfaces));
            Set<String> targetInterfaces = this.outOfVmProxy.getTargetInterfaces();
            Object[] mixins = this.outOfVmProxy.getMixins();
            for (i = 0; i < mixins.length; ++i) {
                Class<?> clazz = mixins[i].getClass();
                Class<?>[] ifs = clazz.getInterfaces();
                ArrayList<String> interfaces = new ArrayList<String>(ifs.length);
                for (Class<?> iface : ifs) {
                    String name = iface.getName();
                    if (name.equals(Serializable.class.getName()) || name.equals(Externalizable.class.getName()) || targetInterfaces.contains(name)) continue;
                    interfaces.add(name);
                    allInterfaces.remove(name);
                    mixinInterfaces.put(name, i);
                }
                MixinInfo info = new MixinInfo(clazz.getName(), interfaces);
                mixes.add(info);
            }
            for (String iface : allInterfaces) {
                intfs.put(iface, ++i);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class OriginalProxyStrategy
    implements ProxyStrategy {
        ArrayList<InterfaceIntroduction> mixins;

        OriginalProxyStrategy(ArrayList<InterfaceIntroduction> mixins) {
            this.mixins = mixins;
        }

        @Override
        public boolean hasIntroductions() {
            if (this.mixins == null) {
                return false;
            }
            return this.mixins.size() > 0;
        }

        @Override
        public void getMixins(HashMap<String, Integer> intfs, HashMap<String, Integer> mixinInterfaces, ArrayList<MixinInfo> mixes) throws Exception {
            if (this.mixins != null) {
                int i;
                HashMap<String, Integer> mixinIntfs = new HashMap<String, Integer>();
                for (i = 0; i < this.mixins.size(); ++i) {
                    InterfaceIntroduction introduction = this.mixins.get(i);
                    this.getIntroductionInterfaces(introduction, intfs, mixinIntfs, mixes, i);
                }
                if (mixes.size() > 0) {
                    ContainerProxyFactory.this.defaultCtor.insertAfter("mixins = new Object[" + mixes.size() + "];");
                    for (i = 0; i < mixes.size(); ++i) {
                        MixinInfo mixin = mixes.get(i);
                        String initializer = mixin.getConstruction() == null ? "new " + mixin.getClassName() + "()" : mixin.getConstruction();
                        String code = "mixins[" + i + "] = " + initializer + ";";
                        ContainerProxyFactory.this.defaultCtor.insertAfter(code);
                        setDelegateMethod.insertAfter("{if (org.jboss.aop.proxy.container.Delegate.class.isAssignableFrom(mixins[" + i + "].getClass())) " + "((org.jboss.aop.proxy.container.Delegate)mixins[" + i + "]).setDelegate($1);}");
                    }
                }
            }
        }

        private void getIntroductionInterfaces(InterfaceIntroduction intro, HashMap<String, Integer> intfs, HashMap<String, Integer> mixinInterfaces, ArrayList<MixinInfo> mixes, int idx) {
            for (InterfaceIntroduction.Mixin mixin : intro.getMixins()) {
                mixes.add(new MixinInfo(mixin));
                for (int i = 0; i < mixin.getInterfaces().length; ++i) {
                    if (intfs.containsKey(mixin.getInterfaces()[i])) {
                        intfs.remove(mixin.getInterfaces()[i]);
                    }
                    if (mixinInterfaces.containsKey(mixin.getInterfaces()[i])) {
                        throw new RuntimeException("cannot have an IntroductionInterface that introduces several mixins with the same interfaces " + mixin.getInterfaces()[i]);
                    }
                    mixinInterfaces.put(mixin.getInterfaces()[i], new Integer(idx));
                }
            }
            if (intro.getInterfaces() != null) {
                for (int i = 0; i < intro.getInterfaces().length; ++i) {
                    if (intfs.containsKey(intro.getInterfaces()[i]) || mixinInterfaces.containsKey(intro.getInterfaces()[i])) continue;
                    intfs.put(intro.getInterfaces()[i], new Integer(idx));
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static interface ProxyStrategy {
        public boolean hasIntroductions();

        public void getMixins(HashMap<String, Integer> var1, HashMap<String, Integer> var2, ArrayList<MixinInfo> var3) throws Exception;
    }
}

