/*
 * Decompiled with CFR 0.152.
 */
package xdoclet.modules.doc;

import java.beans.Introspector;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import xdoclet.TemplateSubTask;
import xdoclet.XDocletException;
import xdoclet.modules.doc.AntdocTagsHandler;
import xdoclet.template.TemplateEngine;
import xdoclet.template.TemplateException;
import xjavadoc.XClass;
import xjavadoc.XDoc;
import xjavadoc.XJavaDoc;
import xjavadoc.XMethod;
import xjavadoc.XParameter;

public class AntdocSubTask
extends TemplateSubTask {
    private static String ANTDOC_TEMPLATE_FILE = "resources/antdoc-xdoc.xdt";
    protected final Map classToAntElementMap = new HashMap();
    private final Set alreadyRecursed = new HashSet();

    public String getDestinationFile() {
        return "{0}.xml";
    }

    public void init(XJavaDoc xJavaDoc) throws XDocletException {
        super.init(xJavaDoc);
        if (this.getTemplateURL() == null) {
            this.setTemplateURL(((Object)((Object)this)).getClass().getResource(ANTDOC_TEMPLATE_FILE));
        }
        this.discoverTasks();
        this.discoverDynamicElements();
        this.discoverChildElements();
    }

    public void validateOptions() throws XDocletException {
    }

    protected boolean processInnerClasses() {
        return true;
    }

    protected void generateForClass(XClass clazz) throws XDocletException {
        Element element = (Element)this.classToAntElementMap.get(clazz);
        AntdocTagsHandler antdocTagsHandler = null;
        try {
            antdocTagsHandler = (AntdocTagsHandler)TemplateEngine.getEngineInstance().getTagHandlerFor("Antdoc");
        }
        catch (TemplateException e) {
            throw new XDocletException(e.getMessage());
        }
        antdocTagsHandler.setDocElement(element);
        super.generateForClass(clazz);
    }

    protected boolean matchesGenerationRules(XClass clazz) throws XDocletException {
        boolean result = this.classToAntElementMap.containsKey(clazz);
        return result;
    }

    private Element getElement(XClass clazz) {
        Element element = (Element)this.classToAntElementMap.get(clazz);
        if (element == null) {
            element = new Element(clazz);
            this.classToAntElementMap.put(clazz, element);
        }
        return element;
    }

    private void discoverTasks() {
        Collection classes = this.getXJavaDoc().getSourceClasses();
        for (XClass clazz : classes) {
            if (!clazz.isA("org.apache.tools.ant.Task") && !clazz.isA("org.apache.tools.ant.types.DataType") || clazz.isAbstract() || !clazz.isPublic()) continue;
            this.getElement(clazz);
        }
    }

    private void discoverDynamicElements() {
        Collection classes = this.getXJavaDoc().getSourceClasses();
        for (XClass child : classes) {
            XClass parent;
            XDoc doc = child.getDoc();
            String parentClassName = doc.getTagAttributeValue("ant.element", "parent");
            String elementName = doc.getTagAttributeValue("ant.element", "name");
            if (parentClassName == null || !(parent = this.getXJavaDoc().getXClass(parentClassName)).isA("org.apache.tools.ant.DynamicConfigurator")) continue;
            Element childElement = this.getElement(child);
            Element parentElement = this.getElement(parent);
            SubElement subElement = new SubElement(childElement, null, elementName);
            parentElement.addSubElement(subElement);
        }
    }

    private void discoverChildElements() {
        List<Object> soFar = Arrays.asList(this.classToAntElementMap.values().toArray());
        for (Element element : soFar) {
            this.addChidrenRecursive(element);
        }
    }

    private void addChidrenRecursive(Element element) {
        List methods = element.getXClass().getMethods(true);
        for (XMethod method : methods) {
            this.addChildElementMaybe(element, method);
        }
    }

    private void addChildElementMaybe(Element parentElement, XMethod method) {
        XClass clazz = null;
        String name = null;
        if (method.isPublic()) {
            if (method.getName().startsWith("create") && method.getParameters().size() == 0 && method.getReturnType().getDimension() == 0) {
                clazz = method.getReturnType().getType();
                name = Introspector.decapitalize(method.getName().substring(6));
            } else if (method.getName().startsWith("addConfigured") && method.getParameters().size() == 1 && method.getReturnType().getType().getQualifiedName().equals("void")) {
                clazz = ((XParameter)method.getParameters().iterator().next()).getType();
                name = Introspector.decapitalize(method.getName().substring(13));
            } else if (method.getName().startsWith("add") && method.getParameters().size() == 1 && method.getReturnType().getType().getQualifiedName().equals("void")) {
                clazz = ((XParameter)method.getParameters().iterator().next()).getType();
                name = Introspector.decapitalize(method.getName().substring(3));
            }
        }
        if (clazz != null) {
            Element element = this.getElement(clazz);
            SubElement subElement = new SubElement(element, method, name);
            parentElement.addSubElement(subElement);
            if (!this.alreadyRecursed.contains(clazz)) {
                this.alreadyRecursed.add(clazz);
                this.addChidrenRecursive(element);
            }
        }
    }

    public class SubElement
    implements Comparable {
        private final Element subject;
        private final String name;
        private final XMethod method;

        public SubElement(Element subject, XMethod method, String name) {
            this.subject = subject;
            this.name = name;
            this.method = method;
        }

        public Element getSubject() {
            return this.subject;
        }

        public String getName() {
            return this.name;
        }

        public boolean isDynamicSubElement() {
            return this.method == null;
        }

        public XClass getXClass() {
            return this.getSubject().getXClass();
        }

        public String getDescription() {
            if (!this.isDynamicSubElement()) {
                return this.method.getDoc().getCommentText();
            }
            return this.getXClass().getDoc().getFirstSentence();
        }

        public int compareTo(Object o) {
            SubElement other = (SubElement)o;
            return this.getName().compareTo(other.getName());
        }
    }

    public class Element {
        private final String TASK = "task";
        private final String SUBTASK = "subtask";
        private final SortedSet subElements = new TreeSet();
        private XClass clazz;

        public Element(XClass clazz) {
            this.clazz = clazz;
        }

        public Collection getSubElements() {
            return this.subElements;
        }

        public XClass getXClass() {
            return this.clazz;
        }

        public String getName() {
            String elementName = this.getXClass().getDoc().getTagAttributeValue("ant.element", "name");
            if (elementName == null) {
                String classNameDecapitalized = this.clazz.getName().toLowerCase();
                elementName = classNameDecapitalized.endsWith("subtask") ? classNameDecapitalized.substring(0, classNameDecapitalized.length() - "subtask".length()) : (classNameDecapitalized.endsWith("task") ? classNameDecapitalized.substring(0, classNameDecapitalized.length() - "task".length()) : classNameDecapitalized);
            }
            return elementName;
        }

        public void addSubElement(SubElement subElement) {
            this.subElements.add(subElement);
        }

        public String toString() {
            return this.clazz.getQualifiedName() + "(" + this.clazz.getClass().getName() + ")";
        }

        public boolean equals(Object o) {
            return o == this;
        }

        public int hashCode() {
            return this.toString().hashCode();
        }
    }
}

