/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.virtual.plugins.cache;

import java.util.Map;
import org.jboss.util.LRUCachePolicy;
import org.jboss.virtual.plugins.cache.CachePolicyVFSCache;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LRUVFSCache
extends CachePolicyVFSCache<LRUCachePolicy> {
    private Integer min;
    private Integer max;

    public LRUVFSCache() {
    }

    public LRUVFSCache(Integer min, Integer max) {
        this.min = min;
        this.max = max;
    }

    public LRUVFSCache(Map<Object, Object> properties) {
        super(properties);
    }

    @Override
    protected LRUCachePolicy createCachePolicy() {
        if (this.min == null) {
            this.min = LRUVFSCache.getInteger(this.readInstanceProperties("jboss.vfs.cache.LRUPolicyCaching.min", null, true));
        }
        if (this.max == null) {
            this.max = LRUVFSCache.getInteger(this.readInstanceProperties("jboss.vfs.cache.LRUPolicyCaching.max", null, true));
        }
        if (this.min == null || this.max == null) {
            throw new IllegalArgumentException("Missing min (" + this.min + ") or max (" + this.max + ").");
        }
        this.log.debug((Object)("Creating LRU cache policy, min: " + this.min + ", max: " + this.max));
        return new LRUCachePolicy(this.min.intValue(), this.max.intValue());
    }

    public void setMin(Integer min) {
        this.min = min;
    }

    public void setMax(Integer max) {
        this.max = max;
    }

    public String toString() {
        return "LRUVFSCache{min=" + this.min + ", max=" + this.max + "}";
    }
}

