/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.virtual.plugins.context;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import org.jboss.util.file.ArchiveBrowser;
import org.jboss.virtual.VirtualFile;
import org.jboss.virtual.VirtualFileFilter;
import org.jboss.virtual.VisitorAttributes;
import org.jboss.virtual.plugins.context.jar.JarUtils;
import org.jboss.virtual.plugins.vfs.helpers.FilterVirtualFileVisitor;
import org.jboss.virtual.plugins.vfs.helpers.SuffixesExcludeFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VfsArchiveBrowser
implements Iterator {
    private VirtualFile vf;
    private Iterator<VirtualFile> it;

    public VfsArchiveBrowser(ArchiveBrowser.Filter filter, VirtualFile vf) {
        this.vf = vf;
        List<VirtualFile> classes = this.getResources(new ArchiveBrowserFilter(filter));
        this.it = classes.iterator();
    }

    public List<VirtualFile> getResources(VirtualFileFilter filter) {
        VisitorAttributes va = new VisitorAttributes();
        va.setLeavesOnly(true);
        SuffixesExcludeFilter noJars = new SuffixesExcludeFilter(JarUtils.getSuffixes());
        va.setRecurseFilter(noJars);
        FilterVirtualFileVisitor visitor = new FilterVirtualFileVisitor(filter, va);
        try {
            this.vf.visit(visitor);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return visitor.getMatched();
    }

    @Override
    public boolean hasNext() {
        return this.it.hasNext();
    }

    public Object next() {
        try {
            return this.it.next().openStream();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void remove() {
        this.it.remove();
    }

    private class ArchiveBrowserFilter
    implements VirtualFileFilter {
        private ArchiveBrowser.Filter filter;

        public ArchiveBrowserFilter(ArchiveBrowser.Filter filter) {
            if (filter == null) {
                throw new IllegalArgumentException("Null filter");
            }
            this.filter = filter;
        }

        public boolean accepts(VirtualFile file) {
            return this.filter.accept(file.getName());
        }
    }
}

