/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb.factory;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.jacorb.config.Configurable;
import org.jacorb.config.Configuration;
import org.jacorb.config.ConfigurationException;
import org.jacorb.orb.ORB;
import org.jacorb.orb.factory.DefaultServerSocketFactory;
import org.jacorb.orb.factory.DefaultSocketFactory;
import org.jacorb.orb.factory.PortRangeSocketFactory;
import org.jacorb.orb.factory.ServerSocketFactory;
import org.jacorb.orb.factory.SocketFactory;
import org.jacorb.orb.listener.NullSSLSessionListener;
import org.jacorb.orb.listener.NullTCPConnectionListener;
import org.jacorb.orb.listener.SSLSessionListener;
import org.jacorb.orb.listener.TCPConnectionListener;
import org.jacorb.util.ObjectUtil;
import org.omg.CORBA.INITIALIZE;
import org.slf4j.Logger;

public class SocketFactoryManager
implements Configurable {
    public static final String SOCKET_FACTORY = "jacorb.net.socket_factory";
    public static final String SERVER_SOCKET_FACTORY = "jacorb.net.server_socket_factory";
    public static final String SSL_SOCKET_FACTORY = "jacorb.ssl.socket_factory";
    public static final String SSL_SERVER_SOCKET_FACTORY = "jacorb.ssl.server_socket_factory";
    public static final String TCP_LISTENER = "jacorb.net.tcp_listener";
    public static final String SSL_LISTENER = "jacorb.security.ssl.ssl_listener";
    private TCPConnectionListener tcpListener;
    private SSLSessionListener sslListener;
    private final ORB orb;
    private SocketFactory socketFactory;
    private ServerSocketFactory serverFactory;
    private ServerSocketFactory sslServerSocketFactory;
    private SocketFactory sslSocketFactory;
    private Configuration configuration;
    private Logger logger;
    private String serverSocketFactoryClassName;
    private String socketFactoryClassName;
    private String sslServerSocketFactoryClazz;
    private String sslSocketFactoryClazz;

    public SocketFactoryManager(ORB oRB) {
        this.orb = oRB;
    }

    public void configure(Configuration configuration) throws ConfigurationException {
        this.configuration = configuration;
        this.logger = this.configuration.getLogger("jacorb.orb.factory");
        this.serverSocketFactoryClassName = this.configuration.getAttribute(SERVER_SOCKET_FACTORY, DefaultServerSocketFactory.class.getName());
        this.socketFactoryClassName = this.configuration.getAttribute(SOCKET_FACTORY, "");
        String string = this.configuration.getAttribute("jacorb.net.socket_factory.port.min", "");
        if (this.socketFactoryClassName.length() == 0) {
            if (string.length() > 0) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("no SocketFactory class specified (jacorb.net.socket_factory). assuming PortRangeSocketFactory as property jacorb.net.socket_factory.port.min is specified.");
                }
                this.socketFactoryClassName = PortRangeSocketFactory.class.getName();
            } else {
                this.logger.debug("defaulting to DefaultSocketFactory");
                this.socketFactoryClassName = DefaultSocketFactory.class.getName();
            }
        }
        this.tcpListener = (TCPConnectionListener)this.configuration.getAttributeAsObject(TCP_LISTENER, NullTCPConnectionListener.class.getName());
        this.sslListener = (SSLSessionListener)this.configuration.getAttributeAsObject(SSL_LISTENER, NullSSLSessionListener.class.getName());
        if (this.configuration.getAttributeAsBoolean("jacorb.security.support_ssl", false)) {
            this.sslServerSocketFactoryClazz = this.configuration.getAttribute(SSL_SERVER_SOCKET_FACTORY, "");
            if (this.sslServerSocketFactoryClazz.length() == 0) {
                throw new ConfigurationException("SSL support is on, but the property \"jacorb.ssl.server_socket_factory\" is not set!");
            }
            this.sslSocketFactoryClazz = this.configuration.getAttribute(SSL_SOCKET_FACTORY, "");
            if (this.sslSocketFactoryClazz.length() == 0) {
                throw new ConfigurationException("SSL support is on, but the property \"jacorb.ssl.socket_factory\" is not set");
            }
        }
    }

    public synchronized SocketFactory getSocketFactory() {
        if (this.socketFactory == null) {
            this.socketFactory = this.newSocketFactory(this.socketFactoryClassName);
        }
        return this.socketFactory;
    }

    public synchronized ServerSocketFactory getServerSocketFactory() {
        if (this.serverFactory == null) {
            this.serverFactory = this.newServerSocketFactory(this.serverSocketFactoryClassName);
        }
        return this.serverFactory;
    }

    public synchronized ServerSocketFactory getSSLServerSocketFactory() {
        if (this.sslServerSocketFactory == null) {
            this.sslServerSocketFactory = this.newSSLServerSocketFactory(this.sslServerSocketFactoryClazz);
        }
        return this.sslServerSocketFactory;
    }

    public synchronized SocketFactory getSSLSocketFactory() {
        if (this.sslSocketFactory == null) {
            this.sslSocketFactory = this.newSSLSocketFactory(this.sslSocketFactoryClazz);
        }
        return this.sslSocketFactory;
    }

    public TCPConnectionListener getTCPListener() {
        return this.tcpListener;
    }

    public SSLSessionListener getSSLListener() {
        return this.sslListener;
    }

    private SocketFactory newSSLSocketFactory(String string) {
        SocketFactory socketFactory = (SocketFactory)this.newFactory(string, SocketFactory.class);
        this.logger.debug("created SSLSocketFactory: " + string);
        return socketFactory;
    }

    private ServerSocketFactory newSSLServerSocketFactory(String string) {
        ServerSocketFactory serverSocketFactory = (ServerSocketFactory)this.newFactory(string, ServerSocketFactory.class);
        this.logger.debug("created SSLServerSocketFactory: " + serverSocketFactory);
        return serverSocketFactory;
    }

    private SocketFactory newSocketFactory(String string) {
        SocketFactory socketFactory = (SocketFactory)this.newFactory(string, SocketFactory.class);
        this.logger.debug("created SocketFactory: " + string);
        return socketFactory;
    }

    private ServerSocketFactory newServerSocketFactory(String string) {
        ServerSocketFactory serverSocketFactory = (ServerSocketFactory)this.newFactory(string, ServerSocketFactory.class);
        this.logger.debug("created ServerSocketFactory: " + string);
        return serverSocketFactory;
    }

    private Object newFactory(String string, Class clazz) {
        try {
            Class clazz2 = ObjectUtil.classForName(string);
            if (!clazz.isAssignableFrom(clazz2)) {
                throw new IllegalArgumentException("Custom factory " + string + " does not implement " + clazz.getName());
            }
            Constructor constructor = null;
            try {
                constructor = clazz2.getConstructor(ORB.class);
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
            Object t = constructor == null ? clazz2.newInstance() : constructor.newInstance(this.orb);
            if (t instanceof Configurable) {
                ((Configurable)t).configure(this.configuration);
            }
            return t;
        }
        catch (InvocationTargetException invocationTargetException) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("there was an invocation failure with the socket factory " + string, invocationTargetException.getCause());
            }
            throw new INITIALIZE("there was an invocation failure with the socket factory " + string + ": " + invocationTargetException.getCause());
        }
        catch (Exception exception) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Failed to create custom socket factory " + string, (Throwable)exception);
            }
            throw new INITIALIZE("Failed to create custom socket factory " + string + ": " + exception.toString());
        }
    }
}

