/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logmanager.filters;

import java.util.Iterator;
import java.util.logging.Filter;
import java.util.logging.LogRecord;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AnyFilter
implements Filter {
    private final Filter[] filters;

    public AnyFilter(Filter[] filters) {
        this.filters = filters;
    }

    public AnyFilter(Iterable<Filter> filters) {
        this(filters.iterator());
    }

    public AnyFilter(Iterator<Filter> filters) {
        this.filters = AnyFilter.unroll(filters, 0);
    }

    private static Filter[] unroll(Iterator<Filter> iter, int cnt) {
        if (iter.hasNext()) {
            Filter filter = iter.next();
            if (filter == null) {
                throw new NullPointerException("filter at index " + cnt + " is null");
            }
            Filter[] filters = AnyFilter.unroll(iter, cnt + 1);
            filters[cnt] = filter;
            return filters;
        }
        return new Filter[cnt];
    }

    @Override
    public boolean isLoggable(LogRecord record) {
        for (Filter filter : this.filters) {
            if (!filter.isLoggable(record)) continue;
            return true;
        }
        return false;
    }
}

