/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logmanager.filters;

import java.util.logging.Filter;
import java.util.logging.Level;
import java.util.logging.LogRecord;

public final class LevelRangeFilter
implements Filter {
    private final int min;
    private final int max;
    private final boolean minInclusive;
    private final boolean maxInclusive;

    public LevelRangeFilter(Level min, boolean minInclusive, Level max, boolean maxInclusive) {
        this.minInclusive = minInclusive;
        this.maxInclusive = maxInclusive;
        this.min = min.intValue();
        this.max = max.intValue();
        if (this.max < this.min) {
            throw new IllegalArgumentException("Max level cannot be less than min level");
        }
    }

    public boolean isLoggable(LogRecord record) {
        int iv = record.getLevel().intValue();
        return (this.minInclusive ? this.min <= iv : this.min < iv) && (this.maxInclusive ? iv <= this.max : iv < this.max);
    }
}

