/*
 * Decompiled with CFR 0.152.
 */
package com.meterware.httpunit;

import com.meterware.httpunit.Button;
import com.meterware.httpunit.FormControl;
import com.meterware.httpunit.FormParameter;
import com.meterware.httpunit.FrameSelector;
import com.meterware.httpunit.GetMethodWebRequest;
import com.meterware.httpunit.HTMLElementPredicate;
import com.meterware.httpunit.HTMLElementScriptable;
import com.meterware.httpunit.HttpUnitOptions;
import com.meterware.httpunit.HttpUnitUtils;
import com.meterware.httpunit.IllegalRequestParameterException;
import com.meterware.httpunit.NodeUtils;
import com.meterware.httpunit.ParameterProcessor;
import com.meterware.httpunit.PostMethodWebRequest;
import com.meterware.httpunit.PresetFormParameter;
import com.meterware.httpunit.SubmitButton;
import com.meterware.httpunit.UncheckedParameterHolder;
import com.meterware.httpunit.UnsupportedActionException;
import com.meterware.httpunit.UploadFileSpec;
import com.meterware.httpunit.WebRequest;
import com.meterware.httpunit.WebRequestSource;
import com.meterware.httpunit.WebResponse;
import com.meterware.httpunit.scripting.NamedDelegate;
import com.meterware.httpunit.scripting.ScriptableDelegate;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.UnknownServiceException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class WebForm
extends WebRequestSource {
    private static final FormParameter UNKNOWN_PARAMETER = new FormParameter();
    private Button[] _buttons;
    public static final HTMLElementPredicate MATCH_NAME;
    private static final String[] NO_VALUES;
    private FormControl[] _formControls;
    private SubmitButton[] _submitButtons;
    private String _characterSet;
    private Map _formParameters;
    private Scriptable _scriptable;
    private Vector _buttonVector;
    private FormControl[] _presetParameters;
    private ArrayList _presets;
    private ArrayList _controlList = new ArrayList();

    public WebResponse submit() throws IOException, SAXException {
        return this.submit(this.getDefaultButton());
    }

    public WebResponse submit(SubmitButton button) throws IOException, SAXException {
        return button == null || button.doOnClickEvent() ? this.doFormSubmit(button) : this.getCurrentFrameContents();
    }

    public WebResponse submit(SubmitButton button, int x, int y) throws IOException, SAXException {
        return button.doOnClickEvent() ? this.doFormSubmit(button, x, y) : this.getCurrentFrameContents();
    }

    public WebResponse submitNoButton() throws SAXException, IOException {
        return this.submit(SubmitButton.createFakeSubmitButton(this));
    }

    protected WebResponse submitRequest(String event, WebRequest request) throws IOException, SAXException {
        try {
            return super.submitRequest(event, request);
        }
        catch (UnknownServiceException e) {
            throw new UnsupportedActionException("HttpUnit does not support " + request.getURL().getProtocol() + " URLs in form submissions");
        }
    }

    WebResponse doFormSubmit(SubmitButton button) throws IOException, SAXException {
        return this.submitRequest(this.getAttribute("onsubmit"), this.getRequest(button));
    }

    WebResponse doFormSubmit(SubmitButton button, int x, int y) throws IOException, SAXException {
        return this.submitRequest(this.getAttribute("onsubmit"), this.getRequest(button, x, y));
    }

    public String getMethod() {
        return this.getAttribute("method", "GET");
    }

    public String getAction() {
        return this.getDestination();
    }

    public boolean hasParameterNamed(String soughtName) {
        return this.getFormParameters().containsKey(soughtName);
    }

    public boolean hasParameterStartingWithPrefix(String prefix) {
        String[] names = this.getParameterNames();
        for (int i = 0; i < names.length; ++i) {
            if (!names[i].startsWith(prefix)) continue;
            return true;
        }
        return false;
    }

    public Button[] getButtons() {
        if (this._buttons == null) {
            FormControl[] controls = this.getFormControls();
            ArrayList<FormControl> buttonList = new ArrayList<FormControl>();
            for (int i = 0; i < controls.length; ++i) {
                FormControl control = controls[i];
                if (!(control instanceof Button)) continue;
                buttonList.add(control);
            }
            this._buttons = buttonList.toArray(new Button[buttonList.size()]);
        }
        return this._buttons;
    }

    public Button getButton(HTMLElementPredicate predicate, Object criteria) {
        Button[] buttons = this.getButtons();
        for (int i = 0; i < buttons.length; ++i) {
            if (!predicate.matchesCriteria(buttons[i], criteria)) continue;
            return buttons[i];
        }
        return null;
    }

    public Button getButtonWithID(String buttonID) {
        return this.getButton(Button.WITH_ID, buttonID);
    }

    public SubmitButton[] getSubmitButtons() {
        if (this._submitButtons == null) {
            Vector buttons = this.getSubmitButtonVector();
            this._submitButtons = new SubmitButton[buttons.size()];
            buttons.copyInto(this._submitButtons);
        }
        return this._submitButtons;
    }

    public SubmitButton getSubmitButton(String name) {
        SubmitButton[] buttons = this.getSubmitButtons();
        for (int i = 0; i < buttons.length; ++i) {
            if (!buttons[i].getName().equals(name)) continue;
            return buttons[i];
        }
        return null;
    }

    public SubmitButton getSubmitButton(String name, String value) {
        SubmitButton[] buttons = this.getSubmitButtons();
        for (int i = 0; i < buttons.length; ++i) {
            if (!buttons[i].getName().equals(name) || !buttons[i].getValue().equals(value)) continue;
            return buttons[i];
        }
        return null;
    }

    public SubmitButton getSubmitButtonWithID(String ID) {
        SubmitButton[] buttons = this.getSubmitButtons();
        for (int i = 0; i < buttons.length; ++i) {
            if (!buttons[i].getID().equals(ID)) continue;
            return buttons[i];
        }
        return null;
    }

    public WebRequest getRequest(String submitButtonName, String submitButtonValue) {
        SubmitButton sb = this.getSubmitButton(submitButtonName, submitButtonValue);
        if (sb == null) {
            throw new IllegalSubmitButtonException(submitButtonName, submitButtonValue);
        }
        return this.getRequest(sb);
    }

    public WebRequest getRequest(String submitButtonName) {
        SubmitButton sb = this.getSubmitButton(submitButtonName);
        if (sb == null) {
            throw new IllegalSubmitButtonException(submitButtonName, "");
        }
        return this.getRequest(sb);
    }

    public WebRequest getRequest(SubmitButton button) {
        return this.getRequest(button, 0, 0);
    }

    public WebRequest getRequest(SubmitButton button, int x, int y) {
        if (button == null) {
            button = this.getDefaultButton();
        }
        if (HttpUnitOptions.getParameterValuesValidated()) {
            if (button == null) {
                throw new IllegalUnnamedSubmitButtonException();
            }
            if (!button.isFake()) {
                if (!this.getSubmitButtonVector().contains(button)) {
                    throw new IllegalSubmitButtonException(button);
                }
                if (button.isDisabled()) {
                    throw new DisabledSubmitButtonException(button);
                }
            }
        }
        SubmitButton[] buttons = this.getSubmitButtons();
        for (int i = 0; i < buttons.length; ++i) {
            buttons[i].setPressed(false);
        }
        button.setPressed(true);
        if (this.getMethod().equalsIgnoreCase("post")) {
            return new PostMethodWebRequest(this, button, x, y);
        }
        return new GetMethodWebRequest(this, WebRequest.newParameterHolder(this), button, x, y);
    }

    public WebRequest newUnvalidatedRequest(SubmitButton button) {
        return this.newUnvalidatedRequest(button, 0, 0);
    }

    public WebRequest newUnvalidatedRequest(SubmitButton button, int x, int y) {
        if (button == null) {
            button = this.getDefaultButton();
        }
        SubmitButton[] buttons = this.getSubmitButtons();
        for (int i = 0; i < buttons.length; ++i) {
            buttons[i].setPressed(false);
        }
        button.setPressed(true);
        if (this.getMethod().equalsIgnoreCase("post")) {
            return new PostMethodWebRequest(this, new UncheckedParameterHolder(this), button, x, y);
        }
        return new GetMethodWebRequest(this, new UncheckedParameterHolder(this), button, x, y);
    }

    private WebRequest getScriptedSubmitRequest() {
        SubmitButton[] buttons = this.getSubmitButtons();
        for (int i = 0; i < buttons.length; ++i) {
            buttons[i].setPressed(false);
        }
        if (this.getMethod().equalsIgnoreCase("post")) {
            return new PostMethodWebRequest(this);
        }
        return new GetMethodWebRequest(this);
    }

    public String getParameterValue(String name) {
        String[] values = this.getParameterValues(name);
        return values.length == 0 ? null : values[0];
    }

    public String[] getOptions(String name) {
        return this.getParameter(name).getOptions();
    }

    public String[] getOptionValues(String name) {
        return this.getParameter(name).getOptionValues();
    }

    public boolean isMultiValuedParameter(String name) {
        return this.getParameter(name).isMultiValuedParameter();
    }

    public int getNumTextParameters(String name) {
        return this.getParameter(name).getNumTextParameters();
    }

    public boolean isTextParameter(String name) {
        return this.getParameter(name).isTextParameter();
    }

    void setSubmitAsMime(boolean mimeEncoded) {
        throw new IllegalStateException("May not change the encoding for a validated request created from a form");
    }

    public boolean isSubmitAsMime() {
        return "multipart/form-data".equalsIgnoreCase(this.getAttribute("enctype"));
    }

    public void reset() {
        String event = this.getAttribute("onreset");
        if (event.length() == 0 || this.getScriptableObject().doEvent(event)) {
            this.resetControls();
        }
    }

    private void resetControls() {
        FormControl[] controls = this.getFormControls();
        for (int i = 0; i < controls.length; ++i) {
            controls[i].reset();
        }
    }

    public Scriptable getScriptableObject() {
        if (this._scriptable == null) {
            this._scriptable = new Scriptable();
            this._scriptable.setScriptEngine(this.getBaseResponse().getScriptableObject().getDocument().getScriptEngine(this._scriptable));
        }
        return this._scriptable;
    }

    public String getCharacterSet() {
        return this._characterSet;
    }

    public boolean isFileParameter(String name) {
        return this.getParameter(name).isFileParameter();
    }

    public String[] getParameterNames() {
        ArrayList parameterNames = new ArrayList(this.getFormParameters().keySet());
        return parameterNames.toArray(new String[parameterNames.size()]);
    }

    public String[] getParameterValues(String name) {
        FormParameter parameter = this.getParameter(name);
        return parameter.getValues();
    }

    public boolean isReadOnlyParameter(String name) {
        return this.getParameter(name).isReadOnlyParameter();
    }

    public boolean isDisabledParameter(String name) {
        return this.getParameter(name).isDisabledParameter();
    }

    public boolean isHiddenParameter(String name) {
        return this.getParameter(name).isHiddenParameter();
    }

    public WebRequest getRequest() {
        return this.getRequest((SubmitButton)null);
    }

    public WebRequest newUnvalidatedRequest() {
        return this.newUnvalidatedRequest(null);
    }

    public ScriptableDelegate getScriptableDelegate() {
        return this.getScriptableObject();
    }

    protected void addPresetParameter(String name, String value) {
        FormControl[] formControls = this.getFormControls();
        for (int i = 0; i < formControls.length; ++i) {
            if (!formControls[i].getName().equals(name)) continue;
            return;
        }
        this._presets.add(new PresetFormParameter(this, name, value));
    }

    protected String getEmptyParameterValue() {
        return null;
    }

    void selectImageButtonPosition(SubmitButton imageButton, int x, int y) {
        imageButton.setLocation(x, y);
    }

    void recordPredefinedParameters(ParameterProcessor processor) throws IOException {
        FormControl[] controls = this.getPresetParameters();
        for (int i = 0; i < controls.length; ++i) {
            controls[i].addValues(processor, this.getCharacterSet());
        }
    }

    void recordParameters(ParameterProcessor processor) throws IOException {
        FormControl[] controls = this.getFormControls();
        for (int i = 0; i < controls.length; ++i) {
            controls[i].addValues(processor, this.getCharacterSet());
        }
    }

    public void removeParameter(String name) {
        this.setParameter(name, NO_VALUES);
    }

    public void setParameter(String name, String value) {
        this.setParameter(name, new String[]{value});
    }

    public void setParameter(String name, String[] values) {
        FormParameter parameter = this.getParameter(name);
        if (parameter == UNKNOWN_PARAMETER) {
            throw new NoSuchParameterException(name);
        }
        parameter.setValues(values);
    }

    public void setParameter(String name, UploadFileSpec[] files) {
        FormParameter parameter = this.getParameter(name);
        if (parameter == null) {
            throw new NoSuchParameterException(name);
        }
        parameter.setFiles(files);
    }

    public void setParameter(String name, File file) {
        this.setParameter(name, new UploadFileSpec[]{new UploadFileSpec(file)});
    }

    public void toggleCheckbox(String name) {
        FormParameter parameter = this.getParameter(name);
        if (parameter == null) {
            throw new NoSuchParameterException(name);
        }
        parameter.toggleCheckbox();
    }

    public void toggleCheckbox(String name, String value) {
        FormParameter parameter = this.getParameter(name);
        if (parameter == null) {
            throw new NoSuchParameterException(name);
        }
        parameter.toggleCheckbox(value);
    }

    public void setCheckbox(String name, boolean state) {
        FormParameter parameter = this.getParameter(name);
        if (parameter == null) {
            throw new NoSuchParameterException(name);
        }
        parameter.setValue(state);
    }

    public void setCheckbox(String name, String value, boolean state) {
        FormParameter parameter = this.getParameter(name);
        if (parameter == null) {
            throw new NoSuchParameterException(name);
        }
        parameter.setValue(value, state);
    }

    WebForm(WebResponse response, URL baseURL, Node node, FrameSelector frame, String defaultTarget, String characterSet) {
        super(response, node, baseURL, NodeUtils.getNodeAttribute(node, "action"), frame, defaultTarget);
        this._characterSet = characterSet;
    }

    FormControl getControlWithID(String id) {
        FormControl[] controls = this.getFormControls();
        for (int i = 0; i < controls.length; ++i) {
            FormControl control = controls[i];
            if (!control.getID().equals(id)) continue;
            return control;
        }
        return null;
    }

    private SubmitButton getDefaultButton() {
        if (this.getSubmitButtons().length == 1) {
            return this.getSubmitButtons()[0];
        }
        return this.getSubmitButton("");
    }

    private Vector getSubmitButtonVector() {
        if (this._buttonVector == null) {
            this._buttonVector = new Vector();
            FormControl[] controls = this.getFormControls();
            for (int i = 0; i < controls.length; ++i) {
                FormControl control = controls[i];
                if (!(control instanceof SubmitButton)) continue;
                this._buttonVector.add(control);
            }
            if (this._buttonVector.isEmpty()) {
                this._buttonVector.addElement(new SubmitButton(this));
            }
        }
        return this._buttonVector;
    }

    private FormControl[] getPresetParameters() {
        if (this._presetParameters == null) {
            this._presets = new ArrayList();
            this.loadDestinationParameters();
            this._presetParameters = this._presets.toArray(new FormControl[this._presets.size()]);
        }
        return this._presetParameters;
    }

    FormControl newFormControl(Node child) {
        return FormControl.newFormParameter(this, child);
    }

    void addFormControl(FormControl control) {
        this._controlList.add(control);
        this._formControls = null;
        this._formParameters = null;
    }

    private FormControl[] getFormControls() {
        if (this._formControls == null) {
            this._formControls = this._controlList.toArray(new FormControl[this._controlList.size()]);
        }
        return this._formControls;
    }

    private FormParameter getParameter(String name) {
        FormParameter parameter = (FormParameter)this.getFormParameters().get(name);
        return parameter != null ? parameter : UNKNOWN_PARAMETER;
    }

    private Map getFormParameters() {
        if (this._formParameters == null) {
            this._formParameters = new HashMap();
            this.loadFormParameters(this.getPresetParameters());
            this.loadFormParameters(this.getFormControls());
        }
        return this._formParameters;
    }

    private void loadFormParameters(FormControl[] controls) {
        for (int i = 0; i < controls.length; ++i) {
            if (controls[i].getName().length() == 0) continue;
            FormParameter parameter = (FormParameter)this._formParameters.get(controls[i].getName());
            if (parameter == null) {
                parameter = new FormParameter();
                this._formParameters.put(controls[i].getName(), parameter);
            }
            parameter.addControl(controls[i]);
        }
    }

    static /* synthetic */ FormControl[] access$002(WebForm x0, FormControl[] x1) {
        x0._presetParameters = x1;
        return x1;
    }

    static {
        NO_VALUES = new String[0];
        MATCH_NAME = new HTMLElementPredicate(){

            public boolean matchesCriteria(Object htmlElement, Object criteria) {
                return HttpUnitUtils.matches(((WebForm)htmlElement).getName(), (String)criteria);
            }
        };
    }

    class DisabledSubmitButtonException
    extends IllegalStateException {
        private String _name;
        private String _value;

        DisabledSubmitButtonException(SubmitButton button) {
            this._name = button.getName();
            this._value = button.getValue();
        }

        public String getMessage() {
            return "The specified button (name='" + this._name + "' value='" + this._value + "' is disabled and may not be used to submit this form.";
        }
    }

    class IllegalSubmitButtonException
    extends IllegalRequestParameterException {
        private String _name;
        private String _value;

        IllegalSubmitButtonException(SubmitButton button) {
            this._name = button.getName();
            this._value = button.getValue();
        }

        IllegalSubmitButtonException(String name, String value) {
            this._name = name;
            this._value = value;
        }

        public String getMessage() {
            return "Specified submit button (name=\"" + this._name + "\" value=\"" + this._value + "\") not part of this form.";
        }
    }

    class IllegalUnnamedSubmitButtonException
    extends IllegalRequestParameterException {
        IllegalUnnamedSubmitButtonException() {
        }

        public String getMessage() {
            return "This form has more than one submit button, none unnamed. You must specify the button to be used.";
        }
    }

    class NoSuchParameterException
    extends IllegalRequestParameterException {
        private String _parameterName;

        NoSuchParameterException(String parameterName) {
            this._parameterName = parameterName;
        }

        public String getMessage() {
            return "No parameter named '" + this._parameterName + "' is defined in the form";
        }
    }

    public class Scriptable
    extends HTMLElementScriptable
    implements NamedDelegate {
        public String getAction() {
            return WebForm.this.getAction();
        }

        public void setAction(String newAction) {
            WebForm.this.setDestination(newAction);
            WebForm.access$002(WebForm.this, null);
        }

        public void submit() throws IOException, SAXException {
            WebForm.this.submitRequest(WebForm.this.getScriptedSubmitRequest());
        }

        public void reset() throws IOException, SAXException {
            WebForm.this.resetControls();
        }

        public String getName() {
            return WebForm.this.getID().length() != 0 ? WebForm.this.getID() : WebForm.this.getName();
        }

        public Object get(String propertyName) {
            if (propertyName.equals("target")) {
                return WebForm.this.getTarget();
            }
            if (propertyName.equals("length")) {
                return new Integer(WebForm.this.getFormControls().length);
            }
            FormParameter parameter = WebForm.this.getParameter(propertyName);
            if (parameter != UNKNOWN_PARAMETER) {
                return parameter.getScriptableObject();
            }
            FormControl control = WebForm.this.getControlWithID(propertyName);
            return control == null ? super.get(propertyName) : control.getScriptableDelegate();
        }

        public void set(String propertyName, Object value) {
            if (propertyName.equals("target")) {
                WebForm.this.setTargetAttribute(value.toString());
            } else if (value instanceof String) {
                this.setParameterValue(propertyName, (String)value);
            } else if (value instanceof Number) {
                this.setParameterValue(propertyName, this.roundedValue((Number)value));
            } else {
                super.set(propertyName, value);
            }
        }

        private String roundedValue(Number number) {
            String rawNumber = number.toString();
            if (rawNumber.indexOf(46) == -1) {
                return rawNumber;
            }
            int index = rawNumber.length();
            while (rawNumber.charAt(index - 1) == '0') {
                --index;
            }
            if (rawNumber.charAt(index - 1) == '.') {
                --index;
            }
            return rawNumber.substring(0, index);
        }

        public void setParameterValue(String name, String value) {
            Object scriptableObject = WebForm.this.getParameter(name).getScriptableObject();
            if (scriptableObject instanceof ScriptableDelegate) {
                ((ScriptableDelegate)scriptableObject).set("value", value);
            } else if (scriptableObject instanceof ScriptableDelegate[]) {
                ((ScriptableDelegate[])scriptableObject)[0].set("value", value);
            }
        }

        public ScriptableDelegate[] getElementDelegates() {
            FormControl[] controls = WebForm.this.getFormControls();
            ScriptableDelegate[] result = new ScriptableDelegate[controls.length];
            for (int i = 0; i < result.length; ++i) {
                result[i] = controls[i].getScriptableDelegate();
            }
            return result;
        }

        public ScriptableDelegate[] getElementsByTagName(String name) throws SAXException {
            return this.getDelegates(WebForm.this.getHTMLPage().getElementsByTagName(WebForm.this.getNode(), name));
        }

        Scriptable() {
            super(WebForm.this);
        }
    }
}

