/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.internal.jts.interposition.resources.restricted;

import com.arjuna.ats.arjuna.common.Uid;
import com.arjuna.ats.internal.jts.interposition.ServerFactory;
import com.arjuna.ats.internal.jts.interposition.resources.arjuna.InterposedHierarchy;
import com.arjuna.ats.internal.jts.interposition.resources.arjuna.Interposition;
import com.arjuna.ats.internal.jts.orbspecific.ControlImple;
import com.arjuna.ats.internal.jts.orbspecific.interposition.ServerControl;
import com.arjuna.ats.internal.jts.orbspecific.interposition.resources.restricted.ServerRestrictedNestedAction;
import com.arjuna.ats.internal.jts.orbspecific.interposition.resources.restricted.ServerRestrictedTopLevelAction;
import com.arjuna.ats.jts.utils.Utility;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.TRANSACTION_ROLLEDBACK;
import org.omg.CosTransactions.Coordinator;
import org.omg.CosTransactions.PropagationContext;
import org.omg.CosTransactions.Terminator;
import org.omg.CosTransactions.TransIdentity;

public class RestrictedInterposition
extends Interposition {
    private static RestrictedInterposition __list = new RestrictedInterposition();

    public static ControlImple create(PropagationContext context) throws SystemException {
        if (__list != null) {
            return __list.setupHierarchy(context);
        }
        return null;
    }

    public synchronized ControlImple setupHierarchy(PropagationContext context) throws SystemException {
        ControlImple controlPtr = null;
        Uid theUid = null;
        InterposedHierarchy proxyAction = null;
        theUid = context.parents.length == 0 ? Utility.otidToUid(context.current.otid) : Utility.otidToUid(context.parents[context.parents.length - 1].otid);
        proxyAction = super.present(theUid);
        controlPtr = proxyAction == null ? this.createHierarchy(context, theUid) : this.checkHierarchy(proxyAction, context);
        return controlPtr;
    }

    protected synchronized ControlImple createHierarchy(PropagationContext ctx, Uid tlUid) throws SystemException {
        int depth = ctx.parents.length;
        ServerRestrictedTopLevelAction tlAction = null;
        Coordinator tmpCoord = null;
        Terminator tmpTerm = null;
        if (depth == 0) {
            tmpCoord = ctx.current.coord;
            tmpTerm = ctx.current.term;
        } else {
            tmpCoord = ctx.parents[depth - 1].coord;
            tmpTerm = ctx.parents[depth - 1].term;
        }
        ServerControl control = ServerFactory.create_transaction(tlUid, null, null, tmpCoord, tmpTerm, ctx.timeout);
        tlAction = new ServerRestrictedTopLevelAction(control);
        if (!tlAction.valid()) {
            try {
                tlAction.rollback();
                tlAction = null;
            }
            catch (Exception e) {
                // empty catch block
            }
            throw new TRANSACTION_ROLLEDBACK();
        }
        InterposedHierarchy newElement = new InterposedHierarchy(tlAction);
        this._head.add(newElement);
        if (depth > 0) {
            ServerRestrictedNestedAction nestedAction = null;
            for (int i = depth - 2; i >= 0; --i) {
                tmpCoord = ctx.parents[i].coord;
                tmpTerm = ctx.parents[i].term;
                control = ServerFactory.create_subtransaction(Utility.otidToUid(ctx.parents[i].otid), tmpCoord, tmpTerm, control);
                nestedAction = new ServerRestrictedNestedAction(control);
                if (!nestedAction.valid()) {
                    try {
                        nestedAction.rollback();
                        nestedAction = null;
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    throw new TRANSACTION_ROLLEDBACK();
                }
                tlAction.addChild(nestedAction);
            }
            tmpCoord = ctx.current.coord;
            tmpTerm = ctx.current.term;
            control = ServerFactory.create_subtransaction(Utility.otidToUid(ctx.current.otid), tmpCoord, tmpTerm, control);
            nestedAction = new ServerRestrictedNestedAction(control);
            if (!nestedAction.valid()) {
                try {
                    nestedAction.rollback();
                    nestedAction = null;
                }
                catch (Exception e) {
                    // empty catch block
                }
                throw new TRANSACTION_ROLLEDBACK();
            }
            tlAction.addChild(nestedAction);
        }
        return control;
    }

    protected synchronized ControlImple checkHierarchy(InterposedHierarchy hier, PropagationContext context) throws SystemException {
        ServerRestrictedTopLevelAction tlAction = (ServerRestrictedTopLevelAction)hier.action();
        ServerControl control = tlAction.control();
        int depth = context.parents.length;
        int differenceIndex = -1;
        ServerRestrictedNestedAction nestedAction = tlAction.child();
        if (depth == 0) {
            if (nestedAction != null) {
                tlAction.abortChild(nestedAction);
                nestedAction = null;
                control = tlAction.deepestControl();
            }
        } else {
            for (int i = depth - 2; i >= 0 && nestedAction != null; --i) {
                if (nestedAction.get_uid().equals(Utility.otidToUid(context.parents[i].otid))) {
                    if ((nestedAction = nestedAction.child()) != null || i <= 0) continue;
                    differenceIndex = i - 1;
                    control = tlAction.deepestControl();
                    continue;
                }
                differenceIndex = i;
                tlAction.abortChild(nestedAction);
                nestedAction = null;
                control = tlAction.deepestControl();
                break;
            }
            if (differenceIndex != -1) {
                for (int j = differenceIndex; j >= 0; --j) {
                    Coordinator tmpCoord = context.parents[j].coord;
                    Terminator tmpTerm = context.parents[j].term;
                    control = ServerFactory.create_subtransaction(Utility.otidToUid(context.parents[j].otid), tmpCoord, tmpTerm, control);
                    nestedAction = new ServerRestrictedNestedAction(control);
                    if (!nestedAction.valid()) {
                        try {
                            nestedAction.rollback();
                            nestedAction = null;
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                        throw new TRANSACTION_ROLLEDBACK();
                    }
                    tlAction.addChild(nestedAction);
                }
                nestedAction = null;
            } else if (nestedAction != null && (nestedAction = nestedAction.child()) != null) {
                tlAction.abortChild(nestedAction);
                nestedAction = null;
                control = tlAction.deepestControl();
            }
        }
        boolean newCurrent = false;
        Uid sentCurrent = Utility.otidToUid(context.current.otid);
        if (differenceIndex == -1) {
            Uid currentUid = null;
            if (nestedAction == null) {
                nestedAction = tlAction.child();
                if (nestedAction != null) {
                    while (nestedAction.child() != null) {
                        nestedAction = nestedAction.child();
                    }
                    currentUid = nestedAction.get_uid();
                } else {
                    currentUid = tlAction.get_uid();
                }
            } else {
                currentUid = nestedAction.get_uid();
            }
            if (currentUid.notEquals(sentCurrent)) {
                newCurrent = true;
            }
        } else {
            newCurrent = true;
        }
        if (newCurrent) {
            if (depth == 1) {
                nestedAction = tlAction.child();
                if (nestedAction != null) {
                    tlAction.abortChild(nestedAction);
                    nestedAction = null;
                }
                control = tlAction.control();
            } else {
                control = tlAction.deepestControl();
            }
            TransIdentity currentID = context.current;
            control = ServerFactory.create_subtransaction(sentCurrent, currentID.coord, currentID.term, control);
            nestedAction = new ServerRestrictedNestedAction(control);
            if (!nestedAction.valid()) {
                try {
                    nestedAction.rollback();
                    nestedAction = null;
                }
                catch (Exception e) {
                    // empty catch block
                }
                throw new TRANSACTION_ROLLEDBACK();
            }
            tlAction.addChild(nestedAction);
            nestedAction = null;
        }
        return control;
    }
}

