/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.transport.http.client;

import com.sun.istack.NotNull;
import com.sun.istack.Nullable;
import com.sun.xml.ws.api.EndpointAddress;
import com.sun.xml.ws.api.message.Packet;
import com.sun.xml.ws.client.ClientTransportException;
import com.sun.xml.ws.resources.ClientMessages;
import com.sun.xml.ws.transport.Headers;
import com.sun.xml.ws.transport.http.client.CookieJar;
import com.sun.xml.ws.util.RuntimeVersion;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.xml.bind.DatatypeConverter;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.ws.WebServiceException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class HttpClientTransport {
    private static String LAST_ENDPOINT;
    private static boolean redirect;
    private static final int START_REDIRECT_COUNT = 3;
    private static int redirectCount;
    int statusCode;
    private final Map<String, List<String>> reqHeaders;
    private Map<String, List<String>> respHeaders = null;
    private OutputStream outputStream;
    private boolean https;
    private HttpURLConnection httpConnection = null;
    private EndpointAddress endpoint = null;
    private Packet context = null;
    private CookieJar cookieJar = null;
    private boolean isFailure = false;
    private final Integer chunkSize;

    public HttpClientTransport(@NotNull Packet packet, @NotNull Map<String, List<String>> reqHeaders) {
        this.endpoint = packet.endpointAddress;
        this.context = packet;
        this.reqHeaders = reqHeaders;
        this.chunkSize = (Integer)this.context.invocationProperties.get("com.sun.xml.ws.transport.http.client.streaming.chunk.size");
    }

    public OutputStream getOutput() {
        try {
            this.createHttpConnection();
            this.sendCookieAsNeeded();
            if (this.requiresOutputStream()) {
                List<String> contentEncoding;
                this.outputStream = this.httpConnection.getOutputStream();
                if (this.chunkSize != null) {
                    this.outputStream = new WSChunkedOuputStream(this.outputStream, this.chunkSize);
                }
                if ((contentEncoding = this.reqHeaders.get("Content-Encoding")) != null && contentEncoding.get(0).contains("gzip")) {
                    this.outputStream = new GZIPOutputStream(this.outputStream);
                }
            }
            this.httpConnection.connect();
        }
        catch (Exception ex) {
            throw new ClientTransportException(ClientMessages.localizableHTTP_CLIENT_FAILED(ex), ex);
        }
        return this.outputStream;
    }

    public void closeOutput() throws IOException {
        if (this.outputStream != null) {
            this.outputStream.close();
            this.outputStream = null;
        }
    }

    public InputStream getInput() {
        InputStream in;
        try {
            in = this.readResponse();
            String contentEncoding = this.httpConnection.getContentEncoding();
            if (contentEncoding != null && contentEncoding.contains("gzip")) {
                in = new GZIPInputStream(in);
            }
        }
        catch (IOException e) {
            if (this.statusCode == 204 || this.isFailure && this.statusCode != 500) {
                try {
                    throw new ClientTransportException(ClientMessages.localizableHTTP_STATUS_CODE(this.statusCode, this.httpConnection.getResponseMessage()));
                }
                catch (IOException ex) {
                    throw new ClientTransportException(ClientMessages.localizableHTTP_STATUS_CODE(this.statusCode, ex));
                }
            }
            throw new ClientTransportException(ClientMessages.localizableHTTP_CLIENT_FAILED(e), e);
        }
        return in;
    }

    public Map<String, List<String>> getHeaders() {
        if (this.respHeaders != null) {
            return this.respHeaders;
        }
        this.respHeaders = new Headers();
        this.respHeaders.putAll(this.httpConnection.getHeaderFields());
        return this.respHeaders;
    }

    protected InputStream readResponse() throws IOException {
        return this.isFailure ? this.httpConnection.getErrorStream() : this.httpConnection.getInputStream();
    }

    void checkResponseCode() {
        try {
            this.statusCode = this.httpConnection.getResponseCode();
            if (this.httpConnection.getResponseCode() == 500) {
                this.isFailure = true;
            } else {
                if (this.httpConnection.getResponseCode() == 401) {
                    throw new ClientTransportException(ClientMessages.localizableHTTP_CLIENT_UNAUTHORIZED(this.httpConnection.getResponseMessage()));
                }
                if (this.httpConnection.getResponseCode() == 404) {
                    throw new ClientTransportException(ClientMessages.localizableHTTP_NOT_FOUND(this.httpConnection.getResponseMessage()));
                }
                if (this.statusCode == 302 || this.statusCode == 301) {
                    this.isFailure = true;
                    if (!redirect || redirectCount <= 0) {
                        throw new ClientTransportException(ClientMessages.localizableHTTP_STATUS_CODE(this.statusCode, this.getStatusMessage()));
                    }
                } else {
                    if (this.statusCode < 200 || this.statusCode >= 303 && this.statusCode < 500) {
                        throw new ClientTransportException(ClientMessages.localizableHTTP_STATUS_CODE(this.statusCode, this.getStatusMessage()));
                    }
                    if (this.statusCode >= 500) {
                        this.isFailure = true;
                    }
                }
            }
        }
        catch (IOException e) {
            throw new WebServiceException((Throwable)e);
        }
        this.saveCookieAsNeeded();
    }

    String getStatusMessage() throws IOException {
        String location;
        int statusCode = this.httpConnection.getResponseCode();
        String message = this.httpConnection.getResponseMessage();
        if ((statusCode == 201 || statusCode >= 300 && statusCode != 304 && statusCode < 400) && (location = this.httpConnection.getHeaderField("Location")) != null) {
            message = message + " - Location: " + location;
        }
        return message;
    }

    protected void sendCookieAsNeeded() {
        Boolean shouldMaintainSessionProperty = (Boolean)this.context.invocationProperties.get("javax.xml.ws.session.maintain");
        if (shouldMaintainSessionProperty != null && shouldMaintainSessionProperty.booleanValue()) {
            this.cookieJar = (CookieJar)this.context.invocationProperties.get("com.sun.xml.ws.client.http.CookieJar");
            if (this.cookieJar == null) {
                this.cookieJar = new CookieJar();
                this.context.proxy.getRequestContext().put("com.sun.xml.ws.client.http.CookieJar", this.cookieJar);
            }
            this.cookieJar.applyRelevantCookies(this.httpConnection);
        }
    }

    private void saveCookieAsNeeded() {
        if (this.cookieJar != null) {
            this.cookieJar.recordAnyCookies(this.httpConnection);
        }
    }

    private void createHttpConnection() throws IOException {
        Integer chunkSize;
        Integer connectTimeout;
        String redirectProperty = (String)this.context.invocationProperties.get("com.sun.xml.ws.client.http.RedirectRequestProperty");
        if (redirectProperty != null && redirectProperty.equalsIgnoreCase("false")) {
            redirect = false;
        }
        this.checkEndpoints();
        this.httpConnection = (HttpURLConnection)this.endpoint.openConnection();
        if (this.httpConnection instanceof HttpsURLConnection) {
            SSLSocketFactory sslSocketFactory;
            HostnameVerifier verifier;
            this.https = true;
            boolean verification = false;
            String verificationProperty = (String)this.context.invocationProperties.get("com.sun.xml.ws.client.http.HostnameVerificationProperty");
            if (verificationProperty != null && verificationProperty.equalsIgnoreCase("true")) {
                verification = true;
            }
            if (!verification) {
                ((HttpsURLConnection)this.httpConnection).setHostnameVerifier(new HttpClientVerifier());
            }
            if ((verifier = (HostnameVerifier)this.context.invocationProperties.get("com.sun.xml.ws.transport.https.client.hostname.verifier")) != null) {
                ((HttpsURLConnection)this.httpConnection).setHostnameVerifier(verifier);
            }
            if ((sslSocketFactory = (SSLSocketFactory)this.context.invocationProperties.get("com.sun.xml.ws.transport.https.client.SSLSocketFactory")) != null) {
                ((HttpsURLConnection)this.httpConnection).setSSLSocketFactory(sslSocketFactory);
            }
        }
        this.writeBasicAuthAsNeeded(this.context, this.reqHeaders);
        this.httpConnection.setAllowUserInteraction(true);
        this.httpConnection.setDoOutput(true);
        this.httpConnection.setDoInput(true);
        String requestMethod = (String)this.context.invocationProperties.get("javax.xml.ws.http.request.method");
        String method = requestMethod != null ? requestMethod : "POST";
        this.httpConnection.setRequestMethod(method);
        Integer reqTimeout = (Integer)this.context.invocationProperties.get("com.sun.xml.ws.request.timeout");
        if (reqTimeout != null) {
            this.httpConnection.setReadTimeout(reqTimeout);
        }
        if ((connectTimeout = (Integer)this.context.invocationProperties.get("com.sun.xml.ws.connect.timeout")) != null) {
            this.httpConnection.setConnectTimeout(connectTimeout);
        }
        if ((chunkSize = (Integer)this.context.invocationProperties.get("com.sun.xml.ws.transport.http.client.streaming.chunk.size")) != null) {
            this.httpConnection.setChunkedStreamingMode(chunkSize);
        }
        for (Map.Entry<String, List<String>> entry : this.reqHeaders.entrySet()) {
            this.httpConnection.addRequestProperty(entry.getKey(), entry.getValue().get(0));
        }
        this.httpConnection.addRequestProperty("User-Agent", RuntimeVersion.VERSION.toString());
    }

    public boolean isSecure() {
        return this.https;
    }

    private boolean checkForRedirect(int statusCode) {
        return (statusCode == 301 || statusCode == 302) && redirect && redirectCount-- > 0;
    }

    private void checkEndpoints() {
        if (!LAST_ENDPOINT.equalsIgnoreCase(this.endpoint.toString())) {
            redirectCount = 3;
            LAST_ENDPOINT = this.endpoint.toString();
        }
    }

    private void writeBasicAuthAsNeeded(Packet context, Map<String, List<String>> reqHeaders) {
        String pw;
        String user = (String)context.invocationProperties.get("javax.xml.ws.security.auth.username");
        if (user != null && (pw = (String)context.invocationProperties.get("javax.xml.ws.security.auth.password")) != null) {
            StringBuffer buf = new StringBuffer(user);
            buf.append(":");
            buf.append(pw);
            String creds = DatatypeConverter.printBase64Binary((byte[])buf.toString().getBytes());
            reqHeaders.put("Authorization", Collections.singletonList("Basic " + creds));
        }
    }

    private boolean requiresOutputStream() {
        return !this.httpConnection.getRequestMethod().equalsIgnoreCase("GET") && !this.httpConnection.getRequestMethod().equalsIgnoreCase("HEAD") && !this.httpConnection.getRequestMethod().equalsIgnoreCase("DELETE");
    }

    @Nullable
    public String getContentType() {
        return this.httpConnection.getContentType();
    }

    static {
        try {
            JAXBContext.newInstance((Class[])new Class[0]).createUnmarshaller();
        }
        catch (JAXBException jAXBException) {
            // empty catch block
        }
        LAST_ENDPOINT = "";
        redirect = true;
        redirectCount = 3;
    }

    private static final class WSChunkedOuputStream
    extends OutputStream {
        final OutputStream actual;
        final int chunkSize;

        WSChunkedOuputStream(OutputStream actual, int chunkSize) {
            this.actual = actual;
            this.chunkSize = chunkSize;
        }

        public void write(byte[] b, int off, int len) throws IOException {
            int chunk;
            for (int sent = 0; sent < len; sent += chunk) {
                chunk = len - sent;
                if (chunk > this.chunkSize) {
                    chunk = this.chunkSize;
                }
                this.actual.write(b, off, chunk);
                off += chunk;
            }
        }

        public void write(byte[] b) throws IOException {
            this.write(b, 0, b.length);
        }

        public void write(int b) throws IOException {
            this.actual.write(b);
        }

        public void flush() throws IOException {
            this.actual.flush();
        }

        public void close() throws IOException {
            this.actual.close();
        }
    }

    private static class HttpClientVerifier
    implements HostnameVerifier {
        private HttpClientVerifier() {
        }

        public boolean verify(String s, SSLSession sslSession) {
            return true;
        }
    }
}

