/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.scheduling.quartz;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.quartz.Calendar;
import org.quartz.JobDetail;
import org.quartz.JobListener;
import org.quartz.ObjectAlreadyExistsException;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SchedulerListener;
import org.quartz.Trigger;
import org.quartz.TriggerListener;
import org.quartz.xml.JobSchedulingDataProcessor;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.core.io.ResourceLoader;
import org.springframework.scheduling.quartz.JobDetailAwareTrigger;
import org.springframework.scheduling.quartz.ResourceLoaderClassLoadHelper;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionException;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.DefaultTransactionDefinition;

public abstract class SchedulerAccessor
implements ResourceLoaderAware {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private boolean overwriteExistingJobs = false;
    private String[] jobSchedulingDataLocations;
    private List jobDetails;
    private Map calendars;
    private List triggers;
    private SchedulerListener[] schedulerListeners;
    private JobListener[] globalJobListeners;
    private JobListener[] jobListeners;
    private TriggerListener[] globalTriggerListeners;
    private TriggerListener[] triggerListeners;
    private PlatformTransactionManager transactionManager;
    protected ResourceLoader resourceLoader;

    public void setOverwriteExistingJobs(boolean overwriteExistingJobs) {
        this.overwriteExistingJobs = overwriteExistingJobs;
    }

    public void setJobSchedulingDataLocation(String jobSchedulingDataLocation) {
        this.jobSchedulingDataLocations = new String[]{jobSchedulingDataLocation};
    }

    public void setJobSchedulingDataLocations(String[] jobSchedulingDataLocations) {
        this.jobSchedulingDataLocations = jobSchedulingDataLocations;
    }

    public void setJobDetails(JobDetail[] jobDetails) {
        this.jobDetails = new ArrayList<JobDetail>(Arrays.asList(jobDetails));
    }

    public void setCalendars(Map calendars) {
        this.calendars = calendars;
    }

    public void setTriggers(Trigger[] triggers) {
        this.triggers = Arrays.asList(triggers);
    }

    public void setSchedulerListeners(SchedulerListener[] schedulerListeners) {
        this.schedulerListeners = schedulerListeners;
    }

    public void setGlobalJobListeners(JobListener[] globalJobListeners) {
        this.globalJobListeners = globalJobListeners;
    }

    public void setJobListeners(JobListener[] jobListeners) {
        this.jobListeners = jobListeners;
    }

    public void setGlobalTriggerListeners(TriggerListener[] globalTriggerListeners) {
        this.globalTriggerListeners = globalTriggerListeners;
    }

    public void setTriggerListeners(TriggerListener[] triggerListeners) {
        this.triggerListeners = triggerListeners;
    }

    public void setTransactionManager(PlatformTransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    protected void registerJobsAndTriggers() throws SchedulerException {
        TransactionStatus transactionStatus = null;
        if (this.transactionManager != null) {
            transactionStatus = this.transactionManager.getTransaction((TransactionDefinition)new DefaultTransactionDefinition());
        }
        try {
            Iterator<Object> it;
            if (this.jobSchedulingDataLocations != null) {
                ResourceLoaderClassLoadHelper clh = new ResourceLoaderClassLoadHelper(this.resourceLoader);
                clh.initialize();
                JobSchedulingDataProcessor dataProcessor = new JobSchedulingDataProcessor(true, true, true);
                for (int i = 0; i < this.jobSchedulingDataLocations.length; ++i) {
                    dataProcessor.processFileAndScheduleJobs(this.jobSchedulingDataLocations[i], this.getScheduler(), this.overwriteExistingJobs);
                }
            }
            if (this.jobDetails != null) {
                it = this.jobDetails.iterator();
                while (it.hasNext()) {
                    JobDetail jobDetail = (JobDetail)it.next();
                    this.addJobToScheduler(jobDetail);
                }
            } else {
                this.jobDetails = new LinkedList();
            }
            if (this.calendars != null) {
                it = this.calendars.keySet().iterator();
                while (it.hasNext()) {
                    String calendarName = (String)it.next();
                    Calendar calendar = (Calendar)this.calendars.get(calendarName);
                    this.getScheduler().addCalendar(calendarName, calendar, true, true);
                }
            }
            if (this.triggers != null) {
                it = this.triggers.iterator();
                while (it.hasNext()) {
                    Trigger trigger = (Trigger)it.next();
                    this.addTriggerToScheduler(trigger);
                }
            }
        }
        catch (Throwable ex) {
            if (transactionStatus != null) {
                try {
                    this.transactionManager.rollback(transactionStatus);
                }
                catch (TransactionException tex) {
                    this.logger.error((Object)"Job registration exception overridden by rollback exception", ex);
                    throw tex;
                }
            }
            if (ex instanceof SchedulerException) {
                throw (SchedulerException)ex;
            }
            if (ex instanceof Exception) {
                throw new SchedulerException("Registration of jobs and triggers failed: " + ex.getMessage(), (Throwable)((Exception)ex));
            }
            throw new SchedulerException("Registration of jobs and triggers failed: " + ex.getMessage());
        }
        if (transactionStatus != null) {
            this.transactionManager.commit(transactionStatus);
        }
    }

    private boolean addJobToScheduler(JobDetail jobDetail) throws SchedulerException {
        if (this.overwriteExistingJobs || this.getScheduler().getJobDetail(jobDetail.getName(), jobDetail.getGroup()) == null) {
            this.getScheduler().addJob(jobDetail, true);
            return true;
        }
        return false;
    }

    private boolean addTriggerToScheduler(Trigger trigger) throws SchedulerException {
        boolean triggerExists;
        boolean bl = triggerExists = this.getScheduler().getTrigger(trigger.getName(), trigger.getGroup()) != null;
        if (!triggerExists || this.overwriteExistingJobs) {
            JobDetail jobDetail;
            if (trigger instanceof JobDetailAwareTrigger && !this.jobDetails.contains(jobDetail = ((JobDetailAwareTrigger)trigger).getJobDetail()) && this.addJobToScheduler(jobDetail)) {
                this.jobDetails.add(jobDetail);
            }
            if (!triggerExists) {
                try {
                    this.getScheduler().scheduleJob(trigger);
                }
                catch (ObjectAlreadyExistsException ex) {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)("Unexpectedly found existing trigger, assumably due to cluster race condition: " + ex.getMessage() + " - can safely be ignored"));
                    }
                    if (this.overwriteExistingJobs) {
                        this.getScheduler().rescheduleJob(trigger.getName(), trigger.getGroup(), trigger);
                    }
                }
            } else {
                this.getScheduler().rescheduleJob(trigger.getName(), trigger.getGroup(), trigger);
            }
            return true;
        }
        return false;
    }

    protected void registerListeners() throws SchedulerException {
        int i;
        if (this.schedulerListeners != null) {
            for (i = 0; i < this.schedulerListeners.length; ++i) {
                this.getScheduler().addSchedulerListener(this.schedulerListeners[i]);
            }
        }
        if (this.globalJobListeners != null) {
            for (i = 0; i < this.globalJobListeners.length; ++i) {
                this.getScheduler().addGlobalJobListener(this.globalJobListeners[i]);
            }
        }
        if (this.jobListeners != null) {
            for (i = 0; i < this.jobListeners.length; ++i) {
                this.getScheduler().addJobListener(this.jobListeners[i]);
            }
        }
        if (this.globalTriggerListeners != null) {
            for (i = 0; i < this.globalTriggerListeners.length; ++i) {
                this.getScheduler().addGlobalTriggerListener(this.globalTriggerListeners[i]);
            }
        }
        if (this.triggerListeners != null) {
            for (i = 0; i < this.triggerListeners.length; ++i) {
                this.getScheduler().addTriggerListener(this.triggerListeners[i]);
            }
        }
    }

    protected abstract Scheduler getScheduler();
}

