/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resource.security;

import java.security.Principal;
import java.security.acl.Group;
import java.util.Map;
import javax.resource.spi.security.PasswordCredential;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginException;
import org.jboss.logging.Logger;
import org.jboss.resource.security.AbstractPasswordCredentialLoginModule;
import org.jboss.resource.security.SubjectActions;
import org.jboss.security.SimplePrincipal;

public class ConfiguredIdentityLoginModule
extends AbstractPasswordCredentialLoginModule {
    private String principalName;
    private String userName;
    private String password;
    private static final Logger log = Logger.getLogger(ConfiguredIdentityLoginModule.class);
    private boolean trace = log.isTraceEnabled();

    public void initialize(Subject subject, CallbackHandler handler, Map sharedState, Map options) {
        super.initialize(subject, handler, sharedState, options);
        this.principalName = (String)options.get("principal");
        if (this.principalName == null) {
            throw new IllegalArgumentException("Must supply a principal name!");
        }
        this.userName = (String)options.get("userName");
        if (this.userName == null) {
            throw new IllegalArgumentException("Must supply a user name!");
        }
        this.password = (String)options.get("password");
        if (this.password == null) {
            log.warn((Object)"Creating LoginModule with no configured password!");
            this.password = "";
        }
        if (this.trace) {
            log.trace((Object)("got principal: " + this.principalName + ", username: " + this.userName + ", password: " + this.password));
        }
    }

    public boolean login() throws LoginException {
        if (this.trace) {
            log.trace((Object)"login called");
        }
        if (super.login()) {
            return true;
        }
        SimplePrincipal principal = new SimplePrincipal(this.principalName);
        SubjectActions.addPrincipals(this.subject, principal);
        this.sharedState.put("javax.security.auth.login.name", this.principalName);
        PasswordCredential cred = new PasswordCredential(this.userName, this.password.toCharArray());
        cred.setManagedConnectionFactory(this.getMcf());
        SubjectActions.addCredentials(this.subject, cred);
        this.loginOk = true;
        return true;
    }

    protected Principal getIdentity() {
        if (this.trace) {
            log.trace((Object)"getIdentity called");
        }
        SimplePrincipal principal = new SimplePrincipal(this.principalName);
        return principal;
    }

    protected Group[] getRoleSets() throws LoginException {
        if (this.trace) {
            log.trace((Object)"getRoleSets called");
        }
        return new Group[0];
    }
}

