/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.batch;

import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.jboss.cache.CacheException;
import org.jboss.cache.factories.annotations.Inject;

public class BatchContainer {
    TransactionManager transactionManager;
    private ThreadLocal<Transaction> batchTransactionContainer = new ThreadLocal();

    @Inject
    void inject(TransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }

    public void startBatch() throws CacheException {
        try {
            if (this.transactionManager.getTransaction() != null) {
                return;
            }
            if (this.batchTransactionContainer.get() == null) {
                this.transactionManager.begin();
                this.batchTransactionContainer.set(this.transactionManager.suspend());
            }
        }
        catch (Exception e) {
            throw new CacheException("Unable to start batch", e);
        }
    }

    public void endBatch(boolean success) {
        Transaction tx = this.batchTransactionContainer.get();
        if (tx == null) {
            return;
        }
        Transaction existingTx = null;
        try {
            existingTx = this.transactionManager.getTransaction();
            this.transactionManager.resume(tx);
            if (success) {
                tx.commit();
            } else {
                tx.rollback();
            }
        }
        catch (Exception e) {
            throw new CacheException("Unable to end batch", e);
        }
        finally {
            this.batchTransactionContainer.remove();
            try {
                if (existingTx != null) {
                    this.transactionManager.resume(existingTx);
                }
            }
            catch (Exception e) {
                throw new CacheException("Failed resuming existing transaction " + existingTx, e);
            }
        }
    }

    public Transaction getBatchTransaction() {
        return this.batchTransactionContainer.get();
    }
}

