/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.proxy.impl.jndiregistrar;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.naming.Context;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import javax.naming.spi.ObjectFactory;
import org.jboss.aop.Advisor;
import org.jboss.aop.Dispatcher;
import org.jboss.aop.advice.Interceptor;
import org.jboss.aspects.remoting.InvokeRemoteInterceptor;
import org.jboss.aspects.remoting.PojiProxy;
import org.jboss.ejb3.common.registrar.spi.DuplicateBindException;
import org.jboss.ejb3.common.registrar.spi.Ejb3RegistrarLocator;
import org.jboss.ejb3.common.registrar.spi.NotBoundException;
import org.jboss.ejb3.common.string.StringUtils;
import org.jboss.ejb3.proxy.impl.factory.ProxyFactory;
import org.jboss.ejb3.proxy.impl.jndiregistrar.JndiReferenceBinding;
import org.jboss.ejb3.proxy.impl.jndiregistrar.JndiReferenceBindingSet;
import org.jboss.ejb3.proxy.impl.remoting.IsLocalProxyFactoryInterceptor;
import org.jboss.ejb3.proxy.impl.remoting.ProxyRemotingUtils;
import org.jboss.logging.Logger;
import org.jboss.metadata.ejb.jboss.JBossEnterpriseBeanMetaData;
import org.jboss.metadata.ejb.jboss.JBossSessionBeanMetaData;
import org.jboss.metadata.ejb.jboss.RemoteBindingMetaData;
import org.jboss.metadata.ejb.jboss.jndipolicy.spi.DeploymentSummary;
import org.jboss.metadata.ejb.jboss.jndipolicy.spi.JbossSessionBeanJndiNameResolver;
import org.jboss.metadata.ejb.spec.BusinessLocalsMetaData;
import org.jboss.metadata.ejb.spec.BusinessRemotesMetaData;
import org.jboss.naming.Util;
import org.jboss.remoting.InvokerLocator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JndiSessionRegistrarBase {
    private static final Logger log = Logger.getLogger(JndiSessionRegistrarBase.class);
    private static final String KEY_PREFIX_PROXY_FACTORY_REGISTRY = "ProxyFactory/";
    private static final String OBJECT_FACTORY_CLASSNAME_PREFIX = "Proxy for: ";
    private String sessionProxyObjectFactoryType;

    public JndiSessionRegistrarBase(String sessionProxyObjectFactoryType) {
        assert (sessionProxyObjectFactoryType != null && !sessionProxyObjectFactoryType.equals("")) : "Session EJB Proxy " + ObjectFactory.class.getSimpleName() + " must be specified.";
        try {
            Class.forName(sessionProxyObjectFactoryType);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Specified " + ObjectFactory.class.getSimpleName() + " of " + sessionProxyObjectFactoryType + " could not be loaded.", e);
        }
        this.setSessionProxyObjectFactoryType(sessionProxyObjectFactoryType);
        log.debug((Object)("Using Session EJB JNDI " + ObjectFactory.class.getSimpleName() + ": " + this.getSessionProxyObjectFactoryType()));
    }

    public void bindEjb(Context context, JBossSessionBeanMetaData smd, ClassLoader cl, String containerName, String containerGuid, Advisor advisor) {
        JndiReferenceBindingSet bindingSet = this.createJndiReferenceBindingSet(context, smd, cl, containerName, containerGuid, advisor);
        this.bind(context, bindingSet, false, true);
    }

    protected JndiReferenceBindingSet createJndiReferenceBindingSet(Context context, JBossSessionBeanMetaData smd, ClassLoader cl, String containerName, String containerGuid, Advisor advisor) {
        String ejbName = smd.getEjbName();
        log.debug((Object)("Found Session Bean: " + ejbName));
        BusinessLocalsMetaData businessLocals = smd.getBusinessLocals();
        BusinessRemotesMetaData businessRemotes = smd.getBusinessRemotes();
        String localHome = StringUtils.adjustWhitespaceStringToNull((String)smd.getLocalHome());
        String remoteHome = StringUtils.adjustWhitespaceStringToNull((String)smd.getHome());
        boolean hasLocalBusinessView = businessLocals != null && businessLocals.size() > 0;
        boolean hasRemoteBusinessView = businessRemotes != null && businessRemotes.size() > 0;
        boolean hasLocalView = localHome != null || hasLocalBusinessView;
        boolean hasRemoteView = remoteHome != null || hasRemoteBusinessView;
        JndiReferenceBindingSet bindingSet = new JndiReferenceBindingSet(context);
        if (hasRemoteView) {
            String defaultClientBindUrl = ProxyRemotingUtils.getDefaultClientBinding();
            ArrayList<RefAddr> refAddrsForRemote = new ArrayList<RefAddr>();
            if (businessRemotes != null) {
                for (String businessRemote : businessRemotes) {
                    StringRefAddr refAddr = new StringRefAddr("Remote Business Interface", businessRemote);
                    refAddrsForRemote.add(refAddr);
                }
            }
            String defaultRemoteJndiName = smd.getJndiName();
            String defaultRemoteProxyFactoryKey = this.getProxyFactoryRegistryKey(defaultRemoteJndiName, smd, false);
            ProxyFactory factory = this.createRemoteProxyFactory(defaultRemoteProxyFactoryKey, containerName, containerGuid, smd, cl, defaultClientBindUrl, advisor, null);
            try {
                this.registerProxyFactory(defaultRemoteProxyFactoryKey, factory, (JBossEnterpriseBeanMetaData)smd);
            }
            catch (DuplicateBindException dbe) {
                throw new RuntimeException(dbe);
            }
            String defaultRemoteClassName = this.getHumanReadableListOfInterfacesInRefAddrs(refAddrsForRemote);
            Reference defaultRemoteRef = this.createStandardReference(OBJECT_FACTORY_CLASSNAME_PREFIX + defaultRemoteClassName, defaultRemoteProxyFactoryKey, containerName, false);
            this.bindRemoteProxyFactory(context, defaultRemoteProxyFactoryKey, defaultClientBindUrl, factory, cl, (JBossEnterpriseBeanMetaData)smd);
            boolean bindRemoteAndHomeTogether = this.isHomeAndBusinessBoundTogether(smd, false);
            if (bindRemoteAndHomeTogether) {
                String home = smd.getHome();
                assert (home != null) : "Home and Business set to be bound together, yet no home is defined";
                StringRefAddr refAddr = new StringRefAddr("EJB 2.x Remote Home Interface", home);
                refAddrsForRemote.add(refAddr);
            } else if (smd.getHome() != null && smd.getHome().trim().length() > 0) {
                String homeType = smd.getHome();
                StringRefAddr refAddrHomeInterface = new StringRefAddr("EJB 2.x Remote Home Interface", homeType);
                RefAddr refAddrRemoting = this.createRemotingRefAddr(defaultClientBindUrl);
                Reference homeRef = this.createStandardReference(OBJECT_FACTORY_CLASSNAME_PREFIX + homeType, defaultRemoteProxyFactoryKey, containerName, false);
                homeRef.add(refAddrHomeInterface);
                homeRef.add(refAddrRemoting);
                String homeAddress = smd.getHomeJndiName();
                assert (homeAddress != null && !homeAddress.equals("")) : "JNDI Address for Remote Home must be defined";
                log.debug((Object)("Remote Home View for EJB " + smd.getEjbName() + " to be bound into JNDI at \"" + homeAddress + "\""));
                bindingSet.addHomeRemoteBinding(new JndiReferenceBinding(homeAddress, homeRef));
            }
            List remoteBindings = smd.getRemoteBindings();
            if (remoteBindings == null && hasRemoteBusinessView) {
                String clientBindUrl = defaultClientBindUrl;
                RefAddr defaultRemoteRemotingRefAddr = this.createRemotingRefAddr(clientBindUrl);
                refAddrsForRemote.add(defaultRemoteRemotingRefAddr);
                for (RefAddr refAddr : refAddrsForRemote) {
                    log.debug((Object)("Adding " + RefAddr.class.getSimpleName() + " to Default Remote " + Reference.class.getSimpleName() + ": Type \"" + refAddr.getType() + "\", Content \"" + refAddr.getContent() + "\""));
                    defaultRemoteRef.add(refAddr);
                }
                log.debug((Object)("Default Remote Business View for EJB " + smd.getEjbName() + " to be bound into JNDI at \"" + defaultRemoteJndiName + "\""));
                bindingSet.addDefaultRemoteBinding(new JndiReferenceBinding(defaultRemoteJndiName, defaultRemoteRef));
            } else if (remoteBindings != null && hasRemoteView) {
                for (RemoteBindingMetaData binding : remoteBindings) {
                    String remoteBindingClientBindUrl;
                    boolean remoteBindingInvokerNameDefined;
                    String remoteBindingJndiName = binding.getJndiName();
                    if (remoteBindingJndiName == null || remoteBindingJndiName.trim().length() == 0) {
                        remoteBindingJndiName = smd.getJndiName();
                    }
                    String clientBindUrl = defaultClientBindUrl;
                    String remoteBindingInvokerBindName = binding.getInvokerName();
                    boolean bl = remoteBindingInvokerNameDefined = remoteBindingInvokerBindName != null && remoteBindingInvokerBindName.trim().length() > 0;
                    if (remoteBindingInvokerNameDefined) {
                        clientBindUrl = ProxyRemotingUtils.getClientBinding(remoteBindingInvokerBindName);
                        log.debug((Object)("Using client bind URL of " + clientBindUrl + " as specified by invokerName " + remoteBindingInvokerBindName + " for EJB " + smd.getName() + " with JNDI Binding: " + remoteBindingJndiName));
                    }
                    if ((remoteBindingClientBindUrl = binding.getClientBindUrl()) != null && remoteBindingClientBindUrl.trim().length() > 0) {
                        clientBindUrl = remoteBindingClientBindUrl;
                        log.debug((Object)("Using client bind URL of " + clientBindUrl + " as specified by clientBindUrl " + remoteBindingClientBindUrl + " for EJB " + smd.getName() + " with JNDI Binding: " + remoteBindingJndiName));
                        if (remoteBindingInvokerNameDefined) {
                            log.warn((Object)("Both invokerName and clientBindUrl have been specified on " + RemoteBindingMetaData.class.getSimpleName() + " for EJB " + smd.getName() + "; clientBindUrl takes priority"));
                        }
                    }
                    String interceptorStack = binding.getInterceptorStack();
                    String remoteBindingProxyFactoryKey = this.getProxyFactoryRegistryKey(remoteBindingJndiName, smd, false);
                    ProxyFactory remoteBindingProxyFactory = null;
                    boolean reregister = true;
                    try {
                        remoteBindingProxyFactory = (ProxyFactory)Ejb3RegistrarLocator.locateRegistrar().lookup((Object)remoteBindingProxyFactoryKey, ProxyFactory.class);
                    }
                    catch (NotBoundException nbe) {
                        reregister = false;
                    }
                    if (reregister) {
                        Ejb3RegistrarLocator.locateRegistrar().unbind((Object)remoteBindingProxyFactoryKey);
                    }
                    remoteBindingProxyFactory = this.createRemoteProxyFactory(remoteBindingProxyFactoryKey, containerName, containerGuid, smd, cl, clientBindUrl, advisor, interceptorStack);
                    try {
                        this.registerProxyFactory(remoteBindingProxyFactoryKey, remoteBindingProxyFactory, (JBossEnterpriseBeanMetaData)smd);
                    }
                    catch (DuplicateBindException dbe) {
                        throw new RuntimeException(dbe);
                    }
                    RefAddr remoteBindingRemotingRefAddr = this.createRemotingRefAddr(clientBindUrl);
                    Reference remoteBindingRef = this.createStandardReference(OBJECT_FACTORY_CLASSNAME_PREFIX + defaultRemoteClassName, remoteBindingProxyFactoryKey, containerName, false);
                    if (reregister) {
                        this.unbind(context, remoteBindingProxyFactoryKey);
                    }
                    this.bindRemoteProxyFactory(context, remoteBindingProxyFactoryKey, clientBindUrl, remoteBindingProxyFactory, cl, (JBossEnterpriseBeanMetaData)smd);
                    log.debug((Object)("Adding " + RefAddr.class.getSimpleName() + " to @RemoteBinding " + Reference.class.getSimpleName() + ": Type \"" + remoteBindingRemotingRefAddr.getType() + "\", Content \"" + remoteBindingRemotingRefAddr.getContent() + "\""));
                    remoteBindingRef.add(remoteBindingRemotingRefAddr);
                    for (RefAddr refAddr : refAddrsForRemote) {
                        log.debug((Object)("Adding " + RefAddr.class.getSimpleName() + " to @RemoteBinding " + Reference.class.getSimpleName() + ": Type \"" + refAddr.getType() + "\", Content \"" + refAddr.getContent() + "\""));
                        remoteBindingRef.add(refAddr);
                    }
                    JndiReferenceBinding remoteBindingJndiBinding = new JndiReferenceBinding(remoteBindingJndiName, remoteBindingRef);
                    bindingSet.addDefaultRemoteBinding(remoteBindingJndiBinding);
                }
            }
            if (businessRemotes != null) {
                for (String businessRemote : businessRemotes) {
                    StringRefAddr refAddrBusinessInterface = new StringRefAddr("Remote Business Interface", businessRemote);
                    RefAddr refAddrRemoting = this.createRemotingRefAddr(defaultClientBindUrl);
                    Reference ref = this.createStandardReference(OBJECT_FACTORY_CLASSNAME_PREFIX + businessRemote, defaultRemoteProxyFactoryKey, containerName, false);
                    ref.add(refAddrBusinessInterface);
                    ref.add(refAddrRemoting);
                    String address = JbossSessionBeanJndiNameResolver.resolveJndiName((JBossEnterpriseBeanMetaData)smd, (String)businessRemote);
                    log.debug((Object)("Remote Business View for " + businessRemote + " of EJB " + smd.getEjbName() + " to be bound into JNDI at \"" + address + "\""));
                    bindingSet.addBusinessRemoteBinding(businessRemote, new JndiReferenceBinding(address, ref));
                }
            }
        }
        if (hasLocalView) {
            boolean bindLocalAndLocalHomeTogether;
            StringRefAddr refAddr;
            String defaultLocalJndiName = smd.getLocalJndiName();
            String localProxyFactoryKey = this.getProxyFactoryRegistryKey(defaultLocalJndiName, smd, true);
            ProxyFactory factory = this.createLocalProxyFactory(localProxyFactoryKey, containerName, containerGuid, smd, cl, advisor);
            try {
                this.registerProxyFactory(localProxyFactoryKey, factory, (JBossEnterpriseBeanMetaData)smd);
            }
            catch (DuplicateBindException dbe) {
                throw new RuntimeException(dbe);
            }
            ArrayList<RefAddr> refAddrsForDefaultLocal = new ArrayList<RefAddr>();
            if (businessLocals != null) {
                for (String businessLocal : businessLocals) {
                    refAddr = new StringRefAddr("Local Business Interface", businessLocal);
                    refAddrsForDefaultLocal.add(refAddr);
                }
            }
            if (bindLocalAndLocalHomeTogether = this.isHomeAndBusinessBoundTogether(smd, true)) {
                StringRefAddr refAddr2 = new StringRefAddr("EJB 2.x Local Home Interface", smd.getLocalHome());
                refAddrsForDefaultLocal.add(refAddr2);
            } else if (smd.getLocalHome() != null && !smd.getLocalHome().equals("")) {
                String localHomeType = smd.getLocalHome();
                refAddr = new StringRefAddr("EJB 2.x Local Home Interface", localHomeType);
                Reference localHomeRef = this.createStandardReference(OBJECT_FACTORY_CLASSNAME_PREFIX + localHomeType, localProxyFactoryKey, containerName, true);
                localHomeRef.add(refAddr);
                String localHomeAddress = smd.getLocalHomeJndiName();
                log.debug((Object)("Local Home View for EJB " + smd.getEjbName() + " to be bound into JNDI at \"" + localHomeAddress + "\""));
                bindingSet.addHomeLocalBinding(new JndiReferenceBinding(localHomeAddress, localHomeRef));
            }
            if (hasLocalBusinessView) {
                String defaultLocalClassName = this.getHumanReadableListOfInterfacesInRefAddrs(refAddrsForDefaultLocal);
                Reference defaultLocalRef = this.createStandardReference(OBJECT_FACTORY_CLASSNAME_PREFIX + defaultLocalClassName, localProxyFactoryKey, containerName, true);
                for (RefAddr refAddr3 : refAddrsForDefaultLocal) {
                    log.debug((Object)("Adding " + RefAddr.class.getSimpleName() + " to Default Local " + Reference.class.getSimpleName() + ": Type \"" + refAddr3.getType() + "\", Content \"" + refAddr3.getContent() + "\""));
                    defaultLocalRef.add(refAddr3);
                }
                String defaultLocalAddress = smd.getLocalJndiName();
                log.debug((Object)("Default Local Business View for EJB " + smd.getEjbName() + " to be bound into JNDI at \"" + defaultLocalAddress + "\""));
                bindingSet.addDefaultLocalBinding(new JndiReferenceBinding(defaultLocalAddress, defaultLocalRef));
                for (String businessLocal : businessLocals) {
                    StringRefAddr refAddr4 = new StringRefAddr("Local Business Interface", businessLocal);
                    Reference ref = this.createStandardReference(OBJECT_FACTORY_CLASSNAME_PREFIX + businessLocal, localProxyFactoryKey, containerName, true);
                    ref.add(refAddr4);
                    String address = JbossSessionBeanJndiNameResolver.resolveJndiName((JBossEnterpriseBeanMetaData)smd, (String)businessLocal);
                    log.debug((Object)("Local Business View for " + businessLocal + " of EJB " + smd.getEjbName() + " to be bound into JNDI at \"" + address + "\""));
                    bindingSet.addBusinessLocalBinding(businessLocal, new JndiReferenceBinding(address, ref));
                }
            }
        }
        return bindingSet;
    }

    public void unbindEjb(Context context, JBossSessionBeanMetaData smd) {
        String address;
        boolean hasRemoteView;
        String ejbName = smd.getEjbName();
        log.debug((Object)("Unbinding JNDI References for Session Bean: " + ejbName));
        BusinessLocalsMetaData businessLocals = smd.getBusinessLocals();
        BusinessRemotesMetaData businessRemotes = smd.getBusinessRemotes();
        String localHome = StringUtils.adjustWhitespaceStringToNull((String)smd.getLocalHome());
        String remoteHome = StringUtils.adjustWhitespaceStringToNull((String)smd.getHome());
        boolean hasLocalView = localHome != null || businessLocals != null && businessLocals.size() > 0;
        boolean bl = hasRemoteView = remoteHome != null || businessRemotes != null && businessRemotes.size() > 0;
        if (hasRemoteView) {
            List remoteBindings = smd.getRemoteBindings();
            String defaultRemoteJndiName = smd.getJndiName();
            String remoteProxyFactoryKey = this.getProxyFactoryRegistryKey(defaultRemoteJndiName, smd, false);
            this.deregisterProxyFactory(remoteProxyFactoryKey);
            this.unbind(context, remoteProxyFactoryKey);
            boolean bindRemoteAndHomeTogether = this.isHomeAndBusinessBoundTogether(smd, false);
            if (smd.getHome() != null && !smd.getHome().equals("") && !bindRemoteAndHomeTogether) {
                String homeAddress = smd.getHomeJndiName();
                log.debug((Object)("Remote Home View for EJB " + smd.getEjbName() + " to be unbound from JNDI at \"" + homeAddress + "\""));
                this.unbind(context, homeAddress);
            }
            log.debug((Object)("Default Remote Business View for EJB " + smd.getEjbName() + " to be unbound from JNDI at \"" + defaultRemoteJndiName + "\""));
            this.unbind(context, defaultRemoteJndiName);
            if (remoteBindings != null) {
                for (RemoteBindingMetaData remoteBinding : remoteBindings) {
                    String remoteBindingJndiName = remoteBinding.getJndiName();
                    if (remoteBindingJndiName == null || remoteBindingJndiName.trim().length() <= 0) continue;
                    this.unbind(context, remoteBindingJndiName);
                    String remoteBindingProxyFactoryKey = this.getProxyFactoryRegistryKey(remoteBindingJndiName, smd, false);
                    this.deregisterProxyFactory(remoteBindingProxyFactoryKey);
                    this.unbind(context, remoteBindingProxyFactoryKey);
                }
            }
            if (businessRemotes != null) {
                for (String businessRemote : businessRemotes) {
                    address = JbossSessionBeanJndiNameResolver.resolveJndiName((JBossEnterpriseBeanMetaData)smd, (String)businessRemote);
                    log.debug((Object)("Remote Business View for " + businessRemote + " of EJB " + smd.getEjbName() + " to be unbound from JNDI at \"" + address + "\""));
                    this.unbind(context, address);
                }
            }
        }
        if (hasLocalView) {
            String defaultLocalJndiName = smd.getLocalJndiName();
            String localProxyFactoryKey = this.getProxyFactoryRegistryKey(defaultLocalJndiName, smd, true);
            this.deregisterProxyFactory(localProxyFactoryKey);
            boolean bindLocalAndLocalHomeTogether = this.isHomeAndBusinessBoundTogether(smd, true);
            if (smd.getLocalHome() != null && !smd.getLocalHome().equals("") && !bindLocalAndLocalHomeTogether) {
                String localHomeAddress = smd.getLocalHomeJndiName();
                log.debug((Object)("Local Home View for EJB " + smd.getEjbName() + " to be unbound from JNDI at \"" + localHomeAddress + "\""));
                this.unbind(context, localHomeAddress);
            }
            String defaultLocalAddress = smd.getLocalJndiName();
            log.debug((Object)("Default Local Business View for EJB " + smd.getEjbName() + " to be unbound from JNDI at \"" + defaultLocalAddress + "\""));
            this.unbind(context, defaultLocalAddress);
            if (businessLocals != null) {
                for (String businessLocal : businessLocals) {
                    address = JbossSessionBeanJndiNameResolver.resolveJndiName((JBossEnterpriseBeanMetaData)smd, (String)businessLocal);
                    log.debug((Object)("Local Business View for " + businessLocal + " of EJB " + smd.getEjbName() + " to be unbound from JNDI at \"" + address + "\""));
                    this.unbind(context, address);
                }
            }
        }
    }

    protected abstract ProxyFactory createLocalProxyFactory(String var1, String var2, String var3, JBossSessionBeanMetaData var4, ClassLoader var5, Advisor var6);

    protected abstract ProxyFactory createRemoteProxyFactory(String var1, String var2, String var3, JBossSessionBeanMetaData var4, ClassLoader var5, String var6, Advisor var7, String var8);

    protected Reference createStandardReference(String referenceName, String proxyFactoryRegistryKey, String containerName, boolean isLocal) {
        Reference ref = new Reference(referenceName, this.getSessionProxyObjectFactoryType(), null);
        assert (proxyFactoryRegistryKey != null && !proxyFactoryRegistryKey.trim().equals("")) : "Proxy Factory Registry key is required but not supplied";
        String proxyFactoryRefType = "ProxyFactoryKey";
        StringRefAddr proxyFactoryRefAddr = new StringRefAddr(proxyFactoryRefType, proxyFactoryRegistryKey);
        ref.add(proxyFactoryRefAddr);
        log.debug((Object)("Adding " + RefAddr.class.getSimpleName() + " to " + Reference.class.getSimpleName() + ": Type \"" + proxyFactoryRefType + "\", Content \"" + proxyFactoryRegistryKey + "\""));
        assert (containerName != null && !containerName.trim().equals("")) : "Container Name is required but not supplied";
        String ejbContainerRefType = "EJB Container Name";
        StringRefAddr containerRefAddr = new StringRefAddr(ejbContainerRefType, containerName);
        ref.add(containerRefAddr);
        log.debug((Object)("Adding " + RefAddr.class.getSimpleName() + " to " + Reference.class.getSimpleName() + ": Type \"" + ejbContainerRefType + "\", Content \"" + containerName + "\""));
        String isLocalRefAddrType = "Proxy Factory is Local";
        StringRefAddr isLocalRefAddr = new StringRefAddr(isLocalRefAddrType, Boolean.toString(isLocal));
        ref.add(isLocalRefAddr);
        return ref;
    }

    protected void bind(Context context, JndiReferenceBindingSet bindings, boolean useRebind, boolean bindLocals) {
        ArrayList<JndiReferenceBinding> addressesToBind = new ArrayList<JndiReferenceBinding>();
        StringBuffer sb = new StringBuffer();
        sb.append("Binding the following Entries in Global JNDI:\n\n");
        for (JndiReferenceBinding jndiReferenceBinding : bindings.getDefaultRemoteBindings()) {
            sb.append("\t");
            sb.append(jndiReferenceBinding.getJndiName());
            sb.append(" - EJB3.x Default Remote Business Interface\n");
            addressesToBind.add(jndiReferenceBinding);
        }
        for (JndiReferenceBinding jndiReferenceBinding : bindings.getHomeRemoteBindings()) {
            sb.append("\t");
            sb.append(jndiReferenceBinding.getJndiName());
            sb.append(" - EJB2.x Remote Home Interface\n");
            addressesToBind.add(jndiReferenceBinding);
        }
        for (Set set : bindings.getBusinessRemoteBindings().values()) {
            for (JndiReferenceBinding binding : set) {
                sb.append("\t");
                sb.append(binding.getJndiName());
                sb.append(" - EJB3.x Remote Business Interface\n");
                addressesToBind.add(binding);
            }
        }
        if (bindLocals) {
            for (JndiReferenceBinding jndiReferenceBinding : bindings.getDefaultLocalBindings()) {
                sb.append("\t");
                sb.append(jndiReferenceBinding.getJndiName());
                sb.append(" - EJB3.x Default Local Business Interface\n");
                addressesToBind.add(jndiReferenceBinding);
            }
            for (JndiReferenceBinding jndiReferenceBinding : bindings.getHomeLocalBindings()) {
                sb.append("\t");
                sb.append(jndiReferenceBinding.getJndiName());
                sb.append(" - EJB2.x Local Home Interface\n");
                addressesToBind.add(jndiReferenceBinding);
            }
            for (Set set : bindings.getBusinessLocalBindings().values()) {
                for (JndiReferenceBinding binding : set) {
                    sb.append("\t");
                    sb.append(binding.getJndiName());
                    sb.append(" - EJB3.x Local Business Interface\n");
                    addressesToBind.add(binding);
                }
            }
        }
        log.info((Object)sb.toString());
        for (JndiReferenceBinding jndiReferenceBinding : addressesToBind) {
            this.bind(context, jndiReferenceBinding, useRebind);
        }
    }

    protected void bind(Context context, JndiReferenceBinding binding, boolean useRebind) {
        if (binding != null) {
            if (useRebind) {
                this.rebind(context, binding.getJndiName(), binding.getReference());
            } else {
                this.bind(context, binding.getJndiName(), binding.getReference());
            }
        }
    }

    protected void bind(Context context, String address, Reference ref) {
        try {
            Util.bind((Context)context, (String)address, (Object)ref);
            log.debug((Object)("Bound " + ref.getClass().getName() + " into JNDI at \"" + address + "\""));
        }
        catch (NamingException e) {
            throw new RuntimeException("Could not bind " + ref + " into JNDI at \"" + address + "\"", e);
        }
    }

    protected void rebind(Context context, String address, Reference ref) {
        try {
            Util.rebind((Context)context, (String)address, (Object)ref);
            log.debug((Object)("Bound " + ref.getClass().getName() + " into JNDI at \"" + address + "\""));
        }
        catch (NamingException e) {
            throw new RuntimeException("Could not bind " + ref + " into JNDI at \"" + address + "\"", e);
        }
    }

    protected void unbind(Context context, String address) {
        try {
            Util.unbind((Context)context, (String)address);
        }
        catch (NameNotFoundException nnfe) {
        }
        catch (NamingException e) {
            throw new RuntimeException("Could not unbind \"" + address + "\" from JNDI", e);
        }
    }

    protected boolean isHomeAndBusinessBoundTogether(JBossSessionBeanMetaData smd, boolean isLocal) {
        boolean bindTogether = false;
        if (isLocal) {
            if (smd.getLocalHome() == null) {
                return false;
            }
            BusinessLocalsMetaData businessLocals = smd.getBusinessLocals();
            if (businessLocals == null || businessLocals.size() == 0) {
                return false;
            }
            bindTogether = smd.getLocalJndiName().equals(smd.getLocalHomeJndiName());
        } else {
            if (smd.getHome() == null) {
                return false;
            }
            BusinessRemotesMetaData businessRemotes = smd.getBusinessRemotes();
            if (businessRemotes == null || businessRemotes.size() == 0) {
                return false;
            }
            bindTogether = smd.getJndiName().equals(smd.getHomeJndiName());
        }
        return bindTogether;
    }

    protected RefAddr createRemotingRefAddr(String clientBindUrl) {
        assert (clientBindUrl != null && clientBindUrl.trim().toString().length() != 0) : InvokerLocator.class.getSimpleName() + " URL must be defined, and is unspecified";
        StringRefAddr refAddr = new StringRefAddr("Remoting Host URL", clientBindUrl);
        return refAddr;
    }

    public String getProxyFactoryRegistryKey(String jndiName, JBossSessionBeanMetaData smd, boolean isLocal) {
        String suffix = null;
        suffix = jndiName;
        assert (suffix != null && !suffix.equals("")) : ProxyFactory.class.getSimpleName() + " key prefix for binding to registry is not specified";
        String earName = null;
        DeploymentSummary summary = smd.getEjbJarMetaData().getDeploymentSummary();
        if (summary != null) {
            earName = summary.getDeploymentScopeBaseName();
        }
        String earPrefix = earName == null ? "" : earName + "/";
        String key = KEY_PREFIX_PROXY_FACTORY_REGISTRY + earPrefix + smd.getEjbName() + "/" + suffix;
        key = this.cleanseProxyFactoryJNDIName(key);
        return key;
    }

    protected String getHumanReadableListOfInterfacesInRefAddrs(List<RefAddr> refAddrs) {
        StringBuffer defaultRemotes = new StringBuffer();
        int remotesCount = 0;
        int interfaceCount = 0;
        for (RefAddr refAddr : refAddrs) {
            ++remotesCount;
            String refAddrType = refAddr.getType();
            if (!this.isRefAddrTypeEjbInterface(refAddrType)) continue;
            if (interfaceCount > 0) {
                defaultRemotes.append(", ");
            }
            defaultRemotes.append(refAddr.getContent());
            ++interfaceCount;
        }
        return defaultRemotes.toString();
    }

    private boolean isRefAddrTypeEjbInterface(String refAddrType) {
        return refAddrType.equals("Local Business Interface") || refAddrType.equals("Remote Business Interface") || refAddrType.equals("EJB 2.x Local Home Interface") || refAddrType.equals("EJB 2.x Remote Home Interface");
    }

    protected void registerProxyFactory(String name, ProxyFactory factory, JBossEnterpriseBeanMetaData smd) throws DuplicateBindException {
        log.debug((Object)("Registering " + factory + "for EJB " + smd.getName() + " under key \"" + name + "\"..."));
        try {
            Ejb3RegistrarLocator.locateRegistrar().bind((Object)name, (Object)factory);
        }
        catch (DuplicateBindException e) {
            throw new DuplicateBindException("Could not register " + factory + " under an already registered key, \"" + name + "\" for EJB " + smd.getName(), (Throwable)e);
        }
    }

    protected void bindRemoteProxyFactory(Context context, String proxyFactoryKey, String remotingUrl, ProxyFactory proxyFactory, ClassLoader cl, JBossEnterpriseBeanMetaData smd) {
        ProxyFactory proxyToProxyFactory = this.createProxyToProxyFactory(proxyFactoryKey, remotingUrl, proxyFactory, cl, smd);
        try {
            log.debug((Object)("Binding remote ProxyFactory to JNDI, at key " + proxyFactoryKey));
            Util.bind((Context)context, (String)proxyFactoryKey, (Object)proxyToProxyFactory);
        }
        catch (NamingException ne) {
            throw new RuntimeException("Could not bind remote proxy factory to JNDI, at key " + proxyFactoryKey, ne);
        }
    }

    protected ProxyFactory createProxyToProxyFactory(String proxyFactoryKey, String remotingUrl, ProxyFactory proxyFactory, ClassLoader cl, JBossEnterpriseBeanMetaData smd) {
        try {
            InvokerLocator locator = new InvokerLocator(remotingUrl);
            Interceptor[] interceptors = new Interceptor[]{IsLocalProxyFactoryInterceptor.singleton, InvokeRemoteInterceptor.singleton};
            PojiProxy handler = new PojiProxy((Object)proxyFactoryKey, locator, interceptors);
            Class<ProxyFactory>[] proxyFactoryInterfaces = this.getAllProxyFactoryInterfaces(proxyFactory.getClass());
            return (ProxyFactory)Proxy.newProxyInstance(proxyFactoryInterfaces[0].getClassLoader(), proxyFactoryInterfaces, (InvocationHandler)handler);
        }
        catch (MalformedURLException mue) {
            throw new RuntimeException("Unable to create a remoting proxy for ProxyFactory " + proxyFactoryKey + " with remoting url " + remotingUrl, mue);
        }
    }

    protected Class<ProxyFactory>[] getAllProxyFactoryInterfaces(Class<ProxyFactory> klass) {
        Class<?>[] allInterfaces;
        HashSet proxyFactoryInterfaces = new HashSet();
        if (klass.getSuperclass() != null && ProxyFactory.class.isAssignableFrom(klass.getSuperclass())) {
            Class<ProxyFactory>[] intfs = this.getAllProxyFactoryInterfaces(klass.getSuperclass());
            proxyFactoryInterfaces.addAll(Arrays.asList(intfs));
        }
        for (Class<?> intf : allInterfaces = klass.getInterfaces()) {
            if (!ProxyFactory.class.isAssignableFrom(intf)) continue;
            proxyFactoryInterfaces.add(intf);
        }
        return proxyFactoryInterfaces.toArray(new Class[proxyFactoryInterfaces.size()]);
    }

    protected void deregisterProxyFactory(String name) {
        log.debug((Object)("Deregistering " + ProxyFactory.class.getSimpleName() + " under name \"" + name + "\""));
        try {
            Ejb3RegistrarLocator.locateRegistrar().unbind((Object)name);
        }
        catch (NotBoundException notBoundException) {
            // empty catch block
        }
        if (Dispatcher.singleton.isRegistered((Object)name)) {
            Dispatcher.singleton.unregisterTarget((Object)name);
        }
    }

    private String cleanseProxyFactoryJNDIName(String proxyFactoryJNDIName) {
        if (proxyFactoryJNDIName == null) {
            return null;
        }
        String cleansedProxyFactoryJNDIName = proxyFactoryJNDIName.replaceAll("//", "/");
        if (log.isTraceEnabled()) {
            log.trace((Object)("Cleansed proxy factory name from " + proxyFactoryJNDIName + " to " + cleansedProxyFactoryJNDIName));
        }
        return cleansedProxyFactoryJNDIName;
    }

    public String getSessionProxyObjectFactoryType() {
        return this.sessionProxyObjectFactoryType;
    }

    public void setSessionProxyObjectFactoryType(String sessionProxyObjectFactoryType) {
        this.sessionProxyObjectFactoryType = sessionProxyObjectFactoryType;
    }
}

