/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.authorization.modules.ejb;

import java.lang.reflect.Method;
import java.security.Principal;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import org.jboss.logging.Logger;
import org.jboss.security.RunAs;
import org.jboss.security.RunAsIdentity;
import org.jboss.security.authorization.PolicyRegistration;
import org.jboss.security.authorization.Resource;
import org.jboss.security.authorization.modules.AuthorizationModuleDelegate;
import org.jboss.security.authorization.resources.EJBResource;
import org.jboss.security.identity.Role;
import org.jboss.security.identity.RoleGroup;
import org.jboss.security.identity.plugins.SimpleRole;
import org.jboss.security.identity.plugins.SimpleRoleGroup;
import org.jboss.security.javaee.SecurityRoleRef;

public class EJBPolicyModuleDelegate
extends AuthorizationModuleDelegate {
    protected String ejbName = null;
    protected Method ejbMethod = null;
    protected Principal ejbPrincipal = null;
    private RoleGroup methodRoles = null;
    private String methodInterface = null;
    protected RunAs callerRunAs = null;
    protected String roleName = null;
    private Boolean roleRefCheck = Boolean.FALSE;
    protected Set<SecurityRoleRef> securityRoleReferences = null;
    private final Role ANYBODY_ROLE = new SimpleRole("<ANYBODY>");
    protected boolean ejbRestrictions = false;

    public EJBPolicyModuleDelegate() {
        log = Logger.getLogger(this.getClass());
        this.trace = log.isTraceEnabled();
    }

    public int authorize(Resource resource, Subject callerSubject, RoleGroup role) {
        if (!(resource instanceof EJBResource)) {
            throw new IllegalArgumentException("resource is not an EJBResource");
        }
        EJBResource ejbResource = (EJBResource)resource;
        Map map = resource.getMap();
        if (map == null) {
            throw new IllegalStateException("Map from the Resource is null");
        }
        this.policyRegistration = (PolicyRegistration)map.get("policyRegistration");
        this.roleName = (String)map.get("roleName");
        this.roleRefCheck = (Boolean)map.get("roleRefPermissionCheck");
        this.callerRunAs = ejbResource.getCallerRunAsIdentity();
        this.ejbMethod = ejbResource.getEjbMethod();
        this.ejbName = ejbResource.getEjbName();
        this.ejbPrincipal = ejbResource.getPrincipal();
        this.methodInterface = ejbResource.getEjbMethodInterface();
        this.methodRoles = ejbResource.getEjbMethodRoles();
        this.securityRoleReferences = ejbResource.getSecurityRoleReferences();
        this.ejbRestrictions = ejbResource.isEnforceEJBRestrictions();
        if (this.roleRefCheck == Boolean.TRUE) {
            return this.checkRoleRef(role);
        }
        return this.process(role);
    }

    private int process(RoleGroup principalRole) {
        boolean allowed = true;
        if (this.methodRoles == null) {
            if (this.ejbMethod == null) {
                throw new IllegalStateException("ejbMethod is null");
            }
            String method = this.ejbMethod.getName();
            String msg = "No method permissions assigned to method=" + method + ", interface=" + this.methodInterface;
            if (this.trace) {
                log.trace((Object)("Exception:" + msg));
            }
            return -1;
        }
        if (this.trace) {
            log.trace((Object)("method=" + this.ejbMethod + ", interface=" + this.methodInterface + ", requiredRoles=" + this.methodRoles));
        }
        if (!this.methodRoles.containsAll(this.ANYBODY_ROLE)) {
            RunAsIdentity callerRunAsIdentity;
            SimpleRoleGroup srg;
            if (this.callerRunAs == null) {
                if (principalRole == null) {
                    throw new IllegalStateException("Principal Role is null");
                }
                if (!this.methodRoles.containsAtleastOneRole(principalRole)) {
                    if (this.ejbMethod == null) {
                        throw new IllegalStateException("ejbMethod is null");
                    }
                    String method = this.ejbMethod.getName();
                    String msg = "Insufficient method permissions, principal=" + this.ejbPrincipal + ", ejbName=" + this.ejbName + ", method=" + method + ", interface=" + this.methodInterface + ", requiredRoles=" + this.methodRoles + ", principalRoles=" + principalRole;
                    if (this.trace) {
                        log.trace((Object)("Exception:" + msg));
                    }
                    allowed = false;
                }
            } else if (this.callerRunAs instanceof RunAsIdentity && !(srg = new SimpleRoleGroup((callerRunAsIdentity = (RunAsIdentity)this.callerRunAs).getRunAsRoles())).containsAtleastOneRole(this.methodRoles)) {
                String method = this.ejbMethod.getName();
                String msg = "Insufficient method permissions, principal=" + this.ejbPrincipal + ", ejbName=" + this.ejbName + ", method=" + method + ", interface=" + this.methodInterface + ", requiredRoles=" + this.methodRoles + ", runAsRoles=" + callerRunAsIdentity.getRunAsRoles();
                if (this.trace) {
                    log.trace((Object)("Exception:" + msg));
                }
                allowed = false;
            }
        }
        return allowed ? 1 : -1;
    }

    protected int checkRoleRef(RoleGroup principalRole) {
        if (this.ejbPrincipal == null && this.callerRunAs == null) {
            if (this.trace) {
                log.trace((Object)"ejbPrincipal = null,callerRunAsIdentity = null => DENY");
            }
            return -1;
        }
        boolean matchFound = false;
        for (SecurityRoleRef meta : this.securityRoleReferences) {
            if (!meta.getName().equals(this.roleName)) continue;
            this.roleName = meta.getLink();
            matchFound = true;
            break;
        }
        if (!matchFound) {
            if (this.ejbRestrictions) {
                throw new RuntimeException("No matching role found in the deployment descriptor for " + this.roleName);
            }
            log.trace((Object)("no match found for security role " + this.roleName + " in the deployment descriptor for ejb " + this.ejbName));
        }
        SimpleRole deploymentrole = new SimpleRole(this.roleName);
        boolean allowed = false;
        if (this.callerRunAs == null) {
            allowed = principalRole.containsRole((Role)deploymentrole);
        } else if (this.callerRunAs instanceof RunAsIdentity) {
            RunAsIdentity callerRunAsIdentity = (RunAsIdentity)this.callerRunAs;
            SimpleRoleGroup srg = new SimpleRoleGroup(callerRunAsIdentity.getRunAsRoles());
            allowed = srg.containsRole(deploymentrole);
        }
        return allowed ? 1 : -1;
    }
}

