/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployers.vfs.plugins.structure;

import org.jboss.virtual.VirtualFile;
import org.jboss.virtual.VirtualFileFilterWithAttributes;
import org.jboss.virtual.VisitorAttributes;

public class MetaDataMatchFilter
implements VirtualFileFilterWithAttributes {
    private String name;
    private String suffix;
    private VisitorAttributes attributes;

    public MetaDataMatchFilter(String name, String suffix) {
        this(name, suffix, null);
    }

    public MetaDataMatchFilter(String name, String suffix, VisitorAttributes attributes) {
        if (name == null && suffix == null) {
            throw new IllegalArgumentException("Null name and suffix");
        }
        this.name = name;
        this.suffix = suffix;
        if (attributes == null) {
            attributes = VisitorAttributes.LEAVES_ONLY;
        }
        this.attributes = attributes;
    }

    public VisitorAttributes getAttributes() {
        return this.attributes;
    }

    public boolean accepts(VirtualFile file) {
        String fileName = file.getName();
        if (this.name != null && fileName.equals(this.name)) {
            return true;
        }
        if (this.suffix != null) {
            return fileName.endsWith(this.suffix);
        }
        return false;
    }

    public String toString() {
        return "name=" + this.name + ", suffix=" + this.suffix;
    }
}

