/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.tools.shell;

import java.util.List;
import jline.Completor;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

class FlexibleCompletor
implements Completor {
    private Scriptable global;

    FlexibleCompletor(Scriptable global) throws NoSuchMethodException {
        this.global = global;
    }

    public int complete(String buffer, int cursor, List candidates) {
        char c;
        int m = cursor - 1;
        while (m >= 0 && (Character.isJavaIdentifierPart(c = buffer.charAt(m--)) || c == '.')) {
        }
        String namesAndDots = buffer.substring(m + 1, cursor);
        String[] names = namesAndDots.split("\\.");
        Scriptable obj = this.global;
        for (int i = 0; i < names.length - 1; ++i) {
            Object val = obj.get(names[i], this.global);
            if (!(val instanceof Scriptable)) {
                return buffer.length();
            }
            obj = (Scriptable)val;
        }
        Object[] ids = obj instanceof ScriptableObject ? ((ScriptableObject)obj).getAllIds() : obj.getIds();
        String lastPart = names[names.length - 1];
        for (int i = 0; i < ids.length; ++i) {
            String id;
            if (!(ids[i] instanceof String) || !(id = (String)ids[i]).startsWith(lastPart)) continue;
            if (obj.get(id, obj) instanceof Function) {
                id = id + "(";
            }
            candidates.add(id);
        }
        return buffer.length() - lastPart.length();
    }
}

