/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.pojo.impl;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jboss.cache.pojo.Reference;
import org.jboss.cache.pojo.impl.PojoUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PojoInstance
implements Serializable {
    public static final String KEY = "POJOCache.PojoInstance";
    public static final int INITIAL_COUNTER_VALUE = -1;
    static final long serialVersionUID = 6492134565825613209L;
    private transient Object instance_;
    private int refCount_ = -1;
    private final Set<Reference> referencedBy_ = new HashSet<Reference>(4);
    private Class<?> clazz_ = null;
    private transient PojoUtil util_ = new PojoUtil();

    public PojoInstance() {
    }

    public PojoInstance(Object instance) {
        this.set(instance);
    }

    public void setPojoClass(Class clazz) {
        this.clazz_ = clazz;
    }

    public Class getPojoClass() {
        return this.clazz_;
    }

    public Object get() {
        return this.instance_;
    }

    public void set(Object instance) {
        this.instance_ = instance;
    }

    public synchronized int incrementRefCount(Reference reference) {
        if (reference == null || reference.getFqn() == null) {
            throw new IllegalStateException("PojoInstance.incrementRefCount(): null sourceFqn");
        }
        if (this.util_ == null) {
            this.util_ = new PojoUtil();
        }
        this.refCount_ = this.util_.incrementReferenceCount(reference, this.refCount_, this.referencedBy_);
        return this.refCount_;
    }

    public synchronized int decrementRefCount(Reference reference) {
        if (reference == null || reference.getFqn() == null) {
            throw new IllegalStateException("PojoInstance.incrementRefCount(): null sourceFqn");
        }
        if (!this.referencedBy_.contains(reference)) {
            throw new IllegalStateException("PojoReference.decrementRefCount(): reference: " + reference + " is not present.");
        }
        if (this.util_ == null) {
            this.util_ = new PojoUtil();
        }
        this.refCount_ = this.util_.decrementReferenceCount(reference, this.refCount_, this.referencedBy_);
        return this.refCount_;
    }

    public synchronized int getRefCount() {
        return this.refCount_;
    }

    public synchronized Collection<Reference> getReferences() {
        return Collections.unmodifiableCollection(new HashSet<Reference>(this.referencedBy_));
    }

    public String toString() {
        return "PI[ref=" + this.refCount_ + " class=" + this.clazz_.getName() + "]";
    }
}

