/*
 * Decompiled with CFR 0.152.
 */
package xjavadoc;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import xjavadoc.AbstractClass;
import xjavadoc.BinaryClass;
import xjavadoc.ConstructorImpl;
import xjavadoc.DefaultXTag;
import xjavadoc.MethodImpl;
import xjavadoc.ParameterImpl;
import xjavadoc.Primitive;
import xjavadoc.SimpleNode;
import xjavadoc.SourceClass;
import xjavadoc.SourceSet;
import xjavadoc.UnknownClass;
import xjavadoc.XClass;
import xjavadoc.XDoc;
import xjavadoc.XJavaDocException;
import xjavadoc.XMethod;
import xjavadoc.XPackage;
import xjavadoc.XProgramElement;
import xjavadoc.XTagFactory;
import xjavadoc.filesystem.AbstractFile;
import xjavadoc.tags.TagIntrospector;

public final class XJavaDoc {
    public static final String IS_UNICODE = "@IS_UNICODE@";
    public static final int NO_IMPORTED_PACKAGES = 0;
    public static final int ONE_OR_MORE_IMPORTED_PACKAGES = 1;
    private static final List PRIMITIVES = Collections.unmodifiableList(Arrays.asList("void", "java.lang.Void.TYPE", "byte", "java.lang.Byte.TYPE", "short", "java.lang.Short.TYPE", "int", "java.lang.Integer.TYPE", "long", "java.lang.Long.TYPE", "char", "java.lang.Character.TYPE", "float", "java.lang.Float.TYPE", "double", "java.lang.Double.TYPE", "boolean", "java.lang.Boolean.TYPE"));
    private static HashMap _primitiveClasses = new HashMap();
    private final Map _binaryClasses = new HashMap();
    private final Map _unknownClasses = new HashMap();
    private final Map _packages = new HashMap();
    private final Set _sourceSets = new HashSet();
    private final Map _sourceSetSourceClasses = new HashMap();
    private final Map _allSourceClasses = new HashMap();
    private final Set _sourceSetClassNames = new TreeSet();
    private final Map _properties = new HashMap();
    private final Map _abstractFileClasses = new HashMap();
    private final XTagFactory _tagFactory = new XTagFactory();
    private Collection _sourceSetSourceClassesWithInnerClasses = new ArrayList();
    private long _birthday;
    private List _logMessages = new LinkedList();
    private boolean _useNodeParser = false;
    private String _encoding = null;
    private String _docEncoding = null;

    public XJavaDoc() {
        this._birthday = System.currentTimeMillis();
        for (int i = 0; i < PRIMITIVES.size(); i += 2) {
            this.addPrimitive((String)PRIMITIVES.get(i), (String)PRIMITIVES.get(i + 1));
        }
    }

    public static void printMemoryStatus() {
        System.out.println("ParameterImpl instances:   " + ParameterImpl.instanceCount);
        System.out.println("MethodImpl instances:      " + MethodImpl.instanceCount);
        System.out.println("ConstructorImpl instances: " + ConstructorImpl.instanceCount);
        System.out.println("SimpleNode instances:      " + SimpleNode.instanceCount);
        System.out.println("SourceClass instances:     " + SourceClass.instanceCount);
        System.out.println("XDoc instances:            " + XDoc.instanceCount);
        System.out.println("DefaultXTag instances:     " + DefaultXTag.instanceCount);
        System.out.println("BinaryClass instances:     " + BinaryClass.instanceCount);
        System.out.println("UnknownClass instances:    " + UnknownClass.instanceCount);
        System.out.println("Total memory:    " + Runtime.getRuntime().totalMemory() / 0x100000L);
        System.out.println("Free memory:    " + Runtime.getRuntime().freeMemory() / 0x100000L);
    }

    public static String replaceProperties(String value, Map keys) {
        if (value == null) {
            return null;
        }
        ArrayList fragments = new ArrayList();
        ArrayList propertyRefs = new ArrayList();
        XJavaDoc.parsePropertyString(value, fragments, propertyRefs);
        StringBuffer sbuf = new StringBuffer();
        Iterator i = fragments.iterator();
        Iterator j = propertyRefs.iterator();
        while (i.hasNext()) {
            String fragment = (String)i.next();
            if (fragment == null) {
                String propertyName = (String)j.next();
                fragment = keys.containsKey(propertyName) ? (String)keys.get(propertyName) : "${" + propertyName + '}';
            }
            sbuf.append(fragment);
        }
        return sbuf.toString();
    }

    public static void parsePropertyString(String value, List fragments, List propertyRefs) {
        String fragment;
        int pos;
        int prev = 0;
        while ((pos = value.indexOf(36, prev)) >= 0) {
            if (pos > 0) {
                fragment = value.substring(prev, pos);
                fragments.add(fragment);
            }
            if (pos == value.length() - 1) {
                fragments.add("$");
                prev = pos + 1;
                continue;
            }
            if (value.charAt(pos + 1) != '{') {
                fragments.add(value.substring(pos, pos + 1));
                prev = pos + 1;
                continue;
            }
            int endName = value.indexOf(125, pos);
            if (endName < 0) {
                String fragment2 = value.substring(pos);
                fragments.add(fragment2);
                continue;
            }
            String propertyName = value.substring(pos + 2, endName);
            fragments.add(null);
            propertyRefs.add(propertyName);
            prev = endName + 1;
        }
        if (prev < value.length()) {
            fragment = value.substring(prev);
            fragments.add(fragment);
        }
    }

    static Primitive getPrimitive(String name) {
        return (Primitive)_primitiveClasses.get(name);
    }

    static AbstractFile getSourceFileFor(XProgramElement pe) {
        SourceClass containingClass = null;
        containingClass = !(pe instanceof SourceClass) ? (SourceClass)pe.getContainingClass() : (SourceClass)pe;
        while (containingClass.getContainingClass() != null) {
            containingClass = (SourceClass)containingClass.getContainingClass();
        }
        return containingClass.getFile();
    }

    private final void addPrimitive(String name, String type) {
        _primitiveClasses.put(name, new Primitive(this, name, type));
    }

    public Collection getSourceClasses(Predicate predicate) {
        return CollectionUtils.select((Collection)this.getSourceClasses(), (Predicate)predicate);
    }

    public Collection getSourceClasses() {
        if (this._sourceSetSourceClassesWithInnerClasses.isEmpty()) {
            this._sourceSetSourceClassesWithInnerClasses.addAll(this.getOuterSourceClasses());
            Iterator outers = this.getOuterSourceClasses().iterator();
            while (outers.hasNext()) {
                this.addInnerClassRecursive((XClass)outers.next(), this._sourceSetSourceClassesWithInnerClasses);
            }
        }
        return Collections.unmodifiableCollection(this._sourceSetSourceClassesWithInnerClasses);
    }

    public Collection getSourcePackages() {
        TreeSet<XPackage> packages = new TreeSet<XPackage>();
        Collection classes = this.getSourceClasses();
        Iterator i = classes.iterator();
        while (i.hasNext()) {
            packages.add(((XClass)i.next()).getContainingPackage());
        }
        return Collections.unmodifiableCollection(packages);
    }

    public Map getPropertyMap() {
        return Collections.unmodifiableMap(this._properties);
    }

    public XClass getXClass(String qualifiedName) {
        if (qualifiedName.equals("")) {
            throw new IllegalStateException("Classname can't be empty String");
        }
        AbstractClass result = null;
        Primitive primitive = XJavaDoc.getPrimitive(qualifiedName);
        if (primitive != null) {
            result = primitive;
        } else {
            SourceClass sourceClass = (SourceClass)this._allSourceClasses.get(qualifiedName);
            if (sourceClass != null) {
                result = sourceClass;
            } else {
                BinaryClass binaryClass = (BinaryClass)this._binaryClasses.get(qualifiedName);
                if (binaryClass != null) {
                    result = binaryClass;
                } else {
                    UnknownClass unknownClass = (UnknownClass)this._unknownClasses.get(qualifiedName);
                    if (unknownClass != null) {
                        result = unknownClass;
                    } else if (this.sourceExists(qualifiedName)) {
                        sourceClass = this.scanAndPut(qualifiedName);
                        result = sourceClass;
                    } else {
                        Class clazz = this.getClass(qualifiedName);
                        if (clazz != null) {
                            binaryClass = new BinaryClass(this, clazz);
                            this._binaryClasses.put(qualifiedName, binaryClass);
                            result = binaryClass;
                        } else {
                            result = new UnknownClass(this, qualifiedName);
                            this._unknownClasses.put(qualifiedName, result);
                        }
                    }
                }
            }
        }
        return result;
    }

    public XPackage getSourcePackage(String packageName) {
        for (XPackage p : this.getSourcePackages()) {
            if (!p.getName().equals(packageName)) continue;
            return p;
        }
        return null;
    }

    public void setUseNodeParser(boolean useNodeParser) {
        this._useNodeParser = useNodeParser;
    }

    public void setPropertyMap(Map properties) {
        this._properties.putAll(properties);
    }

    public void reset(boolean resetTimeStamp) {
        for (XPackage xPackage : this._packages.values()) {
            for (AbstractClass clazz : xPackage.getClasses()) {
                clazz.reset();
            }
        }
        this._binaryClasses.clear();
        this._unknownClasses.clear();
        this._packages.clear();
        this._sourceSets.clear();
        this._sourceSetSourceClasses.clear();
        this._sourceSetClassNames.clear();
        this._allSourceClasses.clear();
        this._sourceSetSourceClassesWithInnerClasses.clear();
        this._logMessages.clear();
        this._properties.clear();
        this._abstractFileClasses.clear();
        if (resetTimeStamp) {
            this._birthday = System.currentTimeMillis();
        }
    }

    public void printLogMessages(PrintStream out, int level) {
        boolean printedHeader = false;
        for (LogMessage m : this._logMessages) {
            if (m._level != level) continue;
            if (!printedHeader) {
                if (level == 1) {
                    out.println("WARNING: Some classes refer to other classes that were not found among the sources or on the classpath.");
                    out.println("         (Perhaps the referred class doesn't exist? Hasn't been generated yet?)");
                    out.println("         The referring classes do not import any fully qualified classes matching these classes.");
                    out.println("         Since at least one package is imported, it is impossible for xjavadoc to figure out");
                    out.println("         what package the referred classes belong to. The classes are:");
                } else {
                    out.println("INFO:    Some classes refer to other classes that were not found among the sources or on the classpath.");
                    out.println("         (Perhaps the referred class doesn't exist? Hasn't been generated yet?)");
                    out.println("         The referring classes do not import any fully qualified classes matching these classes.");
                    out.println("         However, since no packages are imported, xjavadoc has assumed that the referred classes");
                    out.println("         belong to the same package as the referring class. The classes are:");
                }
                printedHeader = true;
            }
            out.println(m._sourceClass.getFile().getPath() + " --> " + m._unqualifiedClassName + " qualified to " + m._unknownClass.getQualifiedName());
        }
    }

    public void addSourceSet(SourceSet sourceSet) {
        this._sourceSets.add(sourceSet);
        for (int j = 0; j < sourceSet.getSize(); ++j) {
            String qualifiedName = sourceSet.getQualifiedName(j);
            if (this._sourceSetClassNames.contains(qualifiedName)) {
                String msg = "The class \"" + qualifiedName + "\" occurs in more than one fileset. That's illegal.";
                System.err.println(msg);
            }
            this._sourceSetClassNames.add(qualifiedName);
        }
    }

    public void addAbstractFile(String qualifiedName, AbstractFile file) {
        this._abstractFileClasses.put(qualifiedName, file);
        if (this._sourceSetClassNames.contains(qualifiedName)) {
            String msg = "The class \"" + qualifiedName + "\" occurs in more than one fileset. That's illegal.";
            System.err.println(msg);
        }
        this._sourceSetClassNames.add(qualifiedName);
    }

    public XClass updateMethodTag(String className, String methodNameWithSignature, String tagName, String parameterName, String parameterValue, int tagIndex) throws XJavaDocException {
        XClass clazz = this.getXClass(className);
        XMethod method = clazz.getMethod(methodNameWithSignature);
        XDoc doc = method.getDoc();
        doc.updateTagValue(tagName, parameterName, parameterValue, tagIndex);
        return clazz;
    }

    public XClass updateClassTag(String className, String tagName, String parameterName, String parameterValue, int tagIndex) throws XJavaDocException {
        XClass clazz = this.getXClass(className);
        XDoc doc = clazz.getDoc();
        doc.updateTagValue(tagName, parameterName, parameterValue, tagIndex);
        return clazz;
    }

    public String dereferenceProperties(String value) {
        return XJavaDoc.replaceProperties(value, this._properties);
    }

    final boolean classExists(String qualifiedClassName) {
        if (this.sourceExists(qualifiedClassName)) {
            return true;
        }
        return this.getClass(qualifiedClassName) != null;
    }

    void logMessage(SourceClass clazz, UnknownClass unknownClass, String unqualifiedClassName, int level) {
        this._logMessages.add(new LogMessage(clazz, unknownClass, unqualifiedClassName, level));
    }

    XPackage addPackageMaybe(String packageName) {
        XPackage result = (XPackage)this._packages.get(packageName);
        if (result == null) {
            result = new XPackage(packageName);
            this._packages.put(packageName, result);
        }
        return result;
    }

    void addSourceClass(SourceClass sourceClass) {
        this._allSourceClasses.put(sourceClass.getQualifiedName(), sourceClass);
        if (this._sourceSetClassNames.contains(sourceClass.getQualifiedName()) || sourceClass.isExtraClass()) {
            this._sourceSetSourceClasses.put(sourceClass.getQualifiedName(), sourceClass);
        }
    }

    private final Class getClass(String qualifiedName) {
        try {
            return Class.forName(qualifiedName, false, this.getClass().getClassLoader());
        }
        catch (Throwable e) {
            return null;
        }
    }

    private Collection getOuterSourceClasses() {
        if (this._sourceSetSourceClasses.isEmpty()) {
            for (String qualifiedName : this._sourceSetClassNames) {
                this.getXClass(qualifiedName);
            }
            for (String fqcn : this._abstractFileClasses.keySet()) {
                this.getXClass(fqcn);
            }
        }
        ArrayList new_collection = new ArrayList(this._sourceSetSourceClasses.values());
        return Collections.unmodifiableCollection(new_collection);
    }

    private AbstractFile getSourceFile(String qualifiedName) {
        AbstractFile found = null;
        for (SourceSet sourceSet : this._sourceSets) {
            AbstractFile javaFile = sourceSet.getSourceFile(qualifiedName);
            if (javaFile == null) continue;
            found = javaFile;
        }
        return found;
    }

    private void addInnerClassRecursive(XClass outer, Collection c) {
        for (XClass inner : outer.getInnerClasses()) {
            c.add(inner);
            this.addInnerClassRecursive(inner, c);
        }
    }

    private boolean sourceExists(String qualifiedName) {
        boolean sourceFileExists;
        AbstractFile sourceFile = this.getSourceFile(qualifiedName);
        if (sourceFile != null && sourceFile.lastModified() > this._birthday) {
            System.out.println("XJavaDoc Ignoring class " + qualifiedName + " in " + sourceFile.getPath() + ". It was generated (" + new Date(sourceFile.lastModified()) + ") after XJavaDoc's timestamp was reset (" + new Date(this._birthday) + ")");
            return false;
        }
        boolean bl = sourceFileExists = sourceFile != null;
        if (!sourceFileExists) {
            sourceFileExists = this._abstractFileClasses.containsKey(qualifiedName);
        }
        return sourceFileExists;
    }

    private SourceClass scanAndPut(String qualifiedName) {
        AbstractFile sourceFile = this.getSourceFile(qualifiedName);
        AbstractFile abstractFile = sourceFile = sourceFile != null ? sourceFile : (AbstractFile)this._abstractFileClasses.get(qualifiedName);
        if (sourceFile == null) {
            throw new IllegalStateException("No source found for " + qualifiedName);
        }
        SourceClass sourceClass = new SourceClass(this, sourceFile, this._useNodeParser, this._tagFactory, this._encoding);
        if (this._tagFactory.isValidating()) {
            sourceClass.validateTags();
        }
        return sourceClass;
    }

    public XTagFactory getTagFactory() {
        return this._tagFactory;
    }

    public void registerTags(String classpath) {
        new TagIntrospector().registerTags(classpath, this.getTagFactory());
    }

    public String getEncoding() {
        return this._encoding;
    }

    public void setEncoding(String encoding) {
        this._encoding = encoding;
    }

    public String getDocEncoding() {
        return this._docEncoding;
    }

    public void setDocEncoding(String docencoding) {
        this._docEncoding = docencoding;
    }

    class LogMessage {
        public final SourceClass _sourceClass;
        public final UnknownClass _unknownClass;
        public final String _unqualifiedClassName;
        public final int _level;

        LogMessage(SourceClass sourceClass, UnknownClass unknownClass, String unqualifiedClassName, int level) {
            this._sourceClass = sourceClass;
            this._unknownClass = unknownClass;
            this._unqualifiedClassName = unqualifiedClassName;
            this._level = level;
        }
    }

    public static final class NoInnerClassesPredicate
    implements Predicate {
        public boolean evaluate(Object o) {
            XClass clazz = (XClass)o;
            return !clazz.isInner();
        }
    }
}

