/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.extensions.addressing.jaxws;

import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import javax.xml.ws.addressing.AddressingBuilder;
import javax.xml.ws.addressing.AddressingException;
import javax.xml.ws.addressing.soap.SOAPAddressingBuilder;
import javax.xml.ws.addressing.soap.SOAPAddressingProperties;
import javax.xml.ws.handler.MessageContext;
import javax.xml.ws.handler.soap.SOAPMessageContext;
import javax.xml.ws.soap.AddressingFeature;
import org.jboss.logging.Logger;
import org.jboss.ws.core.CommonMessageContext;
import org.jboss.ws.extensions.addressing.AddressingClientUtil;
import org.jboss.ws.extensions.addressing.AddressingConstantsImpl;
import org.jboss.ws.extensions.addressing.soap.SOAPAddressingPropertiesImpl;
import org.jboss.ws.metadata.umdm.ClientEndpointMetaData;
import org.jboss.ws.metadata.umdm.OperationMetaData;
import org.jboss.wsf.common.handler.GenericSOAPHandler;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSAddressingClientHandler
extends GenericSOAPHandler {
    private static Logger log = Logger.getLogger(WSAddressingClientHandler.class);
    private static AddressingBuilder ADDR_BUILDER;
    private static AddressingConstantsImpl ADDR_CONSTANTS;
    private static Set<QName> HEADERS;

    public Set getHeaders() {
        return Collections.unmodifiableSet(HEADERS);
    }

    protected boolean handleOutbound(MessageContext msgContext) {
        log.debug((Object)"handleOutbound");
        SOAPAddressingProperties addrProps = (SOAPAddressingProperties)msgContext.get((Object)"javax.xml.ws.addressing.context");
        if (addrProps != null) {
            msgContext.put((Object)"javax.xml.ws.addressing.context.outbound", (Object)addrProps);
            msgContext.setScope("javax.xml.ws.addressing.context.outbound", MessageContext.Scope.APPLICATION);
        }
        if ((addrProps = (SOAPAddressingProperties)msgContext.get((Object)"javax.xml.ws.addressing.context.outbound")) == null) {
            addrProps = (SOAPAddressingPropertiesImpl)ADDR_BUILDER.newAddressingProperties();
            msgContext.put((Object)"javax.xml.ws.addressing.context.outbound", (Object)addrProps);
            msgContext.setScope("javax.xml.ws.addressing.context.outbound", MessageContext.Scope.APPLICATION);
        }
        if (addrProps.getAction() == null) {
            try {
                OperationMetaData opMetaData = ((CommonMessageContext)msgContext).getOperationMetaData();
                if (msgContext.get((Object)"javax.xml.ws.soap.http.soapaction.uri") != null) {
                    addrProps.setAction(ADDR_BUILDER.newURI(msgContext.get((Object)"javax.xml.ws.soap.http.soapaction.uri").toString()));
                } else {
                    addrProps.setAction(ADDR_BUILDER.newURI(opMetaData.getJavaName()));
                }
            }
            catch (URISyntaxException ex) {
                // empty catch block
            }
        }
        if (addrProps.getMessageID() == null) {
            addrProps.setMessageID(AddressingClientUtil.createMessageID());
        }
        SOAPMessage soapMessage = ((SOAPMessageContext)msgContext).getMessage();
        addrProps.writeHeaders(soapMessage);
        return true;
    }

    protected boolean handleInbound(MessageContext msgContext) {
        block5: {
            log.debug((Object)"handleInbound");
            try {
                SOAPMessage soapMessage = ((SOAPMessageContext)msgContext).getMessage();
                if (soapMessage.getSOAPPart().getEnvelope() == null) break block5;
                SOAPAddressingBuilder builder = (SOAPAddressingBuilder)SOAPAddressingBuilder.getAddressingBuilder();
                SOAPAddressingProperties addrProps = (SOAPAddressingProperties)builder.newAddressingProperties();
                CommonMessageContext commonMsgContext = (CommonMessageContext)msgContext;
                ClientEndpointMetaData serverMetaData = (ClientEndpointMetaData)commonMsgContext.getEndpointMetaData();
                AddressingFeature addrFeature = serverMetaData.getFeature(AddressingFeature.class);
                if (addrFeature != null && addrFeature.isRequired()) {
                    try {
                        soapMessage.setProperty("isRequired", (Object)true);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                addrProps.readHeaders(soapMessage);
                msgContext.put((Object)"javax.xml.ws.addressing.context", (Object)addrProps);
                msgContext.setScope("javax.xml.ws.addressing.context", MessageContext.Scope.APPLICATION);
                msgContext.put((Object)"javax.xml.ws.addressing.context.inbound", (Object)addrProps);
                msgContext.setScope("javax.xml.ws.addressing.context.inbound", MessageContext.Scope.APPLICATION);
                msgContext.put((Object)"javax.xml.ws.reference.parameters", WSAddressingClientHandler.convertToElementList(addrProps.getReferenceParameters().getElements()));
                msgContext.setScope("javax.xml.ws.reference.parameters", MessageContext.Scope.APPLICATION);
            }
            catch (SOAPException ex) {
                throw new AddressingException("Cannot handle response", (Throwable)ex);
            }
        }
        return true;
    }

    private static List<Element> convertToElementList(List<Object> objects) {
        if (objects == null) {
            return null;
        }
        LinkedList<Element> elements = new LinkedList<Element>();
        for (Object o : objects) {
            if (!(o instanceof Element)) continue;
            elements.add((Element)o);
        }
        return elements;
    }

    static {
        HEADERS = new HashSet<QName>();
        ADDR_CONSTANTS = new AddressingConstantsImpl();
        ADDR_BUILDER = AddressingBuilder.getAddressingBuilder();
        HEADERS.add(ADDR_CONSTANTS.getActionQName());
        HEADERS.add(ADDR_CONSTANTS.getToQName());
    }
}

