/*
 * Decompiled with CFR 0.152.
 */
package org.easymock.internal;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.easymock.ArgumentsMatcher;
import org.easymock.MockControl;
import org.easymock.internal.MethodSerializationWrapper;
import org.easymock.internal.RuntimeExceptionWrapper;

public class LegacyMatcherProvider
implements Serializable {
    private static final long serialVersionUID = -4143082656571251917L;
    private ArgumentsMatcher defaultMatcher;
    private boolean defaultMatcherSet;
    private transient Map<Method, ArgumentsMatcher> matchers = new HashMap<Method, ArgumentsMatcher>();

    public ArgumentsMatcher getMatcher(Method method) {
        if (!this.matchers.containsKey(method)) {
            if (!this.defaultMatcherSet) {
                this.setDefaultMatcher(MockControl.EQUALS_MATCHER);
            }
            this.matchers.put(method, this.defaultMatcher);
        }
        return this.matchers.get(method);
    }

    public void setDefaultMatcher(ArgumentsMatcher matcher) {
        if (this.defaultMatcherSet) {
            throw new RuntimeExceptionWrapper(new IllegalStateException("default matcher can only be set once directly after creation of the MockControl"));
        }
        this.defaultMatcher = matcher;
        this.defaultMatcherSet = true;
    }

    public void setMatcher(Method method, ArgumentsMatcher matcher) {
        if (this.matchers.containsKey(method) && this.matchers.get(method) != matcher) {
            throw new RuntimeExceptionWrapper(new IllegalStateException("for method " + method.getName() + "(" + (method.getParameterTypes().length == 0 ? "" : "...") + "), a matcher has already been set"));
        }
        this.matchers.put(method, matcher);
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        Map map = (Map)stream.readObject();
        this.matchers = new HashMap<Method, ArgumentsMatcher>(map.size());
        for (Map.Entry entry : map.entrySet()) {
            try {
                Method method = ((MethodSerializationWrapper)entry.getKey()).getMethod();
                this.matchers.put(method, (ArgumentsMatcher)entry.getValue());
            }
            catch (NoSuchMethodException e) {
                throw new IOException(e.toString());
            }
        }
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
        HashMap<MethodSerializationWrapper, ArgumentsMatcher> map = new HashMap<MethodSerializationWrapper, ArgumentsMatcher>(this.matchers.size());
        for (Map.Entry<Method, ArgumentsMatcher> matcher : this.matchers.entrySet()) {
            map.put(new MethodSerializationWrapper(matcher.getKey()), matcher.getValue());
        }
        stream.writeObject(map);
    }
}

