/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.jbossas5;

import java.util.HashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.managed.api.ManagedProperty;
import org.jboss.metatype.api.values.SimpleValue;
import org.rhq.core.domain.measurement.MeasurementDataTrait;
import org.rhq.core.domain.measurement.MeasurementReport;
import org.rhq.core.domain.measurement.MeasurementScheduleRequest;
import org.rhq.plugins.jbossas5.ManagedComponentComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TxConnectionFactoryComponent
extends ManagedComponentComponent {
    private final Log log = LogFactory.getLog(this.getClass());

    @Override
    public void getValues(MeasurementReport report, Set<MeasurementScheduleRequest> metrics) throws Exception {
        HashSet<MeasurementScheduleRequest> uncollectedMetrics = new HashSet<MeasurementScheduleRequest>();
        for (MeasurementScheduleRequest request : metrics) {
            try {
                if (request.getName().equals("custom.transactionType")) {
                    ManagedProperty xaTransactionProp = this.getManagedComponent().getProperty("xa-transaction");
                    SimpleValue xaTransactionMetaValue = (SimpleValue)xaTransactionProp.getValue();
                    Boolean xaTransactionValue = xaTransactionMetaValue != null ? (Boolean)xaTransactionMetaValue.getValue() : null;
                    boolean isXa = xaTransactionValue != null && xaTransactionValue != false;
                    String transactionType = isXa ? "XA" : "Local";
                    report.addData(new MeasurementDataTrait(request, transactionType));
                    continue;
                }
                uncollectedMetrics.add(request);
            }
            catch (Exception e) {
                this.log.error((Object)("Failed to collect metric for " + request), (Throwable)e);
            }
        }
        super.getValues(report, uncollectedMetrics);
    }
}

