/*
 * Decompiled with CFR 0.152.
 */
package com.meterware.httpunit.scripting;

import com.meterware.httpunit.HTMLElement;
import com.meterware.httpunit.scripting.ScriptingEngine;

public abstract class ScriptableDelegate {
    private ScriptingEngine _scriptEngine;
    private static final ScriptingEngine NULL_SCRIPT_ENGINE = new ScriptingEngine(){

        @Override
        public boolean supportsScriptLanguage(String language) {
            return false;
        }

        @Override
        public String executeScript(String language, String script) {
            return "";
        }

        @Override
        public boolean performEvent(String eventScript) {
            return true;
        }

        @Override
        public String evaluateScriptExpression(String urlString) {
            return null;
        }

        @Override
        public ScriptingEngine newScriptingEngine(ScriptableDelegate child) {
            return this;
        }

        @Override
        public void clearCaches() {
        }
    };

    public boolean supportsScript(String language) {
        return this.getScriptEngine().supportsScriptLanguage(language);
    }

    public boolean doEvent(String eventScript) {
        if (eventScript.length() == 0) {
            return true;
        }
        return this.getScriptEngine().performEvent(eventScript);
    }

    public String runScript(String language, String script) {
        return script.length() == 0 ? "" : this.getScriptEngine().executeScript(language, script);
    }

    public String evaluateExpression(String urlString) {
        if (urlString.length() == 0) {
            return null;
        }
        return this.getScriptEngine().evaluateScriptExpression(urlString);
    }

    public Object get(String propertyName) {
        return null;
    }

    public Object get(int index) {
        return null;
    }

    public void set(String propertyName, Object value) {
        throw new RuntimeException("No such property: " + propertyName);
    }

    public void setScriptEngine(ScriptingEngine scriptEngine) {
        this._scriptEngine = scriptEngine;
    }

    public ScriptingEngine getScriptEngine() {
        return this._scriptEngine != null ? this._scriptEngine : NULL_SCRIPT_ENGINE;
    }

    public ScriptingEngine getScriptEngine(ScriptableDelegate child) {
        return this.getScriptEngine().newScriptingEngine(child);
    }

    protected ScriptableDelegate[] getDelegates(HTMLElement[] elements) {
        ScriptableDelegate[] result = new ScriptableDelegate[elements.length];
        for (int i = 0; i < elements.length; ++i) {
            result[i] = elements[i].getScriptableDelegate();
        }
        return result;
    }
}

