/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.buildmagic.task;

import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.jboss.tools.buildmagic.task.util.TaskLogger;

public class ResolveProperties
extends Task {
    protected final TaskLogger log = new TaskLogger(this);
    protected boolean force;

    public void setForce(boolean force) {
        this.force = force;
    }

    public void execute() throws BuildException {
        this.log.verbose("Resolving all properties");
        if (this.force) {
            this.log.verbose("Unset properties will be forced resolve");
        }
        Hashtable props = this.getProject().getProperties();
        Iterator iter = props.keySet().iterator();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            String value = (String)props.get(key);
            this.log.debug("property: " + key);
            this.log.debug("  before: " + value);
            value = ResolveProperties.subst(value, props, this.force);
            this.log.debug("   after: " + value);
            props.put(key, value);
        }
    }

    public static String subst(String expression, Map props, boolean force) throws BuildException {
        int pos;
        StringBuffer buff = new StringBuffer();
        HashSet<String> occured = new HashSet<String>(10);
        int prev = 0;
        while ((pos = expression.indexOf("$", prev)) >= 0) {
            if (pos > 0) {
                buff.append(expression.substring(prev, pos));
            }
            if (pos == expression.length() - 1) {
                buff.append('$');
                prev = pos + 1;
                continue;
            }
            if (expression.charAt(pos + 1) != '{') {
                buff.append(expression.charAt(pos + 1));
                prev = pos + 2;
                continue;
            }
            int endName = expression.indexOf(125, pos);
            if (endName < 0) {
                throw new BuildException("Syntax error in prop: " + expression);
            }
            String n = expression.substring(pos + 2, endName);
            String v = null;
            if (!occured.contains(n)) {
                occured.add(n);
                if (props.containsKey(n)) {
                    v = (String)props.get(n);
                    v = ResolveProperties.subst(v, props, force);
                }
                occured.remove(n);
            }
            if (v == null && !force) {
                v = "${" + n + "}";
            }
            if (v != null) {
                buff.append(v);
            }
            prev = endName + 1;
        }
        if (prev < expression.length()) {
            buff.append(expression.substring(prev));
        }
        return buff.toString();
    }

    public static String subst(String value, Project project, boolean force) {
        return ResolveProperties.subst(value, project.getProperties(), force);
    }

    public static String subst(String value, Project project) {
        return ResolveProperties.subst(value, project.getProperties(), false);
    }
}

