/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type;

import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Comparator;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.type.DiscriminatorType;
import org.hibernate.type.PrimitiveType;
import org.hibernate.type.VersionType;
import org.hibernate.util.ComparableComparator;

public class ShortType
extends PrimitiveType
implements DiscriminatorType,
VersionType {
    private static final Short ZERO = new Short(0);

    @Override
    public Serializable getDefaultValue() {
        return ZERO;
    }

    @Override
    public Object get(ResultSet rs, String name) throws SQLException {
        return new Short(rs.getShort(name));
    }

    @Override
    public Class getPrimitiveClass() {
        return Short.TYPE;
    }

    @Override
    public Class getReturnedClass() {
        return Short.class;
    }

    @Override
    public void set(PreparedStatement st, Object value, int index) throws SQLException {
        st.setShort(index, (Short)value);
    }

    @Override
    public int sqlType() {
        return 5;
    }

    @Override
    public String getName() {
        return "short";
    }

    @Override
    public String objectToSQLString(Object value, Dialect dialect) throws Exception {
        return value.toString();
    }

    @Override
    public Object stringToObject(String xml) throws Exception {
        return new Short(xml);
    }

    @Override
    public Object next(Object current, SessionImplementor session) {
        return new Short((short)((Short)current + 1));
    }

    @Override
    public Object seed(SessionImplementor session) {
        return ZERO;
    }

    @Override
    public Comparator getComparator() {
        return ComparableComparator.INSTANCE;
    }

    @Override
    public Object fromStringValue(String xml) {
        return new Short(xml);
    }
}

