/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.extensions.validation;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.namespace.QName;
import org.jboss.logging.Logger;
import org.jboss.wsf.common.DOMUtils;
import org.jboss.wsf.common.DOMWriter;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SchemaExtractor {
    private static Logger log = Logger.getLogger(SchemaExtractor.class);
    private File xsdFile;
    private String path;

    public InputStream[] getSchemas(URL wsdlURL) throws IOException {
        Pattern p = Pattern.compile("[a-zA-Z]+\\.[a-zA-Z]+$");
        Matcher m = p.matcher(wsdlURL.getFile());
        this.path = m.replaceFirst("");
        Element root = DOMUtils.parse((InputStream)wsdlURL.openStream());
        List<Attr> nsAttrs = this.getNamespaceAttrs(root);
        QName typesQName = new QName(root.getNamespaceURI(), "types");
        Element typesEl = DOMUtils.getFirstChildElement((Node)root, (QName)typesQName);
        if (typesEl == null) {
            log.warn((Object)("Cannot find element: " + typesQName));
            return null;
        }
        QName schemaQName = new QName("http://www.w3.org/2001/XMLSchema", "schema");
        List schemaElements = DOMUtils.getChildElementsAsList((Node)typesEl, (QName)schemaQName);
        if (schemaElements.size() == 0) {
            log.warn((Object)("Cannot find element: " + schemaQName));
            return null;
        }
        if (schemaElements.size() > 1) {
            log.warn((Object)"Multiple schema elements not supported.");
        }
        Element schemaElement = (Element)schemaElements.get(0);
        for (Attr nsAttr : nsAttrs) {
            Attr replacedAttr = schemaElement.setAttributeNodeNS(nsAttr);
            if (replacedAttr == null) continue;
            schemaElement.setAttributeNodeNS(replacedAttr);
        }
        ArrayList<InputStream> streams = new ArrayList<InputStream>();
        this.pullImportedSchemas(schemaElement, streams);
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        OutputStreamWriter outwr = new OutputStreamWriter(outStream);
        DOMWriter domWriter = new DOMWriter((Writer)outwr);
        domWriter.setPrettyprint(true);
        domWriter.print((Node)schemaElement);
        streams.add(new ByteArrayInputStream(outStream.toByteArray()));
        return streams.toArray(new InputStream[streams.size()]);
    }

    private List<Attr> getNamespaceAttrs(Element element) {
        ArrayList<Attr> nsAttrs = new ArrayList<Attr>();
        NamedNodeMap nodes = element.getAttributes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            Attr attr = (Attr)node;
            if (!attr.getName().startsWith("xmlns")) continue;
            nsAttrs.add((Attr)attr.cloneNode(true));
        }
        return nsAttrs;
    }

    private void pullImportedSchemas(Element schemaElement, List<InputStream> streams) {
        String schemaLocation;
        QName importQName = new QName("http://www.w3.org/2001/XMLSchema", "import");
        List importElements = DOMUtils.getChildElementsAsList((Node)schemaElement, (QName)importQName);
        ArrayList<String> schemaLocations = new ArrayList<String>();
        for (Element importElement : importElements) {
            schemaLocation = importElement.getAttribute("schemaLocation");
            schemaLocations.add(schemaLocation);
        }
        ByteArrayOutputStream outStream = null;
        for (int i = 0; i < schemaLocations.size(); ++i) {
            schemaLocation = (String)schemaLocations.get(i);
            try {
                FileInputStream in = new FileInputStream(this.path + schemaLocation);
                outStream = new ByteArrayOutputStream();
                int bt = 0;
                while ((bt = in.read()) != -1) {
                    outStream.write((byte)bt);
                }
                ByteArrayInputStream inputStream = new ByteArrayInputStream(outStream.toByteArray());
                ((InputStream)inputStream).mark(0);
                Element root = DOMUtils.parse((InputStream)inputStream);
                this.pullImportedSchemas(root, streams);
                ((InputStream)inputStream).reset();
                streams.add(inputStream);
                continue;
            }
            catch (IOException ioe) {
                log.warn((Object)("Error obtaining schema: " + this.path + schemaLocation));
            }
        }
    }
}

