/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.clientapi.util.units;

import java.math.BigDecimal;
import org.rhq.core.clientapi.util.units.ScaleConstants;
import org.rhq.core.clientapi.util.units.UnitsConstants;
import org.rhq.core.clientapi.util.units.UnitsFormat;
import org.rhq.core.clientapi.util.units.UnitsUtil;

public class UnitNumber {
    private double value;
    private UnitsConstants units;
    private ScaleConstants scale;

    public UnitNumber(double value, UnitsConstants units) {
        this(value, units, ScaleConstants.SCALE_NONE);
    }

    public UnitNumber(double value, UnitsConstants units, ScaleConstants scale) {
        this.value = value;
        this.units = units;
        this.scale = scale;
        UnitsUtil.checkValidScaleForUnits(units, scale);
    }

    public double getValue() {
        return this.value;
    }

    public UnitsConstants getUnits() {
        return this.units;
    }

    public ScaleConstants getScale() {
        return this.scale;
    }

    public BigDecimal getBaseValue() {
        return UnitsFormat.getBaseValue(this.value, this.units, this.scale);
    }

    public BigDecimal getScaledValue(ScaleConstants targScale) {
        return UnitsFormat.getScaledValue(this.getBaseValue(), this.units, targScale);
    }

    public String toString() {
        return Double.toString(this.value);
    }
}

