/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting.samples.transporter.complex;

import org.jboss.remoting.samples.transporter.complex.Doctor;
import org.jboss.remoting.samples.transporter.complex.Information;
import org.jboss.remoting.samples.transporter.complex.NoDoctorAvailableException;
import org.jboss.remoting.samples.transporter.complex.Patient;
import org.jboss.remoting.samples.transporter.complex.ProviderInterface;

public class ProviderInterfaceImpl
implements ProviderInterface {
    @Override
    public Doctor findDoctor(Patient patient) throws NoDoctorAvailableException {
        String ailmentType = patient.getAilmentType();
        Information info = Information.getInstance();
        Doctor doc = info.getProviderBySpecialty(ailmentType);
        if (doc != null) {
            doc.addPatient(patient);
            return doc;
        }
        throw new NoDoctorAvailableException("No doctor available for ailment '" + ailmentType + "'");
    }

    @Override
    public void retireDoctor(Doctor doctor) {
        Information info = Information.getInstance();
        info.retireDoctor(doctor);
    }
}

