/*
* JBoss, Home of Professional Open Source.
* Copyright 2006, Red Hat Middleware LLC, and individual contributors
* as indicated by the @author tags. See the copyright.txt file in the
* distribution for a full listing of individual contributors. 
*
* This is free software; you can redistribute it and/or modify it
* under the terms of the GNU Lesser General Public License as
* published by the Free Software Foundation; either version 2.1 of
* the License, or (at your option) any later version.
*
* This software is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this software; if not, write to the Free
* Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
* 02110-1301 USA, or see the FSF site: http://www.fsf.org.
*/ 
package org.jboss.test.aop.test;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

import javax.management.ObjectName;

import junit.framework.Test;
import junit.framework.TestSuite;

import org.jboss.test.JBossTestCase;

/**
 * Test to see if things get deployed/undeployed correctly using the new deployers 
 * 
 * @author <a href="kabir.khan@jboss.com">Kabir Khan</a>
 * @version $Revision: 85945 $
 */
public class DeployersInitialTestCase extends JBossTestCase
{
   final static ObjectName DEPLOYER_MONITOR;
   static
   {
      try
      {
         DEPLOYER_MONITOR = new ObjectName("jboss.aop:service=DeployerMonitor");
      }
      catch (Exception e)
      {
         // AutoGenerated
         throw new RuntimeException(e);
      }
   }

   public DeployersInitialTestCase(String name)
   {
      super(name);
   }
   
   public void testAddXMLBindings() throws Exception
   {
      Map<String, String> initialBindings = (Map<String, String>)getServer().getAttribute(DEPLOYER_MONITOR, "CurrentBindings");
      Map<String, String> initialDefinitiona = (Map<String, String>)getServer().getAttribute(DEPLOYER_MONITOR, "CurrentAspectDefinitions");
      
      try
      {
         deploy("aop-deployertest-xml.aop");

         Map<String, String> deployedBindings = (Map<String, String>)getServer().getAttribute(DEPLOYER_MONITOR, "CurrentBindings");
         Map<String, String> deployedDefinitiona = (Map<String, String>)getServer().getAttribute(DEPLOYER_MONITOR, "CurrentAspectDefinitions");
         
         Map<String, String> newBindings = getInEndOnly(initialBindings, deployedBindings);
         assertEquals("Wrong number of new bindings", 2, newBindings.size());
         
         Map<String, String> newDefinitions = getInEndOnly(initialDefinitiona, deployedDefinitiona);
         assertEquals("Wrong number of new aspect definitions", 4, newDefinitions.size());
         
         HashSet<String> bindings = new HashSet<String>();
         bindings.addAll(newBindings.values());
         assertTrue("Could not find 'execution(* org.jboss.test.aop.deployers.xml.POJO->someMethod())'", bindings.remove("execution(* org.jboss.test.aop.deployers.xml.POJO->someMethod())"));
         assertTrue("Could not find 'execution(void org.jboss.test.aop.deployers.xml.POJO->someMethod())'", bindings.remove("execution(void org.jboss.test.aop.deployers.xml.POJO->someMethod())"));
         
         String name = "someinterceptor";
         String clazz = newDefinitions.get(name);
         assertNotNull("No clazz found for " + name, clazz);
         assertEquals("Wrong clazz for " + name, "org.jboss.test.aop.deployers.xml.SomeInterceptor", clazz);
         newDefinitions.remove(name);
         
         name = "someaspect";
         clazz = newDefinitions.get(name);
         assertNotNull("No clazz found for " + name, clazz);
         assertEquals("Wrong clazz for " + name, "org.jboss.test.aop.deployers.xml.SomeAspect", clazz);
         newDefinitions.remove(name);
         
         assertEquals(2, newDefinitions.size());
         
         HashSet<String> definitions = new HashSet<String>();
         definitions.addAll(newDefinitions.values());
         assertTrue("Could not find 'org.jboss.test.aop.deployers.xml.SomeInterceptor'", definitions.remove("org.jboss.test.aop.deployers.xml.SomeInterceptor"));
         assertTrue("Could not find 'org.jboss.test.aop.deployers.xml.SomeAspect'", definitions.remove("org.jboss.test.aop.deployers.xml.SomeAspect"));

         getServer().invoke(DEPLOYER_MONITOR, "invokeXmlPOJO", new Object[0], new String[0]);
         
      }
      catch(Exception e)
      {
         throw e;
      }
      finally
      {
         undeploy("aop-deployertest-xml.aop");
      }
      
      Map<String, String> finalBindings = (Map<String, String>)getServer().getAttribute(DEPLOYER_MONITOR, "CurrentBindings");
      Map<String, String> finalAspectDefinitiona = (Map<String, String>)getServer().getAttribute(DEPLOYER_MONITOR, "CurrentAspectDefinitions");
      
      compareSame(initialBindings, finalBindings);
      compareSame(initialDefinitiona, finalAspectDefinitiona);
   }
   
   public void testAddAnnotationBindings()  throws Exception
   {
      Map<String, String> initialBindings = (Map<String, String>)getServer().getAttribute(DEPLOYER_MONITOR, "CurrentBindings");
      Map<String, String> initialDefinitiona = (Map<String, String>)getServer().getAttribute(DEPLOYER_MONITOR, "CurrentAspectDefinitions");

      try
      {
         deploy("aop-deployertest-annotations.aop");
         Map<String, String> deployedBindings = (Map<String, String>)getServer().getAttribute(DEPLOYER_MONITOR, "CurrentBindings");
         Map<String, String> deployedDefinitiona = (Map<String, String>)getServer().getAttribute(DEPLOYER_MONITOR, "CurrentAspectDefinitions");
         
         Map<String, String> newBindings = getInEndOnly(initialBindings, deployedBindings);
         assertEquals("Wrong number of new bindings", 2, newBindings.size());
         
         Map<String, String> newDefinitions = getInEndOnly(initialDefinitiona, deployedDefinitiona);
         assertEquals("Wrong number of new aspect definitions", 2, newDefinitions.size());
         
         HashSet<String> bindings = new HashSet<String>();
         bindings.addAll(newBindings.values());
         assertTrue("Could not find 'execution(* org.jboss.test.aop.deployers.annotations.POJO->someMethod())'", bindings.remove("execution(* org.jboss.test.aop.deployers.annotations.POJO->someMethod())"));
         assertTrue("Could not find 'execution(void org.jboss.test.aop.deployers.annotations.POJO->someMethod())'", bindings.remove("execution(void org.jboss.test.aop.deployers.annotations.POJO->someMethod())"));

         HashSet<String> definitions = new HashSet<String>();
         definitions.addAll(newDefinitions.values());
         assertTrue("Could not find 'org.jboss.test.aop.deployers.annotations.SomeInterceptor'", definitions.remove("org.jboss.test.aop.deployers.annotations.SomeInterceptor"));
         assertTrue("Could not find 'org.jboss.test.aop.deployers.annotations.SomeAspect'", definitions.remove("org.jboss.test.aop.deployers.annotations.SomeAspect"));

         getServer().invoke(DEPLOYER_MONITOR, "invokeAnnotationPOJO", new Object[0], new String[0]);
      }
      catch(Exception e)
      {
         throw e;
      }
      finally
      {
         undeploy("aop-deployertest-annotations.aop");
      }
      
      Map<String, String> finalBindings = (Map<String, String>)getServer().getAttribute(DEPLOYER_MONITOR, "CurrentBindings");
      Map<String, String> finalAspectDefinitiona = (Map<String, String>)getServer().getAttribute(DEPLOYER_MONITOR, "CurrentAspectDefinitions");
      
      compareSame(initialBindings, finalBindings);
      compareSame(initialDefinitiona, finalAspectDefinitiona);
   }
   
   private static void compareSame(Map<String, String> initial, Map<String, String> end) throws Exception
   {
      assertEquals("Length was not same", initial.size(), end.size());
      
      for (String key : end.keySet())
      {
         String initialValue = initial.get(key);
         assertNotNull("Value for " + key + " was null", initialValue);
         assertEquals("Values should be the same", initialValue, end.get(key));
      }
   }
   
   private static Map<String, String> getInEndOnly(Map<String, String> initial, Map<String, String> end) throws Exception
   {
      HashMap<String, String> endOnly = new HashMap<String, String>();
      
      for (String key : end.keySet())
      {
         if (initial.get(key) == null)
         {
            endOnly.put(key, end.get(key));
         }
      }
      
      return endOnly;
   }
   
   public static Test suite() throws Exception
   {
      TestSuite suite = new TestSuite();
      suite.addTest(new TestSuite(DeployersInitialTestCase.class));

      AOPTestSetup setup = new AOPTestSetup(suite, "aop-deployertest.sar");
      return setup;
   }
}
