/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.security.sas;

import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;
import org.jacorb.config.Configuration;
import org.jacorb.config.ConfigurationException;
import org.jacorb.security.sas.ISASContext;
import org.omg.CORBA.ORB;
import org.omg.CSIIOP.CompoundSecMechList;
import org.omg.IOP.Codec;
import org.slf4j.Logger;

public class KerberosContext
implements ISASContext {
    private Logger logger;
    private GSSContext validatedContext = null;
    private GSSCredential targetCreds = null;
    private GSSCredential clientCreds = null;

    public void configure(Configuration configuration) throws ConfigurationException {
        this.logger = configuration.getLogger("jacorb.security.sas.Kerberos");
    }

    public void initClient() {
        String string = "";
        try {
            Oid oid = new Oid("oid:1.2.840.113554.1.2.2".substring(4));
            GSSManager gSSManager = GSSManager.getInstance();
            this.clientCreds = gSSManager.createCredential(null, Integer.MAX_VALUE, oid, 1);
        }
        catch (Exception exception) {
            this.logger.warn("Error getting created principal: " + exception);
        }
    }

    public String getMechOID() {
        return "oid:1.2.840.113554.1.2.2".substring(4);
    }

    public byte[] createClientContext(ORB oRB, Codec codec, CompoundSecMechList compoundSecMechList) {
        byte[] byArray = new byte[]{};
        try {
            byte[] byArray2 = compoundSecMechList.mechanism_list[0].as_context_mech.target_name;
            Oid oid = new Oid("oid:1.2.840.113554.1.2.2".substring(4));
            GSSManager gSSManager = GSSManager.getInstance();
            GSSName gSSName = gSSManager.createName(byArray2, null, oid);
            if (this.clientCreds == null) {
                this.clientCreds = gSSManager.createCredential(null, Integer.MAX_VALUE, oid, 1);
            }
            GSSContext gSSContext = gSSManager.createContext(gSSName, oid, this.clientCreds, Integer.MAX_VALUE);
            byArray = gSSContext.initSecContext(byArray, 0, byArray.length);
        }
        catch (Exception exception) {
            this.logger.error("Error creating Kerberos context: " + exception);
        }
        return byArray;
    }

    public String getClientPrincipal() {
        String string = "";
        try {
            Oid oid = new Oid("oid:1.2.840.113554.1.2.2".substring(4));
            GSSManager gSSManager = GSSManager.getInstance();
            if (this.clientCreds == null) {
                this.clientCreds = gSSManager.createCredential(null, Integer.MAX_VALUE, oid, 1);
            }
            string = ((Object)this.clientCreds.getName()).toString();
        }
        catch (Exception exception) {
            this.logger.error("Error getting created principal: " + exception);
        }
        return string;
    }

    public void initTarget() {
        try {
            Oid oid = new Oid("oid:1.2.840.113554.1.2.2".substring(4));
            GSSManager gSSManager = GSSManager.getInstance();
            if (this.targetCreds == null) {
                this.targetCreds = gSSManager.createCredential(null, Integer.MAX_VALUE, oid, 2);
            }
        }
        catch (GSSException gSSException) {
            this.logger.warn("Error accepting Kerberos context: " + gSSException);
        }
    }

    public boolean validateContext(ORB oRB, Codec codec, byte[] byArray) {
        byte[] byArray2 = null;
        try {
            Oid oid = new Oid("oid:1.2.840.113554.1.2.2".substring(4));
            GSSManager gSSManager = GSSManager.getInstance();
            if (this.targetCreds == null) {
                this.targetCreds = gSSManager.createCredential(null, Integer.MAX_VALUE, oid, 2);
            }
            this.validatedContext = gSSManager.createContext(this.targetCreds);
            byArray2 = this.validatedContext.acceptSecContext(byArray, 0, byArray.length);
        }
        catch (GSSException gSSException) {
            this.logger.error("Error accepting Kerberos context: " + gSSException);
        }
        if (byArray2 == null) {
            this.logger.warn("Could not accept token");
            return false;
        }
        return true;
    }

    public String getValidatedPrincipal() {
        if (this.validatedContext == null) {
            return null;
        }
        try {
            return ((Object)this.validatedContext.getSrcName()).toString();
        }
        catch (GSSException gSSException) {
            this.logger.error("Error getting name: " + gSSException);
            return null;
        }
    }
}

