/*
 * Decompiled with CFR 0.152.
 */
package com.ctc.wstx.dom;

import com.ctc.wstx.api.WriterConfig;
import com.ctc.wstx.util.EmptyNamespaceContext;
import javax.xml.namespace.NamespaceContext;
import javax.xml.stream.XMLStreamException;
import javax.xml.transform.dom.DOMResult;
import org.codehaus.stax2.XMLStreamLocation2;
import org.codehaus.stax2.XMLStreamReader2;
import org.codehaus.stax2.XMLStreamWriter2;
import org.codehaus.stax2.validation.ValidationProblemHandler;
import org.codehaus.stax2.validation.XMLValidationSchema;
import org.codehaus.stax2.validation.XMLValidator;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class DOMWrappingWriter
implements XMLStreamWriter2 {
    protected final WriterConfig mConfig;
    protected final boolean mNsAware;
    protected final boolean mNsRepairing;
    protected String mEncoding = null;
    protected NamespaceContext mNsContext;
    protected final Document mDocument;
    protected Element mParentElem;
    protected Element mOpenElement;

    private DOMWrappingWriter(WriterConfig cfg, Node treeRoot) throws XMLStreamException {
        if (treeRoot == null) {
            throw new IllegalArgumentException("Can not pass null Node for constructing a DOM-based XMLStreamWriter");
        }
        this.mConfig = cfg;
        this.mNsAware = cfg.willSupportNamespaces();
        boolean bl = this.mNsRepairing = this.mNsAware && cfg.automaticNamespacesEnabled();
        if (this.mNsRepairing) {
            throw new XMLStreamException("Repairing mode not (yet) supported with DOM-backed writer");
        }
        Element elem = null;
        switch (treeRoot.getNodeType()) {
            case 9: {
                this.mDocument = (Document)treeRoot;
                break;
            }
            case 1: {
                this.mDocument = treeRoot.getOwnerDocument();
                elem = (Element)treeRoot;
                break;
            }
            case 11: {
                this.mDocument = treeRoot.getOwnerDocument();
                break;
            }
            default: {
                throw new XMLStreamException("Can not create an XMLStreamWriter for a DOM node of type " + treeRoot.getClass());
            }
        }
        if (this.mDocument == null) {
            throw new XMLStreamException("Can not create an XMLStreamWriter for given node (of type " + treeRoot.getClass() + "): did not have owner document");
        }
        this.mParentElem = this.mOpenElement = elem;
    }

    public static DOMWrappingWriter createFrom(WriterConfig cfg, DOMResult dst) throws XMLStreamException {
        Node rootNode = dst.getNode();
        return new DOMWrappingWriter(cfg, rootNode);
    }

    @Override
    public void close() {
    }

    @Override
    public void flush() {
    }

    @Override
    public NamespaceContext getNamespaceContext() {
        if (!this.mNsAware) {
            return EmptyNamespaceContext.getInstance();
        }
        return this.mNsContext;
    }

    @Override
    public String getPrefix(String uri) {
        if (!this.mNsAware) {
            return null;
        }
        return null;
    }

    @Override
    public Object getProperty(String name) {
        return null;
    }

    @Override
    public void setDefaultNamespace(String uri) {
    }

    @Override
    public void setNamespaceContext(NamespaceContext context) {
        this.mNsContext = context;
    }

    @Override
    public void setPrefix(String prefix, String uri) {
    }

    @Override
    public void writeAttribute(String localName, String value) {
        this.outputAttribute(null, null, localName, value);
    }

    @Override
    public void writeAttribute(String nsURI, String localName, String value) {
        this.outputAttribute(nsURI, null, localName, value);
    }

    @Override
    public void writeAttribute(String prefix, String nsURI, String localName, String value) {
        this.outputAttribute(nsURI, prefix, localName, value);
    }

    @Override
    public void writeCData(String data) {
        this.appendLeaf(this.mDocument.createCDATASection(data));
    }

    @Override
    public void writeCharacters(char[] text, int start, int len) {
        this.writeCharacters(new String(text, start, len));
    }

    @Override
    public void writeCharacters(String text) {
        this.appendLeaf(this.mDocument.createTextNode(text));
    }

    @Override
    public void writeComment(String data) {
        this.appendLeaf(this.mDocument.createCDATASection(data));
    }

    @Override
    public void writeDefaultNamespace(String nsURI) {
        this.writeNamespace(null, nsURI);
    }

    @Override
    public void writeDTD(String dtd) {
        this.reportUnsupported("writeDTD()");
    }

    @Override
    public void writeEmptyElement(String localName) {
        this.writeEmptyElement(null, localName);
    }

    @Override
    public void writeEmptyElement(String nsURI, String localName) {
        this.createStartElem(nsURI, null, localName, true);
    }

    @Override
    public void writeEmptyElement(String prefix, String localName, String nsURI) {
        this.createStartElem(nsURI, prefix, localName, true);
    }

    @Override
    public void writeEndDocument() {
        this.mOpenElement = null;
        this.mParentElem = null;
    }

    @Override
    public void writeEndElement() {
        if (this.mParentElem == null) {
            throw new IllegalStateException("No open start element to close");
        }
        this.mOpenElement = null;
        Node parent = this.mParentElem.getParentNode();
        this.mParentElem = parent == this.mDocument ? null : (Element)parent;
    }

    @Override
    public void writeEntityRef(String name) {
        this.appendLeaf(this.mDocument.createEntityReference(name));
    }

    @Override
    public void writeNamespace(String prefix, String nsURI) {
        boolean defNS;
        boolean bl = defNS = prefix == null || prefix.length() == 0;
        if (!this.mNsAware) {
            if (defNS) {
                this.outputAttribute(null, null, "xmlns", nsURI);
            } else {
                this.outputAttribute(null, "xmlns", prefix, nsURI);
            }
        } else if (defNS) {
            this.outputAttribute("http://www.w3.org/2000/xmlns/", null, "xmlns", nsURI);
        } else {
            this.outputAttribute("http://www.w3.org/2000/xmlns/", "xmlns", prefix, nsURI);
        }
    }

    @Override
    public void writeProcessingInstruction(String target) {
        this.writeProcessingInstruction(target, null);
    }

    @Override
    public void writeProcessingInstruction(String target, String data) {
        this.appendLeaf(this.mDocument.createProcessingInstruction(target, data));
    }

    public void writeSpace(char[] text, int start, int len) {
        this.writeSpace(new String(text, start, len));
    }

    public void writeSpace(String text) {
        this.writeCharacters(text);
    }

    @Override
    public void writeStartDocument() {
        this.writeStartDocument("UTF-8", "1.0");
    }

    @Override
    public void writeStartDocument(String version) {
        this.writeStartDocument(null, version);
    }

    @Override
    public void writeStartDocument(String encoding, String version) {
        this.mEncoding = encoding;
    }

    @Override
    public void writeStartElement(String localName) {
        this.writeStartElement(null, localName);
    }

    @Override
    public void writeStartElement(String nsURI, String localName) {
        this.createStartElem(nsURI, null, localName, false);
    }

    @Override
    public void writeStartElement(String prefix, String localName, String nsURI) {
        this.createStartElem(nsURI, prefix, localName, false);
    }

    @Override
    public boolean isPropertySupported(String name) {
        return this.mConfig.isPropertySupported(name);
    }

    @Override
    public boolean setProperty(String name, Object value) {
        return this.mConfig.setProperty(name, value);
    }

    @Override
    public XMLValidator validateAgainst(XMLValidationSchema schema) throws XMLStreamException {
        return null;
    }

    @Override
    public XMLValidator stopValidatingAgainst(XMLValidationSchema schema) throws XMLStreamException {
        return null;
    }

    @Override
    public XMLValidator stopValidatingAgainst(XMLValidator validator) throws XMLStreamException {
        return null;
    }

    @Override
    public ValidationProblemHandler setValidationProblemHandler(ValidationProblemHandler h) {
        return null;
    }

    @Override
    public XMLStreamLocation2 getLocation() {
        return null;
    }

    @Override
    public String getEncoding() {
        return this.mEncoding;
    }

    @Override
    public void writeCData(char[] text, int start, int len) throws XMLStreamException {
        this.writeCData(new String(text, start, len));
    }

    @Override
    public void writeDTD(String rootName, String systemId, String publicId, String internalSubset) throws XMLStreamException {
        if (this.mParentElem != null) {
            throw new IllegalStateException("Operation only allowed to the document before adding root element");
        }
        this.reportUnsupported("writeDTD()");
    }

    @Override
    public void writeFullEndElement() throws XMLStreamException {
        this.writeEndElement();
    }

    @Override
    public void writeStartDocument(String version, String encoding, boolean standAlone) throws XMLStreamException {
        this.writeStartDocument(encoding, version);
    }

    @Override
    public void writeRaw(String text) throws XMLStreamException {
        this.reportUnsupported("writeRaw()");
    }

    @Override
    public void writeRaw(String text, int start, int offset) throws XMLStreamException {
        this.reportUnsupported("writeRaw()");
    }

    @Override
    public void writeRaw(char[] text, int offset, int length) throws XMLStreamException {
        this.reportUnsupported("writeRaw()");
    }

    @Override
    public void copyEventFromReader(XMLStreamReader2 r, boolean preserveEventData) throws XMLStreamException {
    }

    protected void appendLeaf(Node n) throws IllegalStateException {
        if (this.mParentElem == null) {
            this.mDocument.appendChild(n);
        } else {
            this.mOpenElement = null;
            this.mParentElem.appendChild(n);
        }
    }

    protected void createStartElem(String nsURI, String prefix, String localName, boolean isEmpty) {
        Element elem;
        if (this.mNsAware) {
            if (this.mNsRepairing) {
                // empty if block
            }
            if (prefix != null && prefix.length() > 0) {
                localName = prefix + ":" + localName;
            }
            elem = this.mDocument.createElementNS(nsURI, localName);
        } else {
            if (prefix != null && prefix.length() > 0) {
                localName = prefix + ":" + localName;
            }
            elem = this.mDocument.createElement(localName);
        }
        this.appendLeaf(elem);
        this.mOpenElement = elem;
        if (!isEmpty) {
            this.mParentElem = elem;
        }
    }

    protected void outputAttribute(String nsURI, String prefix, String localName, String value) {
        if (this.mOpenElement == null) {
            throw new IllegalStateException("No currently open START_ELEMENT, cannot write attribute");
        }
        if (this.mNsAware) {
            if (this.mNsRepairing) {
                // empty if block
            }
            if (prefix != null && prefix.length() > 0) {
                localName = prefix + ":" + localName;
            }
            this.mOpenElement.setAttributeNS(nsURI, localName, value);
        } else {
            if (prefix != null && prefix.length() > 0) {
                localName = prefix + ":" + localName;
            }
            this.mOpenElement.setAttribute(localName, value);
        }
    }

    private void reportUnsupported(String operName) {
        throw new UnsupportedOperationException(operName + " can not be used with DOM-backed writer");
    }
}

