/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cache.entry;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.hibernate.cache.entry.CacheEntryStructure;
import org.hibernate.cache.entry.CollectionCacheEntry;
import org.hibernate.engine.SessionFactoryImplementor;

public class StructuredMapCacheEntry
implements CacheEntryStructure {
    @Override
    public Object structure(Object item) {
        CollectionCacheEntry entry = (CollectionCacheEntry)item;
        Serializable[] state = entry.getState();
        HashMap<Serializable, Serializable> map = new HashMap<Serializable, Serializable>(state.length);
        int i = 0;
        while (i < state.length) {
            map.put(state[i++], state[i++]);
        }
        return map;
    }

    @Override
    public Object destructure(Object item, SessionFactoryImplementor factory) {
        Map map = (Map)item;
        Serializable[] state = new Serializable[map.size() * 2];
        int i = 0;
        for (Map.Entry me : map.entrySet()) {
            state[i++] = (Serializable)me.getKey();
            state[i++] = (Serializable)me.getValue();
        }
        return new CollectionCacheEntry((Serializable)state);
    }
}

