/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.collection;

import java.io.Serializable;
import java.util.List;
import org.dom4j.Element;
import org.dom4j.Node;
import org.hibernate.HibernateException;
import org.hibernate.collection.PersistentIndexedElementHolder;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.type.NullableType;
import org.hibernate.type.Type;

public class PersistentMapElementHolder
extends PersistentIndexedElementHolder {
    public PersistentMapElementHolder(SessionImplementor session, Element element) {
        super(session, element);
    }

    public PersistentMapElementHolder(SessionImplementor session, CollectionPersister persister, Serializable key) throws HibernateException {
        super(session, persister, key);
    }

    @Override
    public void initializeFromCache(CollectionPersister persister, Serializable disassembled, Object owner) throws HibernateException {
        Type elementType = persister.getElementType();
        Type indexType = persister.getIndexType();
        String indexNodeName = PersistentMapElementHolder.getIndexAttributeName(persister);
        Serializable[] cached = (Serializable[])disassembled;
        int i = 0;
        while (i < cached.length) {
            Object index = indexType.assemble(cached[i++], this.getSession(), owner);
            Object object = elementType.assemble(cached[i++], this.getSession(), owner);
            Element subelement = this.element.addElement(persister.getElementNodeName());
            elementType.setToXMLNode((Node)subelement, object, persister.getFactory());
            String indexString = ((NullableType)indexType).toXMLString(index, persister.getFactory());
            PersistentMapElementHolder.setIndex(subelement, indexNodeName, indexString);
        }
    }

    @Override
    public Serializable disassemble(CollectionPersister persister) throws HibernateException {
        Type elementType = persister.getElementType();
        Type indexType = persister.getIndexType();
        String indexNodeName = PersistentMapElementHolder.getIndexAttributeName(persister);
        List elements = this.element.elements(persister.getElementNodeName());
        int length = elements.size();
        Serializable[] result = new Serializable[length * 2];
        int i = 0;
        while (i < length * 2) {
            Element elem = (Element)elements.get(i / 2);
            Object object = elementType.fromXMLNode((Node)elem, persister.getFactory());
            String indexString = PersistentMapElementHolder.getIndex(elem, indexNodeName, i);
            Object index = ((NullableType)indexType).fromXMLString(indexString, persister.getFactory());
            result[i++] = indexType.disassemble(index, this.getSession(), null);
            result[i++] = elementType.disassemble(object, this.getSession(), null);
        }
        return result;
    }
}

