/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.loading;

import java.io.Serializable;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.hibernate.CacheMode;
import org.hibernate.EntityMode;
import org.hibernate.HibernateException;
import org.hibernate.cache.CacheKey;
import org.hibernate.cache.entry.CollectionCacheEntry;
import org.hibernate.collection.PersistentCollection;
import org.hibernate.engine.CollectionEntry;
import org.hibernate.engine.CollectionKey;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.engine.Status;
import org.hibernate.engine.loading.LoadContexts;
import org.hibernate.engine.loading.LoadingCollectionEntry;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.pretty.MessageHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CollectionLoadContext {
    private static final Logger log = LoggerFactory.getLogger(CollectionLoadContext.class);
    private final LoadContexts loadContexts;
    private final ResultSet resultSet;
    private Set localLoadingCollectionKeys = new HashSet();

    public CollectionLoadContext(LoadContexts loadContexts, ResultSet resultSet) {
        this.loadContexts = loadContexts;
        this.resultSet = resultSet;
    }

    public ResultSet getResultSet() {
        return this.resultSet;
    }

    public LoadContexts getLoadContext() {
        return this.loadContexts;
    }

    public PersistentCollection getLoadingCollection(CollectionPersister persister, Serializable key) {
        LoadingCollectionEntry loadingCollectionEntry;
        EntityMode em = this.loadContexts.getPersistenceContext().getSession().getEntityMode();
        CollectionKey collectionKey = new CollectionKey(persister, key, em);
        if (log.isTraceEnabled()) {
            log.trace("starting attempt to find loading collection [" + MessageHelper.collectionInfoString(persister.getRole(), key) + "]");
        }
        if ((loadingCollectionEntry = this.loadContexts.locateLoadingCollectionEntry(collectionKey)) == null) {
            PersistentCollection collection = this.loadContexts.getPersistenceContext().getCollection(collectionKey);
            if (collection != null) {
                if (collection.wasInitialized()) {
                    log.trace("collection already initialized; ignoring");
                    return null;
                }
                log.trace("collection not yet initialized; initializing");
            } else {
                boolean newlySavedEntity;
                Object owner = this.loadContexts.getPersistenceContext().getCollectionOwner(key, persister);
                boolean bl = newlySavedEntity = owner != null && this.loadContexts.getPersistenceContext().getEntry(owner).getStatus() != Status.LOADING && em != EntityMode.DOM4J;
                if (newlySavedEntity) {
                    log.trace("owning entity already loaded; ignoring");
                    return null;
                }
                if (log.isTraceEnabled()) {
                    log.trace("instantiating new collection [key=" + key + ", rs=" + this.resultSet + "]");
                }
                collection = persister.getCollectionType().instantiate(this.loadContexts.getPersistenceContext().getSession(), persister, key);
            }
            collection.beforeInitialize(persister, -1);
            collection.beginRead();
            this.localLoadingCollectionKeys.add(collectionKey);
            this.loadContexts.registerLoadingCollectionXRef(collectionKey, new LoadingCollectionEntry(this.resultSet, persister, key, collection));
            return collection;
        }
        if (loadingCollectionEntry.getResultSet() == this.resultSet) {
            log.trace("found loading collection bound to current result set processing; reading row");
            return loadingCollectionEntry.getCollection();
        }
        log.trace("collection is already being initialized; ignoring row");
        return null;
    }

    public void endLoadingCollections(CollectionPersister persister, Object loadedEntity) {
        SessionImplementor session = this.getLoadContext().getPersistenceContext().getSession();
        if (!this.loadContexts.hasLoadingCollectionEntries() && this.localLoadingCollectionKeys.isEmpty()) {
            return;
        }
        ArrayList<LoadingCollectionEntry> matches = null;
        Iterator iter = this.localLoadingCollectionKeys.iterator();
        while (iter.hasNext()) {
            CollectionKey collectionKey = (CollectionKey)iter.next();
            LoadingCollectionEntry lce = this.loadContexts.locateLoadingCollectionEntry(collectionKey);
            if (lce == null) {
                log.warn("In CollectionLoadContext#endLoadingCollections, localLoadingCollectionKeys contained [" + collectionKey + "], but no LoadingCollectionEntry was found in loadContexts");
                continue;
            }
            if (lce.getResultSet() != this.resultSet || lce.getPersister() != persister) continue;
            if (lce.getCollection().getOwner() == null) {
                session.getPersistenceContext().addUnownedCollection(new CollectionKey(persister, lce.getKey(), session.getEntityMode()), lce.getCollection());
            } else if (loadedEntity != null && lce.getCollection().getOwner() != loadedEntity) continue;
            if (matches == null) {
                matches = new ArrayList<LoadingCollectionEntry>();
            }
            matches.add(lce);
            if (log.isTraceEnabled()) {
                log.trace("removing collection load entry [" + lce + "]");
            }
            this.loadContexts.unregisterLoadingCollectionXRef(collectionKey);
            iter.remove();
        }
        this.endLoadingCollections(persister, matches);
        if (this.localLoadingCollectionKeys.isEmpty()) {
            this.loadContexts.cleanup(this.resultSet);
        }
    }

    private void endLoadingCollections(CollectionPersister persister, List matchedCollectionEntries) {
        if (matchedCollectionEntries == null) {
            if (log.isDebugEnabled()) {
                log.debug("no collections were found in result set for role: " + persister.getRole());
            }
            return;
        }
        int count = matchedCollectionEntries.size();
        if (log.isDebugEnabled()) {
            log.debug(count + " collections were found in result set for role: " + persister.getRole());
        }
        for (int i = 0; i < count; ++i) {
            LoadingCollectionEntry lce = (LoadingCollectionEntry)matchedCollectionEntries.get(i);
            this.endLoadingCollection(lce, persister);
        }
        if (log.isDebugEnabled()) {
            log.debug(count + " collections initialized for role: " + persister.getRole());
        }
    }

    private void endLoadingCollection(LoadingCollectionEntry lce, CollectionPersister persister) {
        boolean addToCache;
        CollectionEntry ce;
        if (log.isTraceEnabled()) {
            log.debug("ending loading collection [" + lce + "]");
        }
        SessionImplementor session = this.getLoadContext().getPersistenceContext().getSession();
        EntityMode em = session.getEntityMode();
        boolean hasNoQueuedAdds = lce.getCollection().endRead();
        if (persister.getCollectionType().hasHolder(em)) {
            this.getLoadContext().getPersistenceContext().addCollectionHolder(lce.getCollection());
        }
        if ((ce = this.getLoadContext().getPersistenceContext().getCollectionEntry(lce.getCollection())) == null) {
            ce = this.getLoadContext().getPersistenceContext().addInitializedCollection(persister, lce.getCollection(), lce.getKey());
        } else {
            ce.postInitialize(lce.getCollection());
        }
        boolean bl = addToCache = hasNoQueuedAdds && persister.hasCache() && session.getCacheMode().isPutEnabled() && !ce.isDoremove();
        if (addToCache) {
            this.addCollectionToCache(lce, persister);
        }
        if (log.isDebugEnabled()) {
            log.debug("collection fully initialized: " + MessageHelper.collectionInfoString(persister, lce.getKey(), session.getFactory()));
        }
        if (session.getFactory().getStatistics().isStatisticsEnabled()) {
            session.getFactory().getStatisticsImplementor().loadCollection(persister.getRole());
        }
    }

    private void addCollectionToCache(LoadingCollectionEntry lce, CollectionPersister persister) {
        Object version;
        SessionImplementor session = this.getLoadContext().getPersistenceContext().getSession();
        SessionFactoryImplementor factory = session.getFactory();
        if (log.isDebugEnabled()) {
            log.debug("Caching collection: " + MessageHelper.collectionInfoString(persister, lce.getKey(), factory));
        }
        if (!session.getEnabledFilters().isEmpty() && persister.isAffectedByEnabledFilters(session)) {
            log.debug("Refusing to add to cache due to enabled filters");
            return;
        }
        if (persister.isVersioned()) {
            Object collectionOwner = this.getLoadContext().getPersistenceContext().getCollectionOwner(lce.getKey(), persister);
            if (collectionOwner == null && lce.getCollection() != null) {
                Object linkedOwner = lce.getCollection().getOwner();
                if (linkedOwner != null) {
                    Serializable ownerKey = persister.getOwnerEntityPersister().getIdentifier(linkedOwner, session.getEntityMode());
                    collectionOwner = this.getLoadContext().getPersistenceContext().getCollectionOwner(ownerKey, persister);
                }
                if (collectionOwner == null) {
                    throw new HibernateException("Unable to resolve owner of loading collection [" + MessageHelper.collectionInfoString(persister, lce.getKey(), factory) + "] for second level caching");
                }
            }
            version = this.getLoadContext().getPersistenceContext().getEntry(collectionOwner).getVersion();
        } else {
            version = null;
        }
        CollectionCacheEntry entry = new CollectionCacheEntry(lce.getCollection(), persister);
        CacheKey cacheKey = new CacheKey(lce.getKey(), persister.getKeyType(), persister.getRole(), session.getEntityMode(), session.getFactory());
        boolean put = persister.getCacheAccessStrategy().putFromLoad(cacheKey, persister.getCacheEntryStructure().structure(entry), session.getTimestamp(), version, factory.getSettings().isMinimalPutsEnabled() && session.getCacheMode() != CacheMode.REFRESH);
        if (put && factory.getStatistics().isStatisticsEnabled()) {
            factory.getStatisticsImplementor().secondLevelCachePut(persister.getCacheAccessStrategy().getRegion().getName());
        }
    }

    void cleanup() {
        if (!this.localLoadingCollectionKeys.isEmpty()) {
            log.warn("On CollectionLoadContext#cleanup, localLoadingCollectionKeys contained [" + this.localLoadingCollectionKeys.size() + "] entries");
        }
        this.loadContexts.cleanupCollectionXRefs(this.localLoadingCollectionKeys);
        this.localLoadingCollectionKeys.clear();
    }

    public String toString() {
        return super.toString() + "<rs=" + this.resultSet + ">";
    }
}

