/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.eviction;

import org.jboss.cache.config.EvictionAlgorithmConfig;
import org.jboss.cache.eviction.BaseEvictionAlgorithm;
import org.jboss.cache.eviction.EvictionEvent;
import org.jboss.cache.eviction.EvictionException;
import org.jboss.cache.eviction.EvictionQueue;
import org.jboss.cache.eviction.MRUAlgorithmConfig;
import org.jboss.cache.eviction.MRUQueue;
import org.jboss.cache.eviction.NodeEntry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MRUAlgorithm
extends BaseEvictionAlgorithm {
    @Override
    protected EvictionQueue setupEvictionQueue() throws EvictionException {
        return new MRUQueue();
    }

    @Override
    protected boolean shouldEvictNode(NodeEntry ne) {
        if (this.isYoungerThanMinimumTimeToLive(ne)) {
            return false;
        }
        MRUAlgorithmConfig config = (MRUAlgorithmConfig)this.evictionAlgorithmConfig;
        return config.getMaxNodes() > -1 && this.evictionQueue.getNumberOfNodes() > config.getMaxNodes();
    }

    @Override
    protected void processVisitedNodes(EvictionEvent evictedEventNode) throws EvictionException {
        super.processVisitedNodes(evictedEventNode);
        ((MRUQueue)this.evictionQueue).moveToTopOfStack(evictedEventNode.getFqn());
    }

    @Override
    public Class<? extends EvictionAlgorithmConfig> getConfigurationClass() {
        return MRUAlgorithmConfig.class;
    }
}

