/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.on.embedded.ui.nav;

import org.jboss.on.embedded.ui.nav.BaseTreeNode;
import org.jboss.on.embedded.ui.nav.TreeNodeWithResourceType;
import org.rhq.core.domain.resource.Resource;
import org.rhq.core.domain.resource.ResourceType;

public abstract class ResourceTypeTreeNode
extends BaseTreeNode
implements TreeNodeWithResourceType {
    private ResourceType resourceType;
    private Resource parentResource;

    public ResourceTypeTreeNode(String key, ResourceType type, Resource parentResource) {
        super(key);
        if (type == null) {
            throw new IllegalArgumentException("ResourceTypeTreeNode requires a ResourceType. Null was passed into the constructor");
        }
        if (parentResource == null) {
            throw new IllegalArgumentException("ResourceTypeTreeNode requires a Resource. Null was passed into the constructor");
        }
        this.setResourceType(type);
        this.parentResource = parentResource;
    }

    public Resource getClosestResource() {
        return this.parentResource;
    }

    public void setResourceType(ResourceType resourceType) {
        this.resourceType = resourceType;
    }

    public ResourceType getResourceType() {
        return this.resourceType;
    }

    public String getDescription() {
        String description = this.getResourceType().getDescription();
        if (description.length() >= 1) {
            String returnDescription = Character.toUpperCase(description.charAt(0)) + description.substring(1);
            return returnDescription;
        }
        return description;
    }

    public Resource getParentResource() {
        return this.parentResource;
    }
}

